/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import javax.swing.text.StyleContext;

public class CaseAwareTextDisplay
extends Canvas
implements Serializable {
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    public static final int FIRST_IN_CAPS = 3;
    public static final String TEXT = "text";
    public static final String TOP_MARGIN = "topMargin";
    public static final String LEFT_MARGIN = "leftMargin";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String TEXT_CASE = "textCase";
    public static final String FONT = "font";
    static final long serialVersionUID = -6141230100503340864L;
    protected String text = "default text";
    protected int topMargin = 4;
    protected int leftMargin = 4;
    protected int textCase = 0;
    protected PropertyChangeSupport propertyListenerSupport;
    protected VetoableChangeSupport vetoListenerSupport;

    public CaseAwareTextDisplay() {
        this.setSize(180, 30);
        this.propertyListenerSupport = new PropertyChangeSupport(this);
        this.vetoListenerSupport = new VetoableChangeSupport(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange(TEXT, string2, this.text);
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int n) {
        int n2 = this.topMargin;
        this.topMargin = n;
        this.firePropertyChange(TOP_MARGIN, new Integer(n2), new Integer(this.topMargin));
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int n) {
        int n2 = this.leftMargin;
        this.leftMargin = n;
        this.firePropertyChange(LEFT_MARGIN, new Integer(n2), new Integer(this.leftMargin));
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        try {
            this.fireVetoableChange(FOREGROUND, color2, color);
            super.setForeground(color);
            this.firePropertyChange(FOREGROUND, color2, color);
            this.repaint();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        try {
            this.fireVetoableChange(BACKGROUND, color2, color);
            super.setBackground(color);
            this.firePropertyChange(BACKGROUND, color2, color);
            this.repaint();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getTextCase() {
        return this.textCase;
    }

    public void setTextCase(int n) {
        int n2 = this.textCase;
        this.textCase = n;
        this.firePropertyChange(TEXT_CASE, new Integer(n2), new Integer(this.textCase));
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Object object;
        String string = this.getText();
        if (string == null) {
            string = " ";
        }
        switch (this.textCase) {
            case 1: {
                string = string.toUpperCase();
                break;
            }
            case 2: {
                string = string.toLowerCase();
                break;
            }
            case 3: {
                string = string.toLowerCase();
                object = string.toCharArray();
                Object object2 = 32;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object2 == 32) {
                        object[i] = Character.toUpperCase((char)object[i]);
                    }
                    object2 = object[i];
                }
                string = new String((char[])object);
                break;
            }
        }
        object = this.getBounds();
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        FontMetrics fontMetrics = StyleContext.getDefaultStyleContext().getFontMetrics(font);
        int n = this.leftMargin;
        int n2 = this.topMargin + fontMetrics.getAscent();
        Color color = this.getBackground() == null ? Color.white : this.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
        color = this.getForeground() == null ? Color.black : this.getForeground();
        graphics.setColor(color);
        graphics.setFont(this.getFont());
        graphics.drawString(string, n, n2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListenerSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListenerSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyListenerSupport.firePropertyChange(string, object, object2);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListenerSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListenerSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetoListenerSupport.fireVetoableChange(string, object, object2);
    }
}

