/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import org.joone.edit.JoonEdit;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;

public class AboutFrame
extends JDialog {
    private static final ILogger log = LoggerFactory.getLogger(AboutFrame.class);
    private static final String[] ABOUT_TEXT = new String[]{"Joone - Java Object Oriented Neural Engine", "http://www.joone.org", "pmarrone@users.sourceforge.net"};
    private static final String[] HALL_OF_FAME = new String[]{"Joone was developed by Paolo Marrone,", "with the valuable collaboration of:", "   Gavin Alford, Mark Allen, Jan Boonen, Yan Cheng Cheok,", "   Ka-Hing Cheung, Andrea Corti, Huascar Fiorletta, Firestrand,", "   Pascal Deschenes, Jan Erik Garshol, Harry Glasgow,", "   Jack Hawkins, Nathan Hindley, Olivier Hussenet,", "   Boris Jansen, Shen Linlin, Casey Marshall, Julien Norman,", "   Christian Ribeaud, Anat Rozenzon, Trevis Silvers,", "   Paul Sinclair, Thomas Lionel Smets, Jerry R.Vos"};
    private static final String[] EXTERNAL_PACK = new String[]{"Joone uses the following external packages:", "   JHotDraw - http://sourceforge.net/projects/jhotdraw", "   BeanShell - http://www.beanshell.org", "   Groovy - http://groovy.codehaus.org", "   jEdit-Syntax - http://sourceforge.net/projects/jedit-syntax", "   Log4j -  http://jakarta.apache.org/log4j", "   HSSF-POI - http://jakarta.apache.org/poi", "   L2FProd - http://common.l2fprod.com", "   NachoCalendar - http://nachocalendar.sourceforge.net", "   XStream - http://xstream.codehaus.org", "   VisAD - http://www.ssec.wisc.edu/~billh/visad.html"};

    AboutFrame(Frame frame) {
        Component component;
        this.setModal(true);
        JRootPane jRootPane = new JRootPane();
        this.setRootPane(jRootPane);
        jRootPane.setLayout(new BorderLayout());
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        final Image image = iconkit.loadImageResource("/org/joone/images/jooneShadowSmall.gif");
        if (image != null) {
            component = new Panel(){

                public void paint(Graphics graphics) {
                    graphics.drawImage(image, 0, 0, this);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(84, 87);
                }
            };
            jRootPane.add(component, "West");
        }
        component = new Button("   OK   ");
        ((Button)component).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutFrame.this.dispose();
            }
        });
        Panel panel = new Panel();
        panel.add(component);
        jRootPane.add((Component)panel, "South");
        TextBlock textBlock = new TextBlock(ABOUT_TEXT, HALL_OF_FAME, EXTERNAL_PACK);
        jRootPane.add((Component)textBlock, "Center");
        this.setTitle("About Joone");
        this.setBackground(Color.white);
        this.setResizable(false);
        this.pack();
    }

    public void place(int n, int n2) {
        this.setLocation(n - this.getWidth() / 2, n2 - this.getHeight() / 2);
    }

    class TextBlock
    extends Canvas {
        private static final int TEXT_PADDING = 5;
        private String[] lines;

        public TextBlock(String[] stringArray, String[] stringArray2, String[] stringArray3) {
            int n;
            Serializable serializable;
            String string = "unknown";
            Integer n2 = null;
            try {
                serializable = new NeuralNet();
                Method method = serializable.getClass().getMethod("getVersion", new Class[0]);
                if (method != null) {
                    string = (String)method.invoke((Object)serializable, new Object[0]);
                }
                if ((method = serializable.getClass().getMethod("getNumericVersion", new Class[0])) != null) {
                    n2 = (Integer)method.invoke((Object)serializable, new Object[0]);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                log.warn("IllegalAccessException getting NeuralNetwork version. Message is " + illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                log.warn("InvocationTargetException getting NeuralNetwork version. Message is : " + invocationTargetException.getMessage(), invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.warn("NoSuchMethodException getting NeuralNetwork version. Do not panic. Message is : " + noSuchMethodException.getMessage(), noSuchMethodException);
            }
            serializable = new ArrayList();
            for (n = 0; n < stringArray.length; ++n) {
                serializable.add(stringArray[n]);
            }
            serializable.add("");
            serializable.add("Editor version: " + JoonEdit.getVersion());
            serializable.add("Engine version: " + string);
            if (n2 == null || n2 < JoonEdit.getNumericRecommendedEngineVersion()) {
                serializable.add("Engine version " + JoonEdit.getRecommendedEngineVersion() + " or above recommended");
            }
            serializable.add("");
            for (n = 0; n < stringArray2.length; ++n) {
                serializable.add(stringArray2[n]);
            }
            serializable.add("");
            for (n = 0; n < stringArray3.length; ++n) {
                serializable.add(stringArray3[n]);
            }
            this.lines = new String[serializable.size()];
            Iterator iterator = serializable.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                this.lines[n3++] = (String)iterator.next();
            }
        }

        public void paint(Graphics graphics) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getAscent();
            int n2 = fontMetrics.getHeight();
            for (int i = 0; i < this.lines.length; ++i) {
                graphics.drawString(this.lines[i], 5, i * n2 + n + 5);
            }
        }

        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getHeight();
            int n2 = 0;
            for (int i = 0; i < this.lines.length; ++i) {
                if (fontMetrics.stringWidth(this.lines[i]) <= n2) continue;
                n2 = fontMetrics.stringWidth(this.lines[i]);
            }
            return new Dimension(n2 + 10, this.lines.length * n + 10);
        }
    }
}

