/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private long bytesRead;
    private long limit;

    public LimitedInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.limit = l;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesRemaining() {
        long l = this.limit - this.bytesRead;
        return l;
    }

    public int available() throws IOException {
        long l;
        int n = this.in.available();
        return (long)n > (l = this.getBytesRemaining()) ? (int)l : n;
    }

    public int read() throws IOException {
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            ++this.bytesRead;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        long l = this.getBytesRemaining();
        if ((long)n2 > l) {
            n2 = (int)l;
        }
        int n3 = this.in.read(byArray, n, n2);
        this.bytesRead += (long)n3;
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        if (this.bytesRead >= this.limit) {
            return -1L;
        }
        long l2 = this.getBytesRemaining();
        if (l > l2) {
            l = l2;
        }
        long l3 = this.in.skip(l);
        this.bytesRead += l3;
        return l3;
    }

    public long skipAll() throws IOException {
        return this.skip(this.getBytesRemaining());
    }

    public void close() throws IOException {
        this.skipAll();
    }
}

