/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Mapping;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

class Mapping0
extends Mapping {
    private int[] magnitudes;
    private int[] angles;
    private int[] mux;
    private int[] submapFloors;
    private int[] submapResidues;

    protected Mapping0(VorbisStream vorbisStream, BitInputStream bitInputStream, SetupHeader setupHeader) throws VorbisFormatException, IOException {
        int n;
        int n2;
        int n3 = 1;
        if (bitInputStream.getBit()) {
            n3 = bitInputStream.getInt(4) + 1;
        }
        int n4 = vorbisStream.getIdentificationHeader().getChannels();
        int n5 = Util.ilog(n4 - 1);
        if (bitInputStream.getBit()) {
            n2 = bitInputStream.getInt(8) + 1;
            this.magnitudes = new int[n2];
            this.angles = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.magnitudes[n] = bitInputStream.getInt(n5);
                this.angles[n] = bitInputStream.getInt(n5);
                if (this.magnitudes[n] != this.angles[n] && this.magnitudes[n] < n4 && this.angles[n] < n4) continue;
                System.err.println(this.magnitudes[n]);
                System.err.println(this.angles[n]);
                throw new VorbisFormatException("The channel magnitude and/or angle mismatch.");
            }
        } else {
            this.magnitudes = new int[0];
            this.angles = new int[0];
        }
        if (bitInputStream.getInt(2) != 0) {
            throw new VorbisFormatException("A reserved mapping field has an invalid value.");
        }
        this.mux = new int[n4];
        if (n3 > 1) {
            for (n2 = 0; n2 < n4; ++n2) {
                this.mux[n2] = bitInputStream.getInt(4);
                if (this.mux[n2] <= n3) continue;
                throw new VorbisFormatException("A mapping mux value is higher than the number of submaps");
            }
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                this.mux[n2] = 0;
            }
        }
        this.submapFloors = new int[n3];
        this.submapResidues = new int[n3];
        n2 = setupHeader.getFloors().length;
        n = setupHeader.getResidues().length;
        for (int i = 0; i < n3; ++i) {
            bitInputStream.getInt(8);
            this.submapFloors[i] = bitInputStream.getInt(8);
            this.submapResidues[i] = bitInputStream.getInt(8);
            if (this.submapFloors[i] > n2) {
                throw new VorbisFormatException("A mapping floor value is higher than the number of floors.");
            }
            if (this.submapResidues[i] <= n) continue;
            throw new VorbisFormatException("A mapping residue value is higher than the number of residues.");
        }
    }

    protected int getType() {
        return 0;
    }

    protected int[] getAngles() {
        return this.angles;
    }

    protected int[] getMagnitudes() {
        return this.magnitudes;
    }

    protected int[] getMux() {
        return this.mux;
    }

    protected int[] getSubmapFloors() {
        return this.submapFloors;
    }

    protected int[] getSubmapResidues() {
        return this.submapResidues;
    }

    protected int getCouplingSteps() {
        return this.angles.length;
    }

    protected int getSubmaps() {
        return this.submapFloors.length;
    }
}

