/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.util.audio;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;

public class FadeableAudioInputStream
extends AudioInputStream {
    private AudioInputStream stream;
    private boolean fading = false;
    private double phi = 0.0;

    public FadeableAudioInputStream(AudioInputStream audioInputStream) throws IOException {
        super(audioInputStream, audioInputStream.getFormat(), -1L);
    }

    public void fadeOut() {
        this.fading = true;
        this.phi = 0.0;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (this.fading) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            double d = 0.0;
            for (int i = n; i < n + n3; i += 4) {
                n4 = i;
                n5 = byArray[n4++] & 0xFF;
                n5 |= byArray[n4++] << 8;
                n6 = byArray[n4++] & 0xFF;
                n6 |= byArray[n4] << 8;
                if (this.phi < 1.5707963267948966) {
                    this.phi += 1.5E-5;
                }
                d = Math.cos(this.phi);
                n5 = (int)((double)n5 * d);
                n6 = (int)((double)n6 * d);
                n4 = i;
                byArray[n4++] = (byte)(n5 & 0xFF);
                byArray[n4++] = (byte)(n5 >> 8 & 0xFF);
                byArray[n4++] = (byte)(n6 & 0xFF);
                byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
            }
        }
        return n3;
    }
}

