/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class CachedUrlStream
implements PhysicalOggStream {
    private boolean closed = false;
    private URLConnection source;
    private InputStream sourceStream;
    private Object drainLock = new Object();
    private RandomAccessFile drain;
    private byte[] memoryCache;
    private ArrayList pageOffsets = new ArrayList();
    private ArrayList pageLengths = new ArrayList();
    private long numberOfSamples = -1L;
    private long cacheLength;
    private HashMap logicalStreams = new HashMap();
    private LoaderThread loaderThread;

    public CachedUrlStream(URL uRL) throws OggFormatException, IOException {
        this(uRL, null);
    }

    public CachedUrlStream(URL uRL, RandomAccessFile randomAccessFile) throws OggFormatException, IOException {
        this.source = uRL.openConnection();
        if (randomAccessFile == null) {
            int n = this.source.getContentLength();
            if (n == -1) {
                throw new IOException("The URLConncetion's content length must be set when operating with a in-memory cache.");
            }
            this.memoryCache = new byte[n];
        }
        this.drain = randomAccessFile;
        this.sourceStream = this.source.getInputStream();
        this.loaderThread = new LoaderThread(this.sourceStream, randomAccessFile, this.memoryCache);
        new Thread(this.loaderThread).start();
        while (!this.loaderThread.isBosDone() || this.pageOffsets.size() < 20) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    public long getCacheLength() {
        return this.cacheLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OggPage getOggPage(int n) throws IOException {
        Object object = this.drainLock;
        synchronized (object) {
            Long l = (Long)this.pageOffsets.get(n);
            Long l2 = (Long)this.pageLengths.get(n);
            if (l != null) {
                if (this.drain != null) {
                    this.drain.seek(l);
                    return OggPage.create(this.drain);
                }
                byte[] byArray = new byte[l2.intValue()];
                System.arraycopy(this.memoryCache, l.intValue(), byArray, 0, l2.intValue());
                return OggPage.create(byArray);
            }
            return null;
        }
    }

    private LogicalOggStream getLogicalStream(int n) {
        return (LogicalOggStream)this.logicalStreams.get(new Integer(n));
    }

    public void setTime(long l) throws IOException {
        for (LogicalOggStream logicalOggStream : this.logicalStreams.values()) {
            logicalOggStream.setTime(l);
        }
    }

    public boolean isSeekable() {
        return true;
    }

    public class LoaderThread
    implements Runnable {
        private InputStream source;
        private RandomAccessFile drain;
        private byte[] memoryCache;
        private boolean bosDone = false;
        private int pageNumber;

        public LoaderThread(InputStream inputStream, RandomAccessFile randomAccessFile, byte[] byArray) {
            this.source = inputStream;
            this.drain = randomAccessFile;
            this.memoryCache = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean bl = false;
                byte[] byArray = new byte[8192];
                while (!bl) {
                    OggPage oggPage = OggPage.create(this.source);
                    Object object = CachedUrlStream.this.drainLock;
                    synchronized (object) {
                        int n = CachedUrlStream.this.pageOffsets.size();
                        long l = n > 0 ? (Long)CachedUrlStream.this.pageOffsets.get(n - 1) + (Long)CachedUrlStream.this.pageLengths.get(n - 1) : 0L;
                        byte[] byArray2 = oggPage.getHeader();
                        byte[] byArray3 = oggPage.getSegmentTable();
                        byte[] byArray4 = oggPage.getData();
                        if (this.drain != null) {
                            this.drain.seek(l);
                            this.drain.write(byArray2);
                            this.drain.write(byArray3);
                            this.drain.write(byArray4);
                        } else {
                            System.arraycopy(byArray2, 0, this.memoryCache, (int)l, byArray2.length);
                            System.arraycopy(byArray3, 0, this.memoryCache, (int)l + byArray2.length, byArray3.length);
                            System.arraycopy(byArray4, 0, this.memoryCache, (int)l + byArray2.length + byArray3.length, byArray4.length);
                        }
                        CachedUrlStream.this.pageOffsets.add(new Long(l));
                        CachedUrlStream.this.pageLengths.add(new Long(byArray2.length + byArray3.length + byArray4.length));
                    }
                    if (!oggPage.isBos()) {
                        this.bosDone = true;
                    }
                    if (oggPage.isEos()) {
                        bl = true;
                    }
                    if ((object = (LogicalOggStreamImpl)CachedUrlStream.this.getLogicalStream(oggPage.getStreamSerialNumber())) == null) {
                        object = new LogicalOggStreamImpl(CachedUrlStream.this, oggPage.getStreamSerialNumber());
                        CachedUrlStream.this.logicalStreams.put(new Integer(oggPage.getStreamSerialNumber()), object);
                        ((LogicalOggStreamImpl)object).checkFormat(oggPage);
                    }
                    ((LogicalOggStreamImpl)object).addPageNumberMapping(this.pageNumber);
                    ((LogicalOggStreamImpl)object).addGranulePosition(oggPage.getAbsoluteGranulePosition());
                    ++this.pageNumber;
                    CachedUrlStream.this.cacheLength = oggPage.getAbsoluteGranulePosition();
                }
            }
            catch (EndOfOggStreamException endOfOggStreamException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public boolean isBosDone() {
            return this.bosDone;
        }
    }
}

