/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.math;

import com.jme.math.Matrix4f;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import com.turborilla.utils.math.Matrix3d;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.io.Serializable;
import java.nio.DoubleBuffer;
import java.util.logging.Logger;

public class Matrix4d
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Matrix4d.class.getName());
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final double ZERO_TOLERANCE = 1.0E-18;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4d() {
        this.loadIdentity();
    }

    public Matrix4d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    public Matrix4d(Matrix4d matrix4d) {
        this.copy(matrix4d);
    }

    public Matrix4d(Matrix4f matrix4f) {
        this.copy(matrix4f);
    }

    public void copy(Matrix4d matrix4d) {
        if (null == matrix4d) {
            this.loadIdentity();
        } else {
            this.m00 = matrix4d.m00;
            this.m01 = matrix4d.m01;
            this.m02 = matrix4d.m02;
            this.m03 = matrix4d.m03;
            this.m10 = matrix4d.m10;
            this.m11 = matrix4d.m11;
            this.m12 = matrix4d.m12;
            this.m13 = matrix4d.m13;
            this.m20 = matrix4d.m20;
            this.m21 = matrix4d.m21;
            this.m22 = matrix4d.m22;
            this.m23 = matrix4d.m23;
            this.m30 = matrix4d.m30;
            this.m31 = matrix4d.m31;
            this.m32 = matrix4d.m32;
            this.m33 = matrix4d.m33;
        }
    }

    public void copy(Matrix4f matrix4f) {
        if (null == matrix4f) {
            this.loadIdentity();
        } else {
            this.m00 = matrix4f.m00;
            this.m01 = matrix4f.m01;
            this.m02 = matrix4f.m02;
            this.m03 = matrix4f.m03;
            this.m10 = matrix4f.m10;
            this.m11 = matrix4f.m11;
            this.m12 = matrix4f.m12;
            this.m13 = matrix4f.m13;
            this.m20 = matrix4f.m20;
            this.m21 = matrix4f.m21;
            this.m22 = matrix4f.m22;
            this.m23 = matrix4f.m23;
            this.m30 = matrix4f.m30;
            this.m31 = matrix4f.m31;
            this.m32 = matrix4f.m32;
            this.m33 = matrix4f.m33;
        }
    }

    public Matrix4f toMatrix4f(Matrix4f matrix4f) {
        if (matrix4f == null) {
            matrix4f = new Matrix4f();
        }
        matrix4f.m00 = (float)this.m00;
        matrix4f.m01 = (float)this.m01;
        matrix4f.m02 = (float)this.m02;
        matrix4f.m03 = (float)this.m03;
        matrix4f.m10 = (float)this.m10;
        matrix4f.m11 = (float)this.m11;
        matrix4f.m12 = (float)this.m12;
        matrix4f.m13 = (float)this.m13;
        matrix4f.m20 = (float)this.m20;
        matrix4f.m21 = (float)this.m21;
        matrix4f.m22 = (float)this.m22;
        matrix4f.m23 = (float)this.m23;
        matrix4f.m30 = (float)this.m30;
        matrix4f.m31 = (float)this.m31;
        matrix4f.m32 = (float)this.m32;
        matrix4f.m33 = (float)this.m33;
        return matrix4f;
    }

    public void get(double[] dArray) {
        this.get(dArray, true);
    }

    public void get(double[] dArray, boolean bl) {
        if (dArray.length != 16) {
            throw new JmeException("Array must be of size 16.");
        }
        if (bl) {
            dArray[0] = this.m00;
            dArray[1] = this.m01;
            dArray[2] = this.m02;
            dArray[3] = this.m03;
            dArray[4] = this.m10;
            dArray[5] = this.m11;
            dArray[6] = this.m12;
            dArray[7] = this.m13;
            dArray[8] = this.m20;
            dArray[9] = this.m21;
            dArray[10] = this.m22;
            dArray[11] = this.m23;
            dArray[12] = this.m30;
            dArray[13] = this.m31;
            dArray[14] = this.m32;
            dArray[15] = this.m33;
        } else {
            dArray[0] = this.m00;
            dArray[4] = this.m01;
            dArray[8] = this.m02;
            dArray[12] = this.m03;
            dArray[1] = this.m10;
            dArray[5] = this.m11;
            dArray[9] = this.m12;
            dArray[13] = this.m13;
            dArray[2] = this.m20;
            dArray[6] = this.m21;
            dArray[10] = this.m22;
            dArray[14] = this.m23;
            dArray[3] = this.m30;
            dArray[7] = this.m31;
            dArray[11] = this.m32;
            dArray[15] = this.m33;
        }
    }

    public double get(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                }
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new JmeException("Invalid indices into matrix.");
    }

    public double[] getColumn(int n) {
        return this.getColumn(n, null);
    }

    public double[] getColumn(int n, double[] dArray) {
        if (dArray == null) {
            dArray = new double[4];
        }
        switch (n) {
            case 0: {
                dArray[0] = this.m00;
                dArray[1] = this.m10;
                dArray[2] = this.m20;
                dArray[3] = this.m30;
                break;
            }
            case 1: {
                dArray[0] = this.m01;
                dArray[1] = this.m11;
                dArray[2] = this.m21;
                dArray[3] = this.m31;
                break;
            }
            case 2: {
                dArray[0] = this.m02;
                dArray[1] = this.m12;
                dArray[2] = this.m22;
                dArray[3] = this.m32;
                break;
            }
            case 3: {
                dArray[0] = this.m03;
                dArray[1] = this.m13;
                dArray[2] = this.m23;
                dArray[3] = this.m33;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new JmeException("Invalid column index. " + n);
            }
        }
        return dArray;
    }

    public void setColumn(int n, double[] dArray) {
        if (dArray == null) {
            logger.warning("Column is null. Ignoring.");
            return;
        }
        switch (n) {
            case 0: {
                this.m00 = dArray[0];
                this.m10 = dArray[1];
                this.m20 = dArray[2];
                this.m30 = dArray[3];
                break;
            }
            case 1: {
                this.m01 = dArray[0];
                this.m11 = dArray[1];
                this.m21 = dArray[2];
                this.m31 = dArray[3];
                break;
            }
            case 2: {
                this.m02 = dArray[0];
                this.m12 = dArray[1];
                this.m22 = dArray[2];
                this.m32 = dArray[3];
                break;
            }
            case 3: {
                this.m03 = dArray[0];
                this.m13 = dArray[1];
                this.m23 = dArray[2];
                this.m33 = dArray[3];
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new JmeException("Invalid column index. " + n);
            }
        }
    }

    public void set(int n, int n2, double d) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = d;
                        return;
                    }
                    case 1: {
                        this.m01 = d;
                        return;
                    }
                    case 2: {
                        this.m02 = d;
                        return;
                    }
                    case 3: {
                        this.m03 = d;
                        return;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = d;
                        return;
                    }
                    case 1: {
                        this.m11 = d;
                        return;
                    }
                    case 2: {
                        this.m12 = d;
                        return;
                    }
                    case 3: {
                        this.m13 = d;
                        return;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = d;
                        return;
                    }
                    case 1: {
                        this.m21 = d;
                        return;
                    }
                    case 2: {
                        this.m22 = d;
                        return;
                    }
                    case 3: {
                        this.m23 = d;
                        return;
                    }
                }
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        this.m30 = d;
                        return;
                    }
                    case 1: {
                        this.m31 = d;
                        return;
                    }
                    case 2: {
                        this.m32 = d;
                        return;
                    }
                    case 3: {
                        this.m33 = d;
                        return;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new JmeException("Invalid indices into matrix.");
    }

    public void set(double[][] dArray) {
        if (dArray.length != 4 || dArray[0].length != 4) {
            throw new JmeException("Array must be of size 16.");
        }
        this.m00 = dArray[0][0];
        this.m01 = dArray[0][1];
        this.m02 = dArray[0][2];
        this.m03 = dArray[0][3];
        this.m10 = dArray[1][0];
        this.m11 = dArray[1][1];
        this.m12 = dArray[1][2];
        this.m13 = dArray[1][3];
        this.m20 = dArray[2][0];
        this.m21 = dArray[2][1];
        this.m22 = dArray[2][2];
        this.m23 = dArray[2][3];
        this.m30 = dArray[3][0];
        this.m31 = dArray[3][1];
        this.m32 = dArray[3][2];
        this.m33 = dArray[3][3];
    }

    public Matrix4d set(Matrix4d matrix4d) {
        this.m00 = matrix4d.m00;
        this.m01 = matrix4d.m01;
        this.m02 = matrix4d.m02;
        this.m03 = matrix4d.m03;
        this.m10 = matrix4d.m10;
        this.m11 = matrix4d.m11;
        this.m12 = matrix4d.m12;
        this.m13 = matrix4d.m13;
        this.m20 = matrix4d.m20;
        this.m21 = matrix4d.m21;
        this.m22 = matrix4d.m22;
        this.m23 = matrix4d.m23;
        this.m30 = matrix4d.m30;
        this.m31 = matrix4d.m31;
        this.m32 = matrix4d.m32;
        this.m33 = matrix4d.m33;
        return this;
    }

    public void set(double[] dArray) {
        this.set(dArray, true);
    }

    public void set(double[] dArray, boolean bl) {
        if (dArray.length != 16) {
            throw new JmeException("Array must be of size 16.");
        }
        if (bl) {
            this.m00 = dArray[0];
            this.m01 = dArray[1];
            this.m02 = dArray[2];
            this.m03 = dArray[3];
            this.m10 = dArray[4];
            this.m11 = dArray[5];
            this.m12 = dArray[6];
            this.m13 = dArray[7];
            this.m20 = dArray[8];
            this.m21 = dArray[9];
            this.m22 = dArray[10];
            this.m23 = dArray[11];
            this.m30 = dArray[12];
            this.m31 = dArray[13];
            this.m32 = dArray[14];
            this.m33 = dArray[15];
        } else {
            this.m00 = dArray[0];
            this.m01 = dArray[4];
            this.m02 = dArray[8];
            this.m03 = dArray[12];
            this.m10 = dArray[1];
            this.m11 = dArray[5];
            this.m12 = dArray[9];
            this.m13 = dArray[13];
            this.m20 = dArray[2];
            this.m21 = dArray[6];
            this.m22 = dArray[10];
            this.m23 = dArray[14];
            this.m30 = dArray[3];
            this.m31 = dArray[7];
            this.m32 = dArray[11];
            this.m33 = dArray[15];
        }
    }

    public void set(Quaternion quaternion) {
        this.setRotationQuaternion(quaternion);
    }

    public Matrix4d transpose() {
        double d = 0.0;
        d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m03;
        this.m03 = this.m30;
        this.m30 = d;
        d = this.m12;
        this.m12 = this.m21;
        this.m21 = d;
        d = this.m13;
        this.m13 = this.m31;
        this.m31 = d;
        d = this.m23;
        this.m23 = this.m32;
        this.m32 = d;
        return this;
    }

    public DoubleBuffer toDoubleBuffer() {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(16);
        doubleBuffer.put(this.m00).put(this.m01).put(this.m02).put(this.m03);
        doubleBuffer.put(this.m10).put(this.m11).put(this.m12).put(this.m13);
        doubleBuffer.put(this.m20).put(this.m21).put(this.m22).put(this.m23);
        doubleBuffer.put(this.m30).put(this.m31).put(this.m32).put(this.m33);
        doubleBuffer.rewind();
        return doubleBuffer;
    }

    public DoubleBuffer fillDoubleBuffer(DoubleBuffer doubleBuffer) {
        doubleBuffer.clear();
        doubleBuffer.put(this.m00).put(this.m01).put(this.m02).put(this.m03);
        doubleBuffer.put(this.m10).put(this.m11).put(this.m12).put(this.m13);
        doubleBuffer.put(this.m20).put(this.m21).put(this.m22).put(this.m23);
        doubleBuffer.put(this.m30).put(this.m31).put(this.m32).put(this.m33);
        doubleBuffer.rewind();
        return doubleBuffer;
    }

    public Matrix4d readDoubleBuffer(DoubleBuffer doubleBuffer) {
        this.m00 = doubleBuffer.get();
        this.m01 = doubleBuffer.get();
        this.m02 = doubleBuffer.get();
        this.m03 = doubleBuffer.get();
        this.m10 = doubleBuffer.get();
        this.m11 = doubleBuffer.get();
        this.m12 = doubleBuffer.get();
        this.m13 = doubleBuffer.get();
        this.m20 = doubleBuffer.get();
        this.m21 = doubleBuffer.get();
        this.m22 = doubleBuffer.get();
        this.m23 = doubleBuffer.get();
        this.m30 = doubleBuffer.get();
        this.m31 = doubleBuffer.get();
        this.m32 = doubleBuffer.get();
        this.m33 = doubleBuffer.get();
        return this;
    }

    public void loadIdentity() {
        this.zero();
        this.m33 = 1.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public void fromAngleAxis(double d, Vector3d vector3d) {
        Vector3d vector3d2 = vector3d.normalize();
        this.fromAngleNormalAxis(d, vector3d2);
    }

    public void fromAngleNormalAxis(double d, Vector3d vector3d) {
        this.zero();
        this.m33 = 1.0;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        double d5 = vector3d.x * vector3d.x;
        double d6 = vector3d.y * vector3d.y;
        double d7 = vector3d.z * vector3d.z;
        double d8 = vector3d.x * vector3d.y * d4;
        double d9 = vector3d.x * vector3d.z * d4;
        double d10 = vector3d.y * vector3d.z * d4;
        double d11 = vector3d.x * d3;
        double d12 = vector3d.y * d3;
        double d13 = vector3d.z * d3;
        this.m00 = d5 * d4 + d2;
        this.m01 = d8 - d13;
        this.m02 = d9 + d12;
        this.m10 = d8 + d13;
        this.m11 = d6 * d4 + d2;
        this.m12 = d10 - d11;
        this.m20 = d9 - d12;
        this.m21 = d10 + d11;
        this.m22 = d7 * d4 + d2;
    }

    public void multLocal(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m03 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m13 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
        this.m23 *= d;
        this.m30 *= d;
        this.m31 *= d;
        this.m32 *= d;
        this.m33 *= d;
    }

    public Matrix4d mult(double d) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(this);
        matrix4d.multLocal(d);
        return matrix4d;
    }

    public Matrix4d mult(Matrix4d matrix4d) {
        return this.mult(matrix4d, null);
    }

    public Matrix4d mult(Matrix4d matrix4d, Matrix4d matrix4d2) {
        if (matrix4d2 == null) {
            matrix4d2 = new Matrix4d();
        }
        double d = this.m00 * matrix4d.m00 + this.m01 * matrix4d.m10 + this.m02 * matrix4d.m20 + this.m03 * matrix4d.m30;
        double d2 = this.m00 * matrix4d.m01 + this.m01 * matrix4d.m11 + this.m02 * matrix4d.m21 + this.m03 * matrix4d.m31;
        double d3 = this.m00 * matrix4d.m02 + this.m01 * matrix4d.m12 + this.m02 * matrix4d.m22 + this.m03 * matrix4d.m32;
        double d4 = this.m00 * matrix4d.m03 + this.m01 * matrix4d.m13 + this.m02 * matrix4d.m23 + this.m03 * matrix4d.m33;
        double d5 = this.m10 * matrix4d.m00 + this.m11 * matrix4d.m10 + this.m12 * matrix4d.m20 + this.m13 * matrix4d.m30;
        double d6 = this.m10 * matrix4d.m01 + this.m11 * matrix4d.m11 + this.m12 * matrix4d.m21 + this.m13 * matrix4d.m31;
        double d7 = this.m10 * matrix4d.m02 + this.m11 * matrix4d.m12 + this.m12 * matrix4d.m22 + this.m13 * matrix4d.m32;
        double d8 = this.m10 * matrix4d.m03 + this.m11 * matrix4d.m13 + this.m12 * matrix4d.m23 + this.m13 * matrix4d.m33;
        double d9 = this.m20 * matrix4d.m00 + this.m21 * matrix4d.m10 + this.m22 * matrix4d.m20 + this.m23 * matrix4d.m30;
        double d10 = this.m20 * matrix4d.m01 + this.m21 * matrix4d.m11 + this.m22 * matrix4d.m21 + this.m23 * matrix4d.m31;
        double d11 = this.m20 * matrix4d.m02 + this.m21 * matrix4d.m12 + this.m22 * matrix4d.m22 + this.m23 * matrix4d.m32;
        double d12 = this.m20 * matrix4d.m03 + this.m21 * matrix4d.m13 + this.m22 * matrix4d.m23 + this.m23 * matrix4d.m33;
        double d13 = this.m30 * matrix4d.m00 + this.m31 * matrix4d.m10 + this.m32 * matrix4d.m20 + this.m33 * matrix4d.m30;
        double d14 = this.m30 * matrix4d.m01 + this.m31 * matrix4d.m11 + this.m32 * matrix4d.m21 + this.m33 * matrix4d.m31;
        double d15 = this.m30 * matrix4d.m02 + this.m31 * matrix4d.m12 + this.m32 * matrix4d.m22 + this.m33 * matrix4d.m32;
        double d16 = this.m30 * matrix4d.m03 + this.m31 * matrix4d.m13 + this.m32 * matrix4d.m23 + this.m33 * matrix4d.m33;
        matrix4d2.m00 = d;
        matrix4d2.m01 = d2;
        matrix4d2.m02 = d3;
        matrix4d2.m03 = d4;
        matrix4d2.m10 = d5;
        matrix4d2.m11 = d6;
        matrix4d2.m12 = d7;
        matrix4d2.m13 = d8;
        matrix4d2.m20 = d9;
        matrix4d2.m21 = d10;
        matrix4d2.m22 = d11;
        matrix4d2.m23 = d12;
        matrix4d2.m30 = d13;
        matrix4d2.m31 = d14;
        matrix4d2.m32 = d15;
        matrix4d2.m33 = d16;
        return matrix4d2;
    }

    public Matrix4d multLocal(Matrix4d matrix4d) {
        return this.mult(matrix4d, this);
    }

    public Vector3d mult(Vector3d vector3d) {
        return this.mult(vector3d, null);
    }

    public Vector3d mult(Vector3d vector3d, Vector3d vector3d2) {
        if (vector3d2 == null) {
            vector3d2 = new Vector3d();
        }
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        vector3d2.x = this.m00 * d + this.m01 * d2 + this.m02 * d3 + this.m03;
        vector3d2.y = this.m10 * d + this.m11 * d2 + this.m12 * d3 + this.m13;
        vector3d2.z = this.m20 * d + this.m21 * d2 + this.m22 * d3 + this.m23;
        return vector3d2;
    }

    public Vector3d multAcross(Vector3d vector3d, Vector3d vector3d2) {
        if (null == vector3d) {
            System.err.println("Source vector is null, null result returned.");
            return null;
        }
        if (vector3d2 == null) {
            vector3d2 = new Vector3d();
        }
        vector3d2.x = this.m00 * vector3d.x + this.m10 * vector3d.y + this.m20 * vector3d.z + this.m30 * 1.0;
        vector3d2.y = this.m01 * vector3d.x + this.m11 * vector3d.y + this.m21 * vector3d.z + this.m31 * 1.0;
        vector3d2.z = this.m02 * vector3d.x + this.m12 * vector3d.y + this.m22 * vector3d.z + this.m32 * 1.0;
        return vector3d2;
    }

    public Quaternion mult(Quaternion quaternion, Quaternion quaternion2) {
        if (null == quaternion) {
            logger.warning("Source vector is null, null result returned.");
            return null;
        }
        if (quaternion2 == null) {
            quaternion2 = new Quaternion();
        }
        double d = this.m00 * quaternion.x + this.m10 * quaternion.y + this.m20 * quaternion.z + this.m30 * quaternion.w;
        double d2 = this.m01 * quaternion.x + this.m11 * quaternion.y + this.m21 * quaternion.z + this.m31 * quaternion.w;
        double d3 = this.m02 * quaternion.x + this.m12 * quaternion.y + this.m22 * quaternion.z + this.m32 * quaternion.w;
        double d4 = this.m03 * quaternion.x + this.m13 * quaternion.y + this.m23 * quaternion.z + this.m33 * quaternion.w;
        quaternion2.x = d;
        quaternion2.y = d2;
        quaternion2.z = d3;
        quaternion2.w = d4;
        return quaternion2;
    }

    public double[] mult(double[] dArray) {
        if (null == dArray || dArray.length != 4) {
            System.err.println("invalid array given, must be nonnull and length 4");
            return null;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        dArray[0] = this.m00 * d + this.m01 * d2 + this.m02 * d3 + this.m03 * d4;
        dArray[1] = this.m10 * d + this.m11 * d2 + this.m12 * d3 + this.m13 * d4;
        dArray[2] = this.m20 * d + this.m21 * d2 + this.m22 * d3 + this.m23 * d4;
        dArray[3] = this.m30 * d + this.m31 * d2 + this.m32 * d3 + this.m33 * d4;
        return dArray;
    }

    public double[] multAcross(double[] dArray) {
        if (null == dArray || dArray.length != 4) {
            System.err.println("invalid array given, must be nonnull and length 4");
            return null;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        dArray[0] = this.m00 * d + this.m10 * d2 + this.m20 * d3 + this.m30 * d4;
        dArray[1] = this.m01 * d + this.m11 * d2 + this.m21 * d3 + this.m31 * d4;
        dArray[2] = this.m02 * d + this.m12 * d2 + this.m22 * d3 + this.m32 * d4;
        dArray[3] = this.m03 * d + this.m13 * d2 + this.m23 * d3 + this.m33 * d4;
        return dArray;
    }

    public Matrix4d invert() {
        return this.invert(null);
    }

    public Matrix4d invert(Matrix4d matrix4d) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        if (matrix4d == null) {
            matrix4d = new Matrix4d();
        }
        if (Math.abs(d13 = (d12 = this.m00 * this.m11 - this.m01 * this.m10) * (d11 = this.m22 * this.m33 - this.m23 * this.m32) - (d10 = this.m00 * this.m12 - this.m02 * this.m10) * (d9 = this.m21 * this.m33 - this.m23 * this.m31) + (d8 = this.m00 * this.m13 - this.m03 * this.m10) * (d7 = this.m21 * this.m32 - this.m22 * this.m31) + (d6 = this.m01 * this.m12 - this.m02 * this.m11) * (d5 = this.m20 * this.m33 - this.m23 * this.m30) - (d4 = this.m01 * this.m13 - this.m03 * this.m11) * (d3 = this.m20 * this.m32 - this.m22 * this.m30) + (d2 = this.m02 * this.m13 - this.m03 * this.m12) * (d = this.m20 * this.m31 - this.m21 * this.m30)) <= 2.220446049250313E-16) {
            throw new ArithmeticException("This matrix cannot be inverted");
        }
        matrix4d.m00 = this.m11 * d11 - this.m12 * d9 + this.m13 * d7;
        matrix4d.m10 = -this.m10 * d11 + this.m12 * d5 - this.m13 * d3;
        matrix4d.m20 = this.m10 * d9 - this.m11 * d5 + this.m13 * d;
        matrix4d.m30 = -this.m10 * d7 + this.m11 * d3 - this.m12 * d;
        matrix4d.m01 = -this.m01 * d11 + this.m02 * d9 - this.m03 * d7;
        matrix4d.m11 = this.m00 * d11 - this.m02 * d5 + this.m03 * d3;
        matrix4d.m21 = -this.m00 * d9 + this.m01 * d5 - this.m03 * d;
        matrix4d.m31 = this.m00 * d7 - this.m01 * d3 + this.m02 * d;
        matrix4d.m02 = this.m31 * d2 - this.m32 * d4 + this.m33 * d6;
        matrix4d.m12 = -this.m30 * d2 + this.m32 * d8 - this.m33 * d10;
        matrix4d.m22 = this.m30 * d4 - this.m31 * d8 + this.m33 * d12;
        matrix4d.m32 = -this.m30 * d6 + this.m31 * d10 - this.m32 * d12;
        matrix4d.m03 = -this.m21 * d2 + this.m22 * d4 - this.m23 * d6;
        matrix4d.m13 = this.m20 * d2 - this.m22 * d8 + this.m23 * d10;
        matrix4d.m23 = -this.m20 * d4 + this.m21 * d8 - this.m23 * d12;
        matrix4d.m33 = this.m20 * d6 - this.m21 * d10 + this.m22 * d12;
        double d14 = 1.0 / d13;
        matrix4d.multLocal(d14);
        return matrix4d;
    }

    public Matrix4d invertLocal() {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        double d2 = this.m22 * this.m33 - this.m23 * this.m32;
        double d3 = this.m00 * this.m12 - this.m02 * this.m10;
        double d4 = this.m21 * this.m33 - this.m23 * this.m31;
        double d5 = this.m00 * this.m13 - this.m03 * this.m10;
        double d6 = this.m21 * this.m32 - this.m22 * this.m31;
        double d7 = this.m01 * this.m12 - this.m02 * this.m11;
        double d8 = this.m20 * this.m33 - this.m23 * this.m30;
        double d9 = this.m01 * this.m13 - this.m03 * this.m11;
        double d10 = this.m20 * this.m32 - this.m22 * this.m30;
        double d11 = this.m02 * this.m13 - this.m03 * this.m12;
        double d12 = this.m20 * this.m31 - this.m21 * this.m30;
        double d13 = d * d2 - d3 * d4 + d5 * d6 + d7 * d8 - d9 * d10 + d11 * d12;
        if (Math.abs(d13) <= 2.220446049250313E-16) {
            return this.zero();
        }
        double d14 = this.m11 * d2 - this.m12 * d4 + this.m13 * d6;
        double d15 = -this.m10 * d2 + this.m12 * d8 - this.m13 * d10;
        double d16 = this.m10 * d4 - this.m11 * d8 + this.m13 * d12;
        double d17 = -this.m10 * d6 + this.m11 * d10 - this.m12 * d12;
        double d18 = -this.m01 * d2 + this.m02 * d4 - this.m03 * d6;
        double d19 = this.m00 * d2 - this.m02 * d8 + this.m03 * d10;
        double d20 = -this.m00 * d4 + this.m01 * d8 - this.m03 * d12;
        double d21 = this.m00 * d6 - this.m01 * d10 + this.m02 * d12;
        double d22 = this.m31 * d11 - this.m32 * d9 + this.m33 * d7;
        double d23 = -this.m30 * d11 + this.m32 * d5 - this.m33 * d3;
        double d24 = this.m30 * d9 - this.m31 * d5 + this.m33 * d;
        double d25 = -this.m30 * d7 + this.m31 * d3 - this.m32 * d;
        double d26 = -this.m21 * d11 + this.m22 * d9 - this.m23 * d7;
        double d27 = this.m20 * d11 - this.m22 * d5 + this.m23 * d3;
        double d28 = -this.m20 * d9 + this.m21 * d5 - this.m23 * d;
        double d29 = this.m20 * d7 - this.m21 * d3 + this.m22 * d;
        this.m00 = d14;
        this.m01 = d18;
        this.m02 = d22;
        this.m03 = d26;
        this.m10 = d15;
        this.m11 = d19;
        this.m12 = d23;
        this.m13 = d27;
        this.m20 = d16;
        this.m21 = d20;
        this.m22 = d24;
        this.m23 = d28;
        this.m30 = d17;
        this.m31 = d21;
        this.m32 = d25;
        this.m33 = d29;
        double d30 = 1.0 / d13;
        this.multLocal(d30);
        return this;
    }

    public Matrix4d adjoint() {
        return this.adjoint(null);
    }

    public Matrix4d adjoint(Matrix4d matrix4d) {
        if (matrix4d == null) {
            matrix4d = new Matrix4d();
        }
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        double d2 = this.m00 * this.m12 - this.m02 * this.m10;
        double d3 = this.m00 * this.m13 - this.m03 * this.m10;
        double d4 = this.m01 * this.m12 - this.m02 * this.m11;
        double d5 = this.m01 * this.m13 - this.m03 * this.m11;
        double d6 = this.m02 * this.m13 - this.m03 * this.m12;
        double d7 = this.m20 * this.m31 - this.m21 * this.m30;
        double d8 = this.m20 * this.m32 - this.m22 * this.m30;
        double d9 = this.m20 * this.m33 - this.m23 * this.m30;
        double d10 = this.m21 * this.m32 - this.m22 * this.m31;
        double d11 = this.m21 * this.m33 - this.m23 * this.m31;
        double d12 = this.m22 * this.m33 - this.m23 * this.m32;
        matrix4d.m00 = this.m11 * d12 - this.m12 * d11 + this.m13 * d10;
        matrix4d.m10 = -this.m10 * d12 + this.m12 * d9 - this.m13 * d8;
        matrix4d.m20 = this.m10 * d11 - this.m11 * d9 + this.m13 * d7;
        matrix4d.m30 = -this.m10 * d10 + this.m11 * d8 - this.m12 * d7;
        matrix4d.m01 = -this.m01 * d12 + this.m02 * d11 - this.m03 * d10;
        matrix4d.m11 = this.m00 * d12 - this.m02 * d9 + this.m03 * d8;
        matrix4d.m21 = -this.m00 * d11 + this.m01 * d9 - this.m03 * d7;
        matrix4d.m31 = this.m00 * d10 - this.m01 * d8 + this.m02 * d7;
        matrix4d.m02 = this.m31 * d6 - this.m32 * d5 + this.m33 * d4;
        matrix4d.m12 = -this.m30 * d6 + this.m32 * d3 - this.m33 * d2;
        matrix4d.m22 = this.m30 * d5 - this.m31 * d3 + this.m33 * d;
        matrix4d.m32 = -this.m30 * d4 + this.m31 * d2 - this.m32 * d;
        matrix4d.m03 = -this.m21 * d6 + this.m22 * d5 - this.m23 * d4;
        matrix4d.m13 = this.m20 * d6 - this.m22 * d3 + this.m23 * d2;
        matrix4d.m23 = -this.m20 * d5 + this.m21 * d3 - this.m23 * d;
        matrix4d.m33 = this.m20 * d4 - this.m21 * d2 + this.m22 * d;
        return matrix4d;
    }

    public double determinant() {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        double d2 = this.m00 * this.m12 - this.m02 * this.m10;
        double d3 = this.m00 * this.m13 - this.m03 * this.m10;
        double d4 = this.m01 * this.m12 - this.m02 * this.m11;
        double d5 = this.m01 * this.m13 - this.m03 * this.m11;
        double d6 = this.m02 * this.m13 - this.m03 * this.m12;
        double d7 = this.m20 * this.m31 - this.m21 * this.m30;
        double d8 = this.m20 * this.m32 - this.m22 * this.m30;
        double d9 = this.m20 * this.m33 - this.m23 * this.m30;
        double d10 = this.m21 * this.m32 - this.m22 * this.m31;
        double d11 = this.m21 * this.m33 - this.m23 * this.m31;
        double d12 = this.m22 * this.m33 - this.m23 * this.m32;
        double d13 = d * d12 - d2 * d11 + d3 * d10 + d4 * d9 - d5 * d8 + d6 * d7;
        return d13;
    }

    public Matrix4d zero() {
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m00 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m11 = 0.0;
        this.m10 = 0.0;
        this.m23 = 0.0;
        this.m22 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m33 = 0.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        return this;
    }

    public void add(Matrix4d matrix4d) {
        this.m00 += matrix4d.m00;
        this.m01 += matrix4d.m01;
        this.m02 += matrix4d.m02;
        this.m03 += matrix4d.m03;
        this.m10 += matrix4d.m10;
        this.m11 += matrix4d.m11;
        this.m12 += matrix4d.m12;
        this.m13 += matrix4d.m13;
        this.m20 += matrix4d.m20;
        this.m21 += matrix4d.m21;
        this.m22 += matrix4d.m22;
        this.m23 += matrix4d.m23;
        this.m30 += matrix4d.m30;
        this.m31 += matrix4d.m31;
        this.m32 += matrix4d.m32;
        this.m33 += matrix4d.m33;
    }

    public Vector3d toTranslationVector() {
        return new Vector3d(this.m03, this.m13, this.m23);
    }

    public void toTranslationVector(Vector3d vector3d) {
        vector3d.set(this.m03, this.m13, this.m23);
    }

    public Quaternion toRotationQuat() {
        Quaternion quaternion = new Quaternion();
        quaternion.fromRotationMatrix(this.toRotationMatrix());
        return quaternion;
    }

    public void toRotationQuat(Quaternion quaternion) {
        quaternion.fromRotationMatrix(this.toRotationMatrix());
    }

    public Matrix3d toRotationMatrix() {
        return new Matrix3d(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public void toRotationMatrix(Matrix3d matrix3d) {
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = this.m22;
    }

    public void setTranslation(double[] dArray) {
        if (dArray.length != 3) {
            throw new JmeException("Translation size must be 3.");
        }
        this.m03 = dArray[0];
        this.m13 = dArray[1];
        this.m23 = dArray[2];
    }

    public void setTranslation(double d, double d2, double d3) {
        this.m03 = d;
        this.m13 = d2;
        this.m23 = d3;
    }

    public void setTranslation(Vector3d vector3d) {
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
    }

    public void setInverseTranslation(double[] dArray) {
        if (dArray.length != 3) {
            throw new JmeException("Translation size must be 3.");
        }
        this.m03 = -dArray[0];
        this.m13 = -dArray[1];
        this.m23 = -dArray[2];
    }

    public void angleRotation(Vector3d vector3d) {
        double d = vector3d.z * (Math.PI / 180);
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        d = vector3d.y * (Math.PI / 180);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        d = vector3d.x * (Math.PI / 180);
        double d6 = Math.sin(d);
        double d7 = Math.cos(d);
        this.m00 = d5 * d3;
        this.m10 = d5 * d2;
        this.m20 = -d4;
        this.m01 = d6 * d4 * d3 + d7 * -d2;
        this.m11 = d6 * d4 * d2 + d7 * d3;
        this.m21 = d6 * d5;
        this.m02 = d7 * d4 * d3 + -d6 * -d2;
        this.m12 = d7 * d4 * d2 + -d6 * d3;
        this.m22 = d7 * d5;
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
    }

    public void setRotationQuaternion(Quaternion quaternion) {
        quaternion.toRotationMatrix(this);
    }

    public void setInverseRotationRadians(double[] dArray) {
        if (dArray.length != 3) {
            throw new JmeException("Angles must be of size 3.");
        }
        double d = Math.cos(dArray[0]);
        double d2 = Math.sin(dArray[0]);
        double d3 = Math.cos(dArray[1]);
        double d4 = Math.sin(dArray[1]);
        double d5 = Math.cos(dArray[2]);
        double d6 = Math.sin(dArray[2]);
        this.m00 = d3 * d5;
        this.m10 = d3 * d6;
        this.m20 = -d4;
        double d7 = d2 * d4;
        double d8 = d * d4;
        this.m01 = d7 * d5 - d * d6;
        this.m11 = d7 * d6 + d * d5;
        this.m21 = d2 * d3;
        this.m02 = d8 * d5 + d2 * d6;
        this.m12 = d8 * d6 - d2 * d5;
        this.m22 = d * d3;
    }

    public void setInverseRotationDegrees(double[] dArray) {
        if (dArray.length != 3) {
            throw new JmeException("Angles must be of size 3.");
        }
        double[] dArray2 = new double[]{dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, dArray[2] * 57.29577951308232};
        this.setInverseRotationRadians(dArray2);
    }

    public void inverseTranslateVect(double[] dArray) {
        if (dArray.length != 3) {
            throw new JmeException("vec must be of size 3.");
        }
        dArray[0] = dArray[0] - this.m03;
        dArray[1] = dArray[1] - this.m13;
        dArray[2] = dArray[2] - this.m23;
    }

    public void inverseTranslateVect(Vector3d vector3d) {
        vector3d.x -= this.m03;
        vector3d.y -= this.m13;
        vector3d.z -= this.m23;
    }

    public void translateVect(Vector3d vector3d) {
        vector3d.x += this.m03;
        vector3d.y += this.m13;
        vector3d.z += this.m23;
    }

    public void inverseRotateVect(Vector3d vector3d) {
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        vector3d.x = d * this.m00 + d2 * this.m10 + d3 * this.m20;
        vector3d.y = d * this.m01 + d2 * this.m11 + d3 * this.m21;
        vector3d.z = d * this.m02 + d2 * this.m12 + d3 * this.m22;
    }

    public void rotateVect(Vector3d vector3d) {
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        vector3d.x = d * this.m00 + d2 * this.m01 + d3 * this.m02;
        vector3d.y = d * this.m10 + d2 * this.m11 + d3 * this.m12;
        vector3d.z = d * this.m20 + d2 * this.m21 + d3 * this.m22;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("com.jme.math.Matrix4f\n[\n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m00);
        stringBuffer.append("  ");
        stringBuffer.append(this.m01);
        stringBuffer.append("  ");
        stringBuffer.append(this.m02);
        stringBuffer.append("  ");
        stringBuffer.append(this.m03);
        stringBuffer.append(" \n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m10);
        stringBuffer.append("  ");
        stringBuffer.append(this.m11);
        stringBuffer.append("  ");
        stringBuffer.append(this.m12);
        stringBuffer.append("  ");
        stringBuffer.append(this.m13);
        stringBuffer.append(" \n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m20);
        stringBuffer.append("  ");
        stringBuffer.append(this.m21);
        stringBuffer.append("  ");
        stringBuffer.append(this.m22);
        stringBuffer.append("  ");
        stringBuffer.append(this.m23);
        stringBuffer.append(" \n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m30);
        stringBuffer.append("  ");
        stringBuffer.append(this.m31);
        stringBuffer.append("  ");
        stringBuffer.append(this.m32);
        stringBuffer.append("  ");
        stringBuffer.append(this.m33);
        stringBuffer.append(" \n]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        long l = 37L;
        l = 37L * l + Double.doubleToLongBits(this.m00);
        l = 37L * l + Double.doubleToLongBits(this.m01);
        l = 37L * l + Double.doubleToLongBits(this.m02);
        l = 37L * l + Double.doubleToLongBits(this.m03);
        l = 37L * l + Double.doubleToLongBits(this.m10);
        l = 37L * l + Double.doubleToLongBits(this.m11);
        l = 37L * l + Double.doubleToLongBits(this.m12);
        l = 37L * l + Double.doubleToLongBits(this.m13);
        l = 37L * l + Double.doubleToLongBits(this.m20);
        l = 37L * l + Double.doubleToLongBits(this.m21);
        l = 37L * l + Double.doubleToLongBits(this.m22);
        l = 37L * l + Double.doubleToLongBits(this.m23);
        l = 37L * l + Double.doubleToLongBits(this.m30);
        l = 37L * l + Double.doubleToLongBits(this.m31);
        l = 37L * l + Double.doubleToLongBits(this.m32);
        l = 37L * l + Double.doubleToLongBits(this.m33);
        return (int)l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix4d) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Matrix4d matrix4d = (Matrix4d)object;
        if (Double.compare(this.m00, matrix4d.m00) != 0) {
            return false;
        }
        if (Double.compare(this.m01, matrix4d.m01) != 0) {
            return false;
        }
        if (Double.compare(this.m02, matrix4d.m02) != 0) {
            return false;
        }
        if (Double.compare(this.m03, matrix4d.m03) != 0) {
            return false;
        }
        if (Double.compare(this.m10, matrix4d.m10) != 0) {
            return false;
        }
        if (Double.compare(this.m11, matrix4d.m11) != 0) {
            return false;
        }
        if (Double.compare(this.m12, matrix4d.m12) != 0) {
            return false;
        }
        if (Double.compare(this.m13, matrix4d.m13) != 0) {
            return false;
        }
        if (Double.compare(this.m20, matrix4d.m20) != 0) {
            return false;
        }
        if (Double.compare(this.m21, matrix4d.m21) != 0) {
            return false;
        }
        if (Double.compare(this.m22, matrix4d.m22) != 0) {
            return false;
        }
        if (Double.compare(this.m23, matrix4d.m23) != 0) {
            return false;
        }
        if (Double.compare(this.m30, matrix4d.m30) != 0) {
            return false;
        }
        if (Double.compare(this.m31, matrix4d.m31) != 0) {
            return false;
        }
        if (Double.compare(this.m32, matrix4d.m32) != 0) {
            return false;
        }
        return Double.compare(this.m33, matrix4d.m33) == 0;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.m00, "m00", 1.0);
        outputCapsule.write(this.m01, "m01", 0.0);
        outputCapsule.write(this.m02, "m02", 0.0);
        outputCapsule.write(this.m03, "m03", 0.0);
        outputCapsule.write(this.m10, "m10", 0.0);
        outputCapsule.write(this.m11, "m11", 1.0);
        outputCapsule.write(this.m12, "m12", 0.0);
        outputCapsule.write(this.m13, "m13", 0.0);
        outputCapsule.write(this.m20, "m20", 0.0);
        outputCapsule.write(this.m21, "m21", 0.0);
        outputCapsule.write(this.m22, "m22", 1.0);
        outputCapsule.write(this.m23, "m23", 0.0);
        outputCapsule.write(this.m30, "m30", 0.0);
        outputCapsule.write(this.m31, "m31", 0.0);
        outputCapsule.write(this.m32, "m32", 0.0);
        outputCapsule.write(this.m33, "m33", 1.0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.m00 = inputCapsule.readDouble("m00", 1.0);
        this.m01 = inputCapsule.readDouble("m01", 0.0);
        this.m02 = inputCapsule.readDouble("m02", 0.0);
        this.m03 = inputCapsule.readDouble("m03", 0.0);
        this.m10 = inputCapsule.readDouble("m10", 0.0);
        this.m11 = inputCapsule.readDouble("m11", 1.0);
        this.m12 = inputCapsule.readDouble("m12", 0.0);
        this.m13 = inputCapsule.readDouble("m13", 0.0);
        this.m20 = inputCapsule.readDouble("m20", 0.0);
        this.m21 = inputCapsule.readDouble("m21", 0.0);
        this.m22 = inputCapsule.readDouble("m22", 1.0);
        this.m23 = inputCapsule.readDouble("m23", 0.0);
        this.m30 = inputCapsule.readDouble("m30", 0.0);
        this.m31 = inputCapsule.readDouble("m31", 0.0);
        this.m32 = inputCapsule.readDouble("m32", 0.0);
        this.m33 = inputCapsule.readDouble("m33", 1.0);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m03 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m13 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0 && this.m23 == 0.0 && this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0 && this.m33 == 1.0;
    }
}

