/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils.controllers;

import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.turborilla.utils.controllers.AbstractSpatialController;
import java.util.ArrayList;

public class SpatialScaleController
extends AbstractSpatialController {
    private ArrayList<ScalingInfo> scalingQueue;
    private ScalingInfo currentScaling = null;
    private ScalingInfo remainingScaling = null;
    private int currentScalingIndex = -1;
    private float curTime = 0.0f;
    private boolean inReverse = false;
    private Vector3f scale = new Vector3f();
    private Vector3f speed = new Vector3f();
    private Vector3f deltaSpeed = new Vector3f();
    private float damping = 0.08f;
    private Vector3f averageSpeedNeeded = new Vector3f();

    public SpatialScaleController(Spatial spatial) {
        super(spatial);
        this.scalingQueue = new ArrayList();
        this.scale.set(spatial.getLocalScale());
    }

    public void update(float f) {
        if (f > 0.04f) {
            f = 0.04f;
        }
        if (this.currentScaling == null) {
            this.currentScaling = this.getNextScaling();
        }
        if (this.currentScaling != null) {
            boolean bl = false;
            this.curTime += f;
            if (this.curTime > this.currentScaling.minimumTimeBeforeNextTarget) {
                bl = true;
            } else if (!this.inReverse) {
                this.doScaling(this.currentScaling.finalScale, this.currentScaling.invTime, f);
            } else {
                this.doScaling(this.currentScaling.beginScale, this.currentScaling.invTime, f);
            }
            this.applyScale();
            if (bl) {
                this.remainingScaling = this.currentScaling;
                this.currentScaling = this.getNextScaling();
                if (this.currentScaling == null && this.remainingScaling == null) {
                    this.done();
                }
            }
        } else if (this.remainingScaling != null) {
            boolean bl = false;
            bl = !this.inReverse ? this.doScaling(this.remainingScaling.finalScale, this.remainingScaling.invTime, f) : this.doScaling(this.remainingScaling.finalScale, this.remainingScaling.invTime, f);
            this.applyScale();
            if (bl) {
                this.done();
                this.remainingScaling = null;
            }
        }
    }

    private boolean doScaling(Vector3f vector3f, float f, float f2) {
        this.recalcAverageSpeed(vector3f, f);
        this.deltaSpeed.set(this.averageSpeedNeeded).multLocal(2.0f).subtractLocal(this.speed);
        this.deltaSpeed.multLocal(f2);
        this.averageSpeedNeeded.set(this.speed);
        this.deltaSpeed.subtractLocal(this.averageSpeedNeeded.multLocal(this.damping));
        this.speed.addLocal(this.deltaSpeed);
        this.scale.addLocal(this.speed);
        return this.speed.lengthSquared() < 1.0E-9f && this.deltaSpeed.lengthSquared() < 1.0E-9f;
    }

    private void recalcAverageSpeed(Vector3f vector3f, float f) {
        this.averageSpeedNeeded.set(vector3f).subtractLocal(this.scale);
        this.averageSpeedNeeded.multLocal(f);
    }

    public void setScale(Vector3f vector3f) {
        this.scale.set(vector3f);
        this.applyScale();
    }

    public void setScale(float f, float f2, float f3) {
        this.scale.set(f, f2, f3);
        this.applyScale();
    }

    public void scaleTo(Vector3f vector3f, float f, float f2) {
        this.scale(null, vector3f, f, f2);
    }

    public void scale(Vector3f vector3f, Vector3f vector3f2, float f, float f2) {
        this.clearScalingQueue();
        this.addScalingToQueue(vector3f, vector3f2, f, f2);
    }

    public void addScalingToQueue(Vector3f vector3f, float f, float f2) {
        this.addScalingToQueue(null, vector3f, f, f2);
    }

    public void addScalingToQueue(Vector3f vector3f, Vector3f vector3f2, float f, float f2) {
        ScalingInfo scalingInfo = new ScalingInfo();
        scalingInfo.beginScale = vector3f;
        scalingInfo.finalScale = vector3f2;
        scalingInfo.time = f;
        scalingInfo.invTime = 1.0f / f;
        scalingInfo.minimumTimeBeforeNextTarget = f2;
        if (scalingInfo.beginScale == null) {
            scalingInfo.beginScale = this.scalingQueue.size() > 0 ? new Vector3f(this.scalingQueue.get((int)(this.scalingQueue.size() - 1)).finalScale) : new Vector3f(this.scale);
        }
        this.scalingQueue.add(scalingInfo);
    }

    public void clearScalingQueue() {
        this.scalingQueue.clear();
        this.inReverse = false;
        this.currentScaling = null;
        this.currentScalingIndex = -1;
        this.remainingScaling = null;
        this.curTime = 0.0f;
    }

    public boolean isScaling() {
        return this.currentScaling != null;
    }

    public void restart() {
        this.currentScalingIndex = -1;
        this.curTime = 0.0f;
        this.currentScaling = null;
        this.inReverse = false;
    }

    public void setRepeatType(int n) {
        super.setRepeatType(n);
        this.inReverse = false;
    }

    private void applyScale() {
        this.getSpatial().getLocalScale().set(this.scale);
    }

    private ScalingInfo getNextScaling() {
        if (this.scalingQueue.size() <= 0) {
            return null;
        }
        if (this.getRepeatType() == 0 && this.currentScalingIndex + 1 >= this.scalingQueue.size()) {
            return null;
        }
        this.curTime = 0.0f;
        if (this.currentScalingIndex == -1) {
            this.currentScalingIndex = 0;
        } else {
            this.currentScalingIndex = !this.inReverse ? ++this.currentScalingIndex : --this.currentScalingIndex;
            if (this.currentScalingIndex >= this.scalingQueue.size()) {
                if (this.getRepeatType() == 2) {
                    this.currentScalingIndex = this.scalingQueue.size() - 1;
                    this.inReverse = true;
                } else if (this.getRepeatType() == 1) {
                    this.currentScalingIndex = 0;
                    this.inReverse = false;
                }
            } else if (this.currentScalingIndex < 0) {
                this.currentScalingIndex = 0;
                this.inReverse = false;
            }
        }
        return this.scalingQueue.get(this.currentScalingIndex);
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float f) {
        this.damping = f;
    }

    private class ScalingInfo {
        Vector3f beginScale;
        Vector3f finalScale;
        float time;
        float invTime;
        float minimumTimeBeforeNextTarget;

        private ScalingInfo() {
        }
    }
}

