/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.utils;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.TextureState;

public class Material {
    private ColorRGBA diffuse;
    private ColorRGBA ambient;
    private ColorRGBA emissive;
    private Texture texture;
    private float scaleU;
    private float scaleV;
    private IMaterialChangedListener materialChangedListener;

    public Material(ColorRGBA colorRGBA, ColorRGBA colorRGBA2, ColorRGBA colorRGBA3) {
        this.diffuse = colorRGBA;
        this.ambient = colorRGBA2;
        this.emissive = colorRGBA3;
    }

    public Material() {
    }

    public void setLighting(ColorRGBA colorRGBA, ColorRGBA colorRGBA2, ColorRGBA colorRGBA3) {
        this.diffuse = colorRGBA;
        this.ambient = colorRGBA2;
        this.emissive = colorRGBA3;
    }

    public void setTexture(Texture texture, float f, float f2) {
        this.texture = texture;
        this.scaleU = f;
        this.scaleV = f2;
    }

    public void applyLightingToMaterialState(MaterialState materialState) {
        materialState.setDiffuse(this.diffuse);
        materialState.setAmbient(this.ambient);
        materialState.setEmissive(this.emissive);
    }

    public void update() {
        if (this.materialChangedListener != null) {
            this.materialChangedListener.materialChanged(this);
        }
    }

    public ColorRGBA getAmbient() {
        return this.ambient;
    }

    public ColorRGBA getDiffuse() {
        return this.diffuse;
    }

    public ColorRGBA getEmissive() {
        return this.emissive;
    }

    public float getScaleU() {
        return this.scaleU;
    }

    public float getScaleV() {
        return this.scaleV;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public IMaterialChangedListener getMaterialChangedListener() {
        return this.materialChangedListener;
    }

    public void setMaterialChangedListener(IMaterialChangedListener iMaterialChangedListener) {
        this.materialChangedListener = iMaterialChangedListener;
    }

    public class UpdateSpatialOnMaterialChange
    implements IMaterialChangedListener {
        private Spatial spatial;
        private MaterialState ms;
        private TextureState ts;

        public UpdateSpatialOnMaterialChange(Spatial spatial, TextureState textureState, MaterialState materialState) {
            this.spatial = spatial;
            this.ms = materialState;
            this.ts = textureState;
        }

        public void materialChanged(Material material) {
            if (material.getTexture() != null) {
                material.getTexture().setWrap(3);
                material.getTexture().setScale(new Vector3f(material.getScaleU(), material.getScaleV(), 1.0f));
            }
            if (this.ms != null) {
                material.applyLightingToMaterialState(this.ms);
            }
            if (this.ts != null) {
                this.ts.setTexture(material.getTexture());
            }
            if (this.spatial != null) {
                this.spatial.updateRenderState();
            }
        }
    }

    public static interface IMaterialChangedListener {
        public void materialChanged(Material var1);
    }
}

