/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.statemachine;

import com.turborilla.Updatable;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.statemachine.IState;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.statemachine.TransitionGameState;
import com.turborilla.statemachine.TransitionWork;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transition
implements Updatable,
IEventListener {
    private boolean done = true;
    private boolean readyToSwitch = false;
    private IState transitionToState;
    private StateMachine stateMachine;
    private TransitionGameState loadingGameState;
    private Phase phase = Phase.Nothing;
    private float progress = 0.0f;
    private ArrayList<TransitionWork> transitionWork;
    private boolean paused = false;

    public boolean isDone() {
        return this.done;
    }

    void start() {
        this.start(new ArrayList<TransitionWork>());
    }

    void start(TransitionWork transitionWork) {
        ArrayList<TransitionWork> arrayList = new ArrayList<TransitionWork>();
        arrayList.add(transitionWork);
        this.start(arrayList);
    }

    void start(ArrayList<TransitionWork> arrayList) {
        this.done = false;
        this.readyToSwitch = false;
        this.setProgress(0.0f);
        this.transitionWork = arrayList;
        this.phase = Phase.Before;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).before();
            }
        }
        this.startTransition();
    }

    protected void done() {
        this.done = true;
        this.readyToSwitch = false;
        this.setProgress(0.0f);
        this.transitionWork = null;
    }

    protected abstract boolean before(float var1);

    protected boolean during(float f) {
        if (this.progress >= 0.9999999f) {
            this.progress = 1.0f;
            return true;
        }
        return false;
    }

    protected abstract boolean after(float var1);

    protected abstract void startTransition();

    @Override
    public void update(float f) {
        if (!this.paused && !this.done) {
            this.phase.update(f, this);
        }
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    IState getTransitionToState() {
        return this.transitionToState;
    }

    void setTransitionToState(IState iState) {
        this.transitionToState = iState;
    }

    protected TransitionGameState getLoadingGameState() {
        return this.loadingGameState;
    }

    void setLoadingGameState(TransitionGameState transitionGameState) {
        this.loadingGameState = transitionGameState;
    }

    boolean isReadyToSwitch() {
        if (this.readyToSwitch) {
            this.readyToSwitch = false;
            return true;
        }
        return false;
    }

    protected void setReadyToSwitch(boolean bl) {
        this.readyToSwitch = bl;
    }

    protected StateMachine getStateMachine() {
        return this.stateMachine;
    }

    void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
        if (stateMachine != null) {
            stateMachine.getEventManager().registerListener("SetProgress", this);
            stateMachine.getEventManager().registerListener("IncProgress", this);
        }
    }

    float getProgress() {
        return this.progress;
    }

    void setProgress(float f) {
        if (this.phase == Phase.During) {
            this.progress = f;
        }
    }

    void incProgress(float f) {
        this.setProgress(this.getProgress() + f);
    }

    @Override
    public String getName() {
        return "Transition";
    }

    @Override
    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("SetProgress")) {
            this.setProgress(Float.parseFloat(receivedEvent.getArgumentValue("progress")));
        } else if (receivedEvent.is("IncProgress")) {
            this.incProgress(Float.parseFloat(receivedEvent.getArgumentValue("progress")));
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isRemoveMeFromEventmanager() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Phase {
        Nothing{

            protected boolean update(float f, Transition transition) {
                return false;
            }
        }
        ,
        Before{

            protected boolean update(float f, Transition transition) {
                if (transition.before(f)) {
                    transition.phase = During;
                    transition.setReadyToSwitch(true);
                    return true;
                }
                return false;
            }
        }
        ,
        During{

            protected boolean update(float f, Transition transition) {
                transition.during(f);
                if (transition.transitionWork == null || Phase.during(f, transition.transitionWork)) {
                    transition.phase = After;
                    return true;
                }
                return false;
            }
        }
        ,
        After{

            protected boolean update(float f, Transition transition) {
                if (transition.after(f)) {
                    transition.phase = Nothing;
                    if (transition.transitionWork != null) {
                        Phase.after(transition.transitionWork);
                    }
                    transition.done();
                    return true;
                }
                return false;
            }
        };


        private static boolean during(float f, ArrayList<TransitionWork> arrayList) {
            boolean bl = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).during(f)) continue;
                bl = false;
            }
            return bl;
        }

        private static void after(ArrayList<TransitionWork> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).after();
            }
        }

        protected abstract boolean update(float var1, Transition var2);
    }
}

