/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.statemachine;

import com.jme.system.GameSettings;
import com.mallardsoft.tuple.Pair;
import com.turborilla.Updatable;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.statemachine.FadingTransitionGameState;
import com.turborilla.statemachine.IState;
import com.turborilla.statemachine.Transition;
import com.turborilla.statemachine.TransitionGameState;
import com.turborilla.statemachine.TransitionWork;
import com.turborilla.utils.Scheduling;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachine
implements IEventListener,
Updatable {
    private static final Logger logger = Logger.getLogger(StateMachine.class.getName());
    private ArrayList<IState> states = new ArrayList();
    private Map<Pair<String, String>, ArrayList<TransitionWork>> transitions;
    private IState currentState;
    private Transition currentTransition;
    private EventManager eventManager;
    private GameSettings settings;
    private TransitionGameState loadingGameState;
    private Scheduling taskManager;
    String name;
    private boolean paused = false;

    public StateMachine(String string, EventManager eventManager, IState iState, GameSettings gameSettings, FadingTransitionGameState fadingTransitionGameState) {
        this.loadingGameState = fadingTransitionGameState;
        this.settings = gameSettings;
        this.eventManager = eventManager;
        this.taskManager = new Scheduling();
        this.transitions = new HashMap<Pair<String, String>, ArrayList<TransitionWork>>();
        this.setName(string);
        this.add(iState);
    }

    public boolean activateState(IState iState) {
        if (this.states.contains(iState)) {
            this.switchState(iState);
            return true;
        }
        return false;
    }

    public boolean activateState(String string) {
        IState iState = this.findState(string);
        if (iState != null) {
            this.switchState(iState);
            return true;
        }
        logger.severe("Could not find requested FSM state \"" + string + "\".");
        return false;
    }

    public IState findState(String string) {
        for (int i = 0; i < this.states.size(); ++i) {
            if (!string.equals(this.states.get(i).getName())) continue;
            return this.states.get(i);
        }
        return null;
    }

    private IState switchState(IState iState) {
        this.taskManager.clearSchedule();
        IState iState2 = this.currentState;
        this.currentState = iState;
        if (iState2 != null) {
            iState2.onLeave();
        }
        logger.info("Switched state from \"" + iState2 + "\" to \"" + iState + "\".");
        if (iState2 != null) {
            this.currentState.onEnter(iState2.getName());
        } else {
            this.currentState.onEnter(null);
        }
        return iState2;
    }

    public boolean transitionToState(String string) {
        ArrayList<TransitionWork> arrayList = this.transitions.get(new Pair<String, String>(this.currentState.getName(), string));
        return this.transitionToState(string, arrayList);
    }

    private boolean transitionToState(String string, ArrayList<TransitionWork> arrayList) {
        IState iState = this.findState(string);
        if (iState != null) {
            Transition transition = this.getLoadingGameState().getTransition();
            transition.setStateMachine(this);
            transition.setTransitionToState(iState);
            transition.setLoadingGameState(this.loadingGameState);
            this.currentTransition = transition;
            this.currentTransition.start(arrayList);
            return true;
        }
        logger.severe("Could not find requested FSM state \"" + string + "\".");
        return false;
    }

    @Override
    public void update(float f) {
        if (!this.paused) {
            if (this.currentTransition != null) {
                this.currentTransition.update(f);
                if (this.currentTransition.isReadyToSwitch() && !this.currentTransition.isDone()) {
                    IState iState = this.currentTransition.getTransitionToState();
                    this.currentTransition.setTransitionToState(null);
                    this.switchState(iState);
                }
                if (this.currentTransition.isDone()) {
                    this.currentTransition = null;
                }
            }
            this.taskManager.update(f);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void handleEvent(ReceivedEvent receivedEvent) {
        this.currentState.handleEvent(receivedEvent);
    }

    public void registerForEvent(String string, IState iState) {
        this.eventManager.registerListener(string, this);
    }

    public boolean add(IState iState) {
        if (this.states.contains(iState)) {
            return false;
        }
        if (this.states.add(iState)) {
            iState.setStateMachine(this);
            if (this.currentState == null) {
                this.switchState(iState);
            }
            return true;
        }
        return false;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public GameSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    TransitionGameState getLoadingGameState() {
        return this.loadingGameState;
    }

    void setLoadingGameState(TransitionGameState transitionGameState) {
        this.loadingGameState = transitionGameState;
    }

    public void addTransition(String string, String string2, TransitionWork transitionWork) {
        ArrayList<TransitionWork> arrayList = this.transitions.get(new Pair<String, String>(string, string2));
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.transitions.put(new Pair<String, String>(string, string2), arrayList);
        }
        arrayList.add(transitionWork);
    }

    public Scheduling getTaskManager() {
        return this.taskManager;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isRemoveMeFromEventmanager() {
        return false;
    }

    public String getCurrentState() {
        if (this.currentState == null) {
            return null;
        }
        return this.currentState.getName();
    }
}

