/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.sound;

import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.turborilla.TransformationProvider;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import paulscode.sound.CommandObject;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;

public class TurboSoundSystem
extends SoundSystem {
    private Camera camera;
    private TransformationProvider listenerPositionProvider;
    private Object cameraLock = new Object();
    private Map<String, WeakReference<TransformationProvider>> sourceToProviderMap;
    private Map<String, String> sourceToVolumeCategoryMap;
    private Map<String, Float> sourceToIndividualVolumeMap;
    private Map<String, Float> volumeCategoryVolume;
    private Vector3f worldTranslation = new Vector3f();
    private HashMap<String, Fade> fadeMap = new HashMap();

    public TurboSoundSystem() {
        this.initMaps();
    }

    public TurboSoundSystem(Class clazz) throws SoundSystemException {
        super(clazz);
        this.initMaps();
    }

    private void initMaps() {
        this.sourceToProviderMap = Collections.synchronizedMap(new HashMap());
        this.sourceToVolumeCategoryMap = Collections.synchronizedMap(new HashMap());
        this.sourceToIndividualVolumeMap = Collections.synchronizedMap(new HashMap());
        this.volumeCategoryVolume = Collections.synchronizedMap(new HashMap());
    }

    public void setCamera(Camera camera) {
        this.setCamera(camera, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCamera(Camera camera, TransformationProvider transformationProvider) {
        Object object = this.cameraLock;
        synchronized (object) {
            this.camera = camera;
            this.listenerPositionProvider = transformationProvider;
        }
        this.update();
    }

    public void setProvider(String string, TransformationProvider transformationProvider) {
        this.sourceToProviderMap.put(string, new WeakReference<TransformationProvider>(transformationProvider));
    }

    public TransformationProvider removeProviderForSource(String string) {
        if (string == null) {
            return null;
        }
        WeakReference<TransformationProvider> weakReference = this.sourceToProviderMap.remove(string);
        if (weakReference != null) {
            return (TransformationProvider)weakReference.get();
        }
        return null;
    }

    public void removeAllProviders() {
        this.sourceToProviderMap.clear();
    }

    public void setVolumeCategory(String string, String string2) {
        this.sourceToVolumeCategoryMap.put(string, string2);
        this.setActualVolume(string);
    }

    public String removeVolumeCategoryForSource(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.sourceToVolumeCategoryMap.remove(string);
        return string2;
    }

    public void removeAllVolumeCategories() {
        this.sourceToVolumeCategoryMap.clear();
    }

    public void clearIndividualVolumes() {
        this.sourceToIndividualVolumeMap.clear();
    }

    public void setCategoryVolume(String string, float f) {
        Float f2 = this.volumeCategoryVolume.get(string);
        if (f2 == null) {
            f2 = Float.valueOf(-1.0f);
        }
        if (f2.floatValue() != f) {
            this.volumeCategoryVolume.put(string, Float.valueOf(f));
            this.setActualVolumeOnAllSources(string);
        }
    }

    public void setVolume(String string, float f) {
        this.sourceToIndividualVolumeMap.put(string, Float.valueOf(f));
        this.setActualVolume(string);
    }

    private void setActualVolume(String string) {
        super.setVolume(string, this.getVolumeAccordingToCategory(string) * this.getPreviouslySetIndividualVolume(string));
    }

    private void setActualVolumeOnAllSources(String string) {
        for (Map.Entry<String, String> entry : this.sourceToVolumeCategoryMap.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (string2 == null || string3 == null || !string3.equals(string)) continue;
            this.setActualVolume(string2);
        }
    }

    private float getVolumeAccordingToCategory(String string) {
        float f = 1.0f;
        String string2 = this.sourceToVolumeCategoryMap.get(string);
        if (string2 != null) {
            Float f2 = this.volumeCategoryVolume.get(string2);
            f = f2 != null ? f2.floatValue() : 1.0f;
        }
        return f;
    }

    private float getPreviouslySetIndividualVolume(String string) {
        Float f = this.sourceToIndividualVolumeMap.get(string);
        return f != null ? f.floatValue() : 1.0f;
    }

    public void update() {
        this.update(0.016666668f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(float f) {
        Object object;
        Object object2;
        Object object3;
        Camera camera = null;
        TransformationProvider transformationProvider = null;
        Object object4 = this.cameraLock;
        synchronized (object4) {
            camera = this.camera;
            transformationProvider = this.listenerPositionProvider;
        }
        if (camera != null) {
            object4 = null;
            object4 = transformationProvider == null ? camera.getLocation() : transformationProvider.getWorldTranslation().toVector3f(this.worldTranslation);
            object3 = camera.getDirection();
            object2 = camera.getUp();
            object = this.soundLibrary.getListenerData();
            if (object != null) {
                if (((ListenerData)object).position.x != ((Vector3f)object4).x || ((ListenerData)object).position.y != ((Vector3f)object4).y || ((ListenerData)object).position.z != ((Vector3f)object4).z) {
                    this.setListenerPosition(((Vector3f)object4).x, ((Vector3f)object4).y, ((Vector3f)object4).z);
                }
                if (((ListenerData)object).lookAt.x != ((Vector3f)object3).x || ((ListenerData)object).lookAt.y != ((Vector3f)object3).y || ((ListenerData)object).lookAt.z != ((Vector3f)object3).z || ((ListenerData)object).up.x != ((Vector3f)object2).x || ((ListenerData)object).up.y != ((Vector3f)object2).y || ((ListenerData)object).up.z != ((Vector3f)object2).z) {
                    this.setListenerOrientation(((Vector3f)object3).x, ((Vector3f)object3).y, ((Vector3f)object3).z, ((Vector3f)object2).x, ((Vector3f)object2).y, ((Vector3f)object2).z);
                }
            }
        }
        if (this.sourceToProviderMap != null && this.soundLibrary != null) {
            object4 = this.sourceToProviderMap.entrySet();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                Map.Entry entry = (Map.Entry)object3.next();
                object2 = (String)entry.getKey();
                object = this.soundLibrary.getSource((String)object2);
                if (object == null) {
                    object3.remove();
                    continue;
                }
                TransformationProvider transformationProvider2 = entry.getValue() != null ? (TransformationProvider)((WeakReference)entry.getValue()).get() : null;
                if (transformationProvider2 == null) {
                    object3.remove();
                    continue;
                }
                this.worldTranslation = transformationProvider2.getWorldTranslation().toVector3f(this.worldTranslation);
                this.setPositionToCurrentProvider((String)object2, (Source)object);
            }
        }
        this.updateFades(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPositionToCurrentProvider(String string, Source source) {
        boolean bl = false;
        Object object = this.sourceLock;
        synchronized (object) {
            bl = source != null && source.position != null && (source.position.x != this.worldTranslation.x || source.position.y != this.worldTranslation.y || source.position.z != this.worldTranslation.z);
        }
        if (bl) {
            this.setPosition(string, this.worldTranslation.x, this.worldTranslation.y, this.worldTranslation.z);
        }
    }

    public void setPosition(String string, float f, float f2, float f3) {
        this.CommandQueue(new CommandObject(13, string, f, f2, f3));
        this.commandThread.interrupt();
    }

    public void moveListener(float f, float f2, float f3) {
        this.CommandQueue(new CommandObject(31, f, f2, f3));
        this.commandThread.interrupt();
    }

    public void setListenerPosition(float f, float f2, float f3) {
        this.CommandQueue(new CommandObject(32, f, f2, f3));
        this.commandThread.interrupt();
    }

    public void setListenerOrientation(float f, float f2, float f3, float f4, float f5, float f6) {
        this.CommandQueue(new CommandObject(35, f, f2, f3, f4, f5, f6));
        this.commandThread.interrupt();
    }

    public void setListenerOrientation(Camera camera) {
        if (camera == null) {
            return;
        }
        Vector3f vector3f = camera.getDirection();
        Vector3f vector3f2 = camera.getUp();
        this.setListenerOrientation(vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z);
    }

    protected void init(Class clazz) throws SoundSystemException {
        this.className = "TurboSoundSystem";
        super.init(clazz);
    }

    protected void linkDefaultLibrariesAndCodecs() {
    }

    public void cleanup() {
        super.cleanup();
        try {
            if (this.sourceToProviderMap != null) {
                this.sourceToProviderMap.clear();
            }
            if (this.sourceToVolumeCategoryMap != null) {
                this.sourceToVolumeCategoryMap.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.camera = null;
        this.listenerPositionProvider = null;
    }

    public String playSFX(String string) {
        return this.playSFX(string, false);
    }

    public String playSFX(String string, boolean bl) {
        return this.playSFX(string, null, bl, null);
    }

    public String playSFX(String string, boolean bl, String string2) {
        return this.playSFX(string, null, bl, string2);
    }

    public String playSFX(String string, String string2) {
        return this.playSFX(string, null, string2);
    }

    public String playSFX(String string, TransformationProvider transformationProvider, String string2) {
        return this.playSFX(string, transformationProvider, false, string2);
    }

    public String playSFX(String string, TransformationProvider transformationProvider, boolean bl, String string2) {
        if (transformationProvider == null) {
            return this.playSFX(string, transformationProvider, bl, 0, 0.0f, string2, 1.0f);
        }
        if (SoundSystemConfig.getDefaultAttenuation() == 2) {
            return this.playSFX(string, transformationProvider, bl, SoundSystemConfig.getDefaultAttenuation(), SoundSystemConfig.getDefaultFadeDistance(), string2, 1.0f);
        }
        if (SoundSystemConfig.getDefaultAttenuation() == 1) {
            return this.playSFX(string, transformationProvider, bl, SoundSystemConfig.getDefaultAttenuation(), SoundSystemConfig.getDefaultRolloff(), string2, 1.0f);
        }
        return this.playSFX(string, transformationProvider, bl, SoundSystemConfig.getDefaultAttenuation(), 0.0f, string2, 1.0f);
    }

    public String playSFX(String string, TransformationProvider transformationProvider, boolean bl, int n, float f, String string2, float f2) {
        if (transformationProvider == null) {
            n = 0;
            f = 0.0f;
        }
        String string3 = this.quickPlay(false, string, bl, 0.0f, 0.0f, 0.0f, n, f);
        this.setPitch(string3, f2);
        if (string2 != null) {
            this.setVolumeCategory(string3, string2);
        }
        if (transformationProvider != null) {
            this.setProvider(string3, transformationProvider);
        }
        return string3;
    }

    public void fadeIn(String string, float f) {
        this.setVolume(string, 0.0f);
        this.addFade(new SourceFadeVolume(string, 0.0f, this.getVolumeAccordingToCategory(string), 1.0f / f, null));
    }

    public void fadeOutAndStop(final String string, float f) {
        this.addFade(new SourceFadeVolume(string, this.getVolume(string), 0.0f, 1.0f / f, new Runnable(){

            public void run() {
                TurboSoundSystem.this.stop(string);
            }
        }));
    }

    public void setCategoryVolume(String string, float f, float f2) {
        Float f3 = this.volumeCategoryVolume.get(string);
        this.addFade(new CategoryFadeVolume(string, f3 != null ? f3.floatValue() : 0.5f, f, 1.0f / f2, null));
    }

    public void setVolume(String string, float f, float f2) {
        float f3 = this.getVolume(string);
        this.addFade(new SourceFadeVolume(string, f3, f, 1.0f / f2, null));
    }

    public void addFade(Fade fade) {
        Fade fade2 = this.fadeMap.put(fade.name, fade);
        if (fade2 != null) {
            fade2.apply();
        }
    }

    public void clearFade(String string) {
        Fade fade = this.fadeMap.remove(string);
        if (fade != null) {
            fade.apply();
        }
    }

    private void updateFades(float f) {
        Collection<Fade> collection = this.fadeMap.values();
        Iterator<Fade> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Fade fade = iterator.next();
            if (!fade.update(f)) continue;
            iterator.remove();
        }
    }

    public class SourceFadePitch
    extends Fade {
        public SourceFadePitch(String string, float f, float f2, float f3, Runnable runnable) {
            super(string, f, f2, f3, runnable);
        }

        public void apply() {
            TurboSoundSystem.this.setPitch(this.name, this.currentValue);
        }
    }

    public class CategoryFadeVolume
    extends Fade {
        public CategoryFadeVolume(String string, float f, float f2, float f3, Runnable runnable) {
            super(string, f, f2, f3, runnable);
        }

        public void apply() {
            TurboSoundSystem.this.setCategoryVolume(this.name, this.currentValue);
        }
    }

    public class SourceFadeVolume
    extends Fade {
        public SourceFadeVolume(String string, float f, float f2, float f3, Runnable runnable) {
            super(string, f, f2, f3, runnable);
        }

        public void apply() {
            TurboSoundSystem.this.setVolume(this.name, this.currentValue);
        }
    }

    public abstract class Fade {
        float startValue;
        float targetValue;
        float currentValue;
        float changeRate;
        Runnable callOnCompleted;
        String name;

        protected Fade(String string, float f, float f2, float f3, Runnable runnable) {
            if (f3 < 0.0f && f2 > f || f3 > 0.0f && f2 < f) {
                f3 = -f3;
            }
            this.name = string;
            this.startValue = f;
            this.targetValue = f2;
            this.changeRate = f3;
            this.currentValue = f;
            this.callOnCompleted = runnable;
            this.apply();
        }

        public boolean update(float f) {
            boolean bl = false;
            this.currentValue += this.changeRate * f;
            if (this.changeRate < 0.0f && this.currentValue <= this.targetValue || this.changeRate > 0.0f && this.currentValue >= this.targetValue) {
                bl = true;
                this.currentValue = this.targetValue;
                if (this.callOnCompleted != null) {
                    this.callOnCompleted.run();
                }
            }
            this.apply();
            return bl;
        }

        public abstract void apply();
    }
}

