/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay.nioreplay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.turborilla.TransformationCoupler;
import com.turborilla.TransformationProvider;
import com.turborilla.replay.nioreplay.BaseReplayData;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ReplayDataTransformation
extends BaseReplayData {
    private static final Logger logger = Logger.getLogger(ReplayDataTransformation.class.getName());
    protected ArrayList<TransformationProvider> providers;
    protected ArrayList<TransformationCoupler> couplers;
    protected int elementSize = 40;
    protected Vector3d translation = new Vector3d();
    protected Quaternion rotation = new Quaternion();
    protected Vector3d scale = new Vector3d();
    private int version = 1;

    public ReplayDataTransformation() {
        this.providers = new ArrayList();
        this.couplers = new ArrayList();
    }

    public ByteBuffer getCurrentState() {
        if (!this.isLocked()) {
            logger.warning("Cannot get current state for replay when not locked for recording");
            return null;
        }
        this.tempBuffer.clear();
        for (int i = 0; i < this.providers.size(); ++i) {
            TransformationProvider transformationProvider = this.providers.get(i);
            Vector3d vector3d = transformationProvider.getLocalTranslation();
            Quaternion quaternion = transformationProvider.getLocalRotation();
            Vector3d vector3d2 = transformationProvider.getLocalScale();
            this.tempBuffer.putFloat((float)vector3d.x);
            this.tempBuffer.putFloat((float)vector3d.y);
            this.tempBuffer.putFloat((float)vector3d.z);
            this.tempBuffer.putFloat((float)quaternion.x);
            this.tempBuffer.putFloat((float)quaternion.y);
            this.tempBuffer.putFloat((float)quaternion.z);
            this.tempBuffer.putFloat((float)quaternion.w);
            this.tempBuffer.putFloat((float)vector3d2.x);
            this.tempBuffer.putFloat((float)vector3d2.y);
            this.tempBuffer.putFloat((float)vector3d2.z);
        }
        this.tempBuffer.flip();
        return this.tempBuffer;
    }

    public void setCurrentState(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, double d) {
        boolean bl = true;
        if (this.couplers.isEmpty()) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < this.couplers.size(); ++i) {
                this.setTransformationState(this.translation, this.rotation, this.scale, byteBuffer, byteBuffer2, d);
                TransformationCoupler transformationCoupler = this.couplers.get(i);
                transformationCoupler.setLocalTranslation(this.translation);
                transformationCoupler.setLocalRotation(this.rotation);
                transformationCoupler.setLocalScale(this.scale);
            }
        } else {
            for (int i = 0; i < this.providers.size(); ++i) {
                TransformationProvider transformationProvider = this.providers.get(i);
                this.setTransformationState(transformationProvider.getLocalTranslation(), transformationProvider.getLocalRotation(), transformationProvider.getLocalScale(), byteBuffer, byteBuffer2, d);
            }
        }
    }

    protected void setTransformationState(Vector3d vector3d, Quaternion quaternion, Vector3d vector3d2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, double d) {
        double d2 = byteBuffer.getFloat();
        double d3 = byteBuffer2.getFloat();
        vector3d.x = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        vector3d.y = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        vector3d.z = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        quaternion.x = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        quaternion.y = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        quaternion.z = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        quaternion.w = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        vector3d2.x = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        vector3d2.y = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        vector3d2.z = d2 + (d3 - d2) * d;
    }

    public void addTransformationProvider(TransformationProvider transformationProvider) {
        if (this.isLocked()) {
            logger.warning("Cannot add a TransformationProvider while ReplayData is locked");
            return;
        }
        this.providers.add(transformationProvider);
        this.setSize(this.getSize() + this.elementSize);
    }

    public void addTransformationCoupler(TransformationCoupler transformationCoupler) {
        if (this.isLocked()) {
            logger.warning("Cannot add a TransformationCoupler while ReplayData is locked");
            return;
        }
        this.couplers.add(transformationCoupler);
    }

    public TransformationCoupler getTransformationCoupler(String string) {
        for (int i = 0; i < this.couplers.size(); ++i) {
            if (!string.equals(this.couplers.get(i).getName())) continue;
            return this.couplers.get(i);
        }
        return null;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            Logger.getLogger(this.getClassTag().getName()).warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                String[] stringArray = inputCapsule.readStringArray("providers", null);
                if (stringArray == null) break;
                this.couplers = new ArrayList();
                for (String string : stringArray) {
                    this.couplers.add(new TransformationCoupler(string));
                }
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        String[] stringArray = new String[this.providers.size()];
        int n = 0;
        for (TransformationProvider transformationProvider : this.providers) {
            stringArray[n] = transformationProvider.getName();
            ++n;
        }
        outputCapsule.write(stringArray, "providers", null);
    }
}

