/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay.nioreplay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.TransformationCoupler;
import com.turborilla.replay.nioreplay.BaseReplayData;
import com.turborilla.replay.nioreplay.BufferAbstractor;
import com.turborilla.replay.nioreplay.ChannelAbstractor;
import com.turborilla.replay.nioreplay.NioAbstractor;
import com.turborilla.replay.nioreplay.ReplayDataTransformation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioReplay
implements Savable {
    private static final Logger logger = Logger.getLogger(NioReplay.class.getName());
    private NioAbstractor store;
    private int frameSize = 0;
    private double currentTime = 0.0;
    private int currentFrame = 0;
    private ByteBuffer frameHeader;
    private int everyNthFrame = 1;
    private Exception exceptionReplayInterruptedBy = null;
    private ArrayList<BaseReplayData> replayElements = new ArrayList();
    protected boolean recording = false;
    protected boolean replaying = false;
    private Runnable replayDoneListener;
    private int savedFrameSize = -1;
    protected Frame frame1;
    protected Frame frame2;
    private int version = 1;

    public NioReplay(FileChannel fileChannel, int n) {
        this(n);
        this.store = new ChannelAbstractor(fileChannel);
    }

    public NioReplay(ByteBuffer byteBuffer, int n) {
        this(n);
        this.store = new BufferAbstractor(byteBuffer);
    }

    private NioReplay(int n) {
        this.everyNthFrame = n;
    }

    public NioReplay() {
        this(1);
    }

    public void addReplayElement(BaseReplayData baseReplayData) {
        this.replayElements.add(baseReplayData);
    }

    public void clearReplayElements() {
        this.replayElements.clear();
    }

    public Runnable getReplayDoneListener() {
        return this.replayDoneListener;
    }

    public void update(double d) {
        if (this.replaying) {
            boolean bl = false;
            try {
                bl = this.replayOneFrame();
            }
            catch (IOException iOException) {
                logger.warning("Caught IOException in replay.update() : " + iOException);
                bl = false;
            }
            this.currentTime += d;
            ++this.currentFrame;
            if (!bl) {
                this.stopReplaying();
                if (this.replayDoneListener != null) {
                    this.replayDoneListener.run();
                }
            }
        } else if (this.recording) {
            if (this.currentFrame % this.everyNthFrame == 0) {
                this.recordThisFrame();
            }
            this.currentTime += d;
            ++this.currentFrame;
        }
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void setReplayDoneListener(Runnable runnable) {
        this.replayDoneListener = runnable;
    }

    public void startReplaying() {
        if (this.exceptionReplayInterruptedBy != null) {
            logger.severe("Cannot replay, the recording was interrupted by Exception: " + this.exceptionReplayInterruptedBy);
            return;
        }
        if (this.replaying) {
            return;
        }
        if (this.recording) {
            this.stopRecording();
        }
        try {
            this.store.rewind();
        }
        catch (IOException iOException) {
            logger.severe("Can not rewind replay store. Exception: " + iOException);
        }
        this.replaying = true;
        this.currentTime = 0.0;
        this.currentFrame = 0;
        this.frameSize = 0;
        this.frameSize += 8;
        this.frameHeader = ByteBuffer.allocate(this.frameSize);
        this.frameHeader.clear();
        for (int i = 0; i < this.replayElements.size(); ++i) {
            BaseReplayData baseReplayData = this.replayElements.get(i);
            this.frameSize += baseReplayData.getSize();
            baseReplayData.lock();
        }
        if (this.savedFrameSize > 0 && this.frameSize != this.savedFrameSize) {
            logger.severe("Framesizes differ. Saved frameSize: " + this.savedFrameSize + " current frameSize: " + this.frameSize);
        }
        if (this.frame1 == null) {
            this.frame1 = new Frame();
        }
        if (this.frame1.data == null || this.frame1.data.capacity() != this.frameSize) {
            this.frame1.data = ByteBuffer.allocate(this.frameSize);
        }
        this.frame1.time = -1.0;
        this.frame1.data.clear();
        if (this.frame2 == null) {
            this.frame2 = new Frame();
        }
        if (this.frame2.data == null || this.frame2.data.capacity() != this.frameSize) {
            this.frame2.data = ByteBuffer.allocate(this.frameSize);
        }
        this.frame2.time = -1.0;
        this.frame2.data.clear();
    }

    public void startRecording() {
        if (this.recording) {
            return;
        }
        if (this.replaying) {
            this.stopReplaying();
        }
        try {
            this.store.clear();
        }
        catch (IOException iOException) {
            logger.severe("Can not clear replay store. Exception: " + iOException);
        }
        this.exceptionReplayInterruptedBy = null;
        this.recording = true;
        this.currentTime = 0.0;
        this.currentFrame = 0;
        this.frameSize = 0;
        this.frameSize += 8;
        this.frameHeader = ByteBuffer.allocate(this.frameSize);
        this.frameHeader.clear();
        for (int i = 0; i < this.replayElements.size(); ++i) {
            BaseReplayData baseReplayData = this.replayElements.get(i);
            this.frameSize += baseReplayData.getSize();
            baseReplayData.lock();
        }
        this.savedFrameSize = this.frameSize;
    }

    public void stopReplaying() {
        if (!this.replaying) {
            return;
        }
        this.replaying = false;
        for (int i = 0; i < this.replayElements.size(); ++i) {
            BaseReplayData baseReplayData = this.replayElements.get(i);
            baseReplayData.unlock();
        }
    }

    public void stopRecording() {
        if (!this.recording) {
            return;
        }
        this.recording = false;
        this.store.flush();
        for (int i = 0; i < this.replayElements.size(); ++i) {
            BaseReplayData baseReplayData = this.replayElements.get(i);
            baseReplayData.unlock();
        }
    }

    protected boolean replayOneFrame() throws IOException {
        double d = -1.0;
        int n = 0;
        while (!(this.currentTime >= this.frame1.time) || !(this.currentTime <= this.frame2.time)) {
            this.frame1.data.clear();
            if (this.frame2.time >= 0.0) {
                this.frame2.data.rewind();
                this.frame1.data.put(this.frame2.data);
            } else {
                n = this.store.read(this.frame1.data);
                if (n <= 0) {
                    return false;
                }
            }
            this.frame1.data.flip();
            this.frame1.time = this.frame1.data.getDouble();
            this.frame2.data.clear();
            n = this.store.read(this.frame2.data);
            if (n <= 0) {
                return false;
            }
            this.frame2.data.flip();
            this.frame2.time = this.frame2.data.getDouble();
        }
        this.frame1.data.position(8);
        this.frame2.data.position(8);
        d = (this.currentTime - this.frame1.time) / (this.frame2.time - this.frame1.time);
        for (int i = 0; i < this.replayElements.size(); ++i) {
            BaseReplayData baseReplayData = this.replayElements.get(i);
            int n2 = this.frame1.data.position();
            int n3 = this.frame2.data.position();
            baseReplayData.setCurrentState(this.frame1.data, this.frame2.data, d);
            this.frame1.data.position(n2 + baseReplayData.getSize());
            this.frame2.data.position(n3 + baseReplayData.getSize());
        }
        return true;
    }

    protected void recordThisFrame() {
        this.frameHeader.clear();
        this.frameHeader.putDouble(this.currentTime);
        this.frameHeader.flip();
        try {
            this.store.write(this.frameHeader);
            for (int i = 0; i < this.replayElements.size(); ++i) {
                BaseReplayData baseReplayData = this.replayElements.get(i);
                this.store.write(baseReplayData.getCurrentState());
            }
        }
        catch (IOException iOException) {
            logger.severe("IO error, cannot record this frame of replay, cancelling replay recording. Exception: " + iOException);
            this.exceptionReplayInterruptedBy = iOException;
            this.stopRecording();
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isReplaying() {
        return this.replaying;
    }

    public Iterator<BaseReplayData> getReplayElementsIterator() {
        return this.replayElements.iterator();
    }

    public TransformationCoupler getTransformationCoupler(String string) {
        TransformationCoupler transformationCoupler = null;
        Iterator<BaseReplayData> iterator = this.getReplayElementsIterator();
        while (iterator.hasNext() && transformationCoupler == null) {
            BaseReplayData baseReplayData = iterator.next();
            if (!(baseReplayData instanceof ReplayDataTransformation)) continue;
            ReplayDataTransformation replayDataTransformation = (ReplayDataTransformation)baseReplayData;
            transformationCoupler = replayDataTransformation.getTransformationCoupler(string);
        }
        return transformationCoupler;
    }

    @Override
    public Class getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            Logger.getLogger(this.getClassTag().getName()).warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.store = (NioAbstractor)inputCapsule.readSavable("store", null);
                this.everyNthFrame = inputCapsule.readInt("everyNthFrame", 1);
                this.savedFrameSize = inputCapsule.readInt("frameSize", -1);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.store, "store", null);
        outputCapsule.write(this.everyNthFrame, "everyNthFrame", 1);
        outputCapsule.write(this.frameSize, "frameSize", -1);
    }

    protected class Frame {
        double time = 0.0;
        ByteBuffer data = null;

        protected Frame() {
        }
    }
}

