/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay.nioreplay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.turborilla.replay.nioreplay.NioAbstractor;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class BufferAbstractor
implements NioAbstractor {
    private ByteBuffer buf;
    private byte[] array;

    public BufferAbstractor(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
    }

    public BufferAbstractor() {
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        try {
            this.buf.put(byteBuffer);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException.toString());
        }
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.array == null || this.array.length != byteBuffer.capacity()) {
            this.array = new byte[byteBuffer.capacity()];
        }
        try {
            this.buf.get(this.array);
            byteBuffer.put(this.array);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return -1;
        }
        return this.array.length;
    }

    public void rewind() throws IOException {
        this.buf.rewind();
    }

    public void clear() throws IOException {
        this.buf.clear();
    }

    public void flush() {
        this.buf.flip();
        this.buf.position(this.buf.limit());
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        byte[] byArray = inputCapsule.readByteArray("bufArray", null);
        this.buf = byArray == null ? ByteBuffer.allocate(0) : ByteBuffer.allocate(byArray.length).put(byArray);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        int n = this.buf.position();
        this.buf.rewind();
        byte[] byArray = new byte[n];
        this.buf.get(byArray);
        outputCapsule.write(byArray, "bufArray", (byte[])null);
        this.buf.position(n);
    }
}

