/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay.nioreplay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public abstract class BaseReplayData
implements Savable {
    protected ByteBuffer tempBuffer;
    private int size = 0;
    private boolean locked = false;
    private int version = 1;

    public abstract ByteBuffer getCurrentState();

    public abstract void setCurrentState(ByteBuffer var1, ByteBuffer var2, double var3);

    protected final void setSize(int n) {
        this.size = n;
    }

    public final int getSize() {
        return this.size;
    }

    final void lock() {
        this.locked = true;
        this.tempBuffer = ByteBuffer.allocate(this.size);
        this.tempBuffer.clear();
    }

    final void unlock() {
        this.locked = false;
        this.tempBuffer = null;
    }

    protected final boolean isLocked() {
        return this.locked;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            Logger.getLogger(this.getClassTag().getName()).warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.size = inputCapsule.readInt("size", 0);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.size, "size", 0);
    }
}

