/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay;

import com.turborilla.TransformationCoupler;
import com.turborilla.TransformationProvider;
import com.turborilla.replay.BaseReplayToFile;
import com.turborilla.replay.IReplayFrame;
import com.turborilla.replay.ReplayFrameTransformationProvider;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ReplayToFileTransformationProvider
extends BaseReplayToFile {
    private static final Logger logger = Logger.getLogger(ReplayToFileTransformationProvider.class.getName());
    protected ArrayList<TransformationProvider> providers;
    protected ArrayList<TransformationCoupler> couplers;
    protected int numberOfProviders = 0;
    private Vector3d tempTranslation = new Vector3d();
    private Quaternion tempRotation = new Quaternion();
    private Vector3d tempScale = new Vector3d();

    public ReplayToFileTransformationProvider(String string, String string2) {
        super(string, string2);
        this.providers = new ArrayList();
        this.couplers = new ArrayList();
    }

    public IReplayFrame loadFrameFromFileChannel(FileChannel fileChannel) throws IOException {
        ReplayFrameTransformationProvider replayFrameTransformationProvider = new ReplayFrameTransformationProvider(this.providers);
        replayFrameTransformationProvider.fromFileChannel(fileChannel);
        return replayFrameTransformationProvider;
    }

    public void addTransformationProvider(TransformationProvider transformationProvider) {
        if (this.isRecording()) {
            logger.warning("Cannot add a TransformationProvider while recording replay");
            return;
        }
        this.providers.add(transformationProvider);
    }

    public void addTransformationCoupler(TransformationCoupler transformationCoupler) {
        if (this.isReplaying()) {
            logger.warning("Cannot add a TransformationCoupler while replaying");
            return;
        }
        this.couplers.add(transformationCoupler);
    }

    public void applyFrames(double d, IReplayFrame iReplayFrame, IReplayFrame iReplayFrame2) {
        ReplayFrameTransformationProvider replayFrameTransformationProvider = (ReplayFrameTransformationProvider)iReplayFrame;
        ReplayFrameTransformationProvider replayFrameTransformationProvider2 = (ReplayFrameTransformationProvider)iReplayFrame2;
        int n = 0;
        for (TransformationCoupler transformationCoupler : this.couplers) {
            int n2 = n * 10;
            this.tempTranslation.x = replayFrameTransformationProvider.values[n2 + 0] + (replayFrameTransformationProvider2.values[n2 + 0] - replayFrameTransformationProvider.values[n2 + 0]) * d;
            this.tempTranslation.y = replayFrameTransformationProvider.values[n2 + 1] + (replayFrameTransformationProvider2.values[n2 + 1] - replayFrameTransformationProvider.values[n2 + 1]) * d;
            this.tempTranslation.z = replayFrameTransformationProvider.values[n2 + 2] + (replayFrameTransformationProvider2.values[n2 + 2] - replayFrameTransformationProvider.values[n2 + 2]) * d;
            this.tempRotation.x = replayFrameTransformationProvider.values[n2 + 3] + (replayFrameTransformationProvider2.values[n2 + 3] - replayFrameTransformationProvider.values[n2 + 3]) * d;
            this.tempRotation.y = replayFrameTransformationProvider.values[n2 + 4] + (replayFrameTransformationProvider2.values[n2 + 4] - replayFrameTransformationProvider.values[n2 + 4]) * d;
            this.tempRotation.z = replayFrameTransformationProvider.values[n2 + 5] + (replayFrameTransformationProvider2.values[n2 + 5] - replayFrameTransformationProvider.values[n2 + 5]) * d;
            this.tempRotation.w = replayFrameTransformationProvider.values[n2 + 6] + (replayFrameTransformationProvider2.values[n2 + 6] - replayFrameTransformationProvider.values[n2 + 6]) * d;
            this.tempScale.x = replayFrameTransformationProvider.values[n2 + 7] + (replayFrameTransformationProvider2.values[n2 + 7] - replayFrameTransformationProvider.values[n2 + 7]) * d;
            this.tempScale.y = replayFrameTransformationProvider.values[n2 + 8] + (replayFrameTransformationProvider2.values[n2 + 8] - replayFrameTransformationProvider.values[n2 + 8]) * d;
            this.tempScale.z = replayFrameTransformationProvider.values[n2 + 9] + (replayFrameTransformationProvider2.values[n2 + 9] - replayFrameTransformationProvider.values[n2 + 9]) * d;
            transformationCoupler.setLocalTranslation(this.tempTranslation);
            transformationCoupler.setLocalRotation(this.tempRotation);
            transformationCoupler.setLocalScale(this.tempScale);
            if (++n < this.numberOfProviders) continue;
            break;
        }
    }

    public IReplayFrame getSnapshot() {
        return new ReplayFrameTransformationProvider(this.providers).save(this.providers);
    }

    public void startRecording() {
        this.numberOfProviders = this.providers.size();
        super.startRecording();
    }

    public void startReplaying() {
        if (this.numberOfProviders != this.couplers.size()) {
            logger.warning("There are " + this.couplers.size() + " TransformationCouplers in the replay, but there were " + this.numberOfProviders + " TransformationProviders when the replay was recorded. It doesn't make sense");
        }
        super.startReplaying();
    }
}

