/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay;

import com.turborilla.replay.BaseReplay;
import com.turborilla.replay.IReplayFrame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class BaseReplayToFile
extends BaseReplay {
    private static final Logger logger = Logger.getLogger(BaseReplayToFile.class.getName());
    private String path;
    private String filename;
    private FileChannel file;
    private Exception couldNotRecordException = null;
    private boolean disabledDueToIOError = false;

    public abstract IReplayFrame loadFrameFromFileChannel(FileChannel var1) throws IOException;

    public abstract IReplayFrame getSnapshot();

    public abstract void applyFrames(double var1, IReplayFrame var3, IReplayFrame var4);

    public BaseReplayToFile(String string, String string2) {
        this.path = string;
        this.filename = string2;
    }

    protected void record(double d) {
        if (this.disabledDueToIOError) {
            return;
        }
        IReplayFrame iReplayFrame = this.getSnapshot();
        iReplayFrame.setTime(d);
        try {
            this.file.write(iReplayFrame.toByteBuffer());
        }
        catch (IOException iOException) {
            this.couldNotRecordException = iOException;
            this.disabledDueToIOError = true;
        }
    }

    public boolean replay(double d) {
        if (this.disabledDueToIOError) {
            return false;
        }
        return super.replay(d);
    }

    public void startRecording() {
        Object object;
        if (this.disabledDueToIOError) {
            return;
        }
        this.file = null;
        URL uRL = BaseReplayToFile.class.getClassLoader().getResource(this.path);
        File file = null;
        try {
            object = new File(uRL.toURI());
            file = new File((File)object, this.filename);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        if (file == null) {
            logger.warning("Could not create file: " + this.path + " " + this.filename);
        } else {
            try {
                file.createNewFile();
                object = new FileOutputStream(file, false);
                this.file = ((FileOutputStream)object).getChannel();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.warning("Can not record replay: " + fileNotFoundException);
                this.couldNotRecordException = fileNotFoundException;
            }
            catch (IOException iOException) {
                logger.warning("Can not create file \"" + file.toString() + "\": " + iOException);
                this.couldNotRecordException = iOException;
            }
        }
        if (this.file == null) {
            this.disabledDueToIOError = true;
        }
        super.startRecording();
    }

    public void startReplaying() {
        if (this.frames == null || this.frames.size() == 0) {
            this.loadFromFile();
        }
        if (this.disabledDueToIOError) {
            return;
        }
        super.startReplaying();
    }

    public void stopRecording() {
        try {
            this.file.force(true);
        }
        catch (IOException iOException) {
            this.couldNotRecordException = iOException;
            this.disabledDueToIOError = true;
        }
        super.stopRecording();
    }

    public void setFile(String string, String string2) {
        this.path = string;
        this.filename = string2;
    }

    public void loadFromFile() {
        Object object;
        this.file = null;
        URL uRL = BaseReplayToFile.class.getClassLoader().getResource(this.path);
        File file = null;
        try {
            object = new File(uRL.toURI());
            file = new File((File)object, this.filename);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        if (file == null) {
            logger.warning("Could not create file: " + this.path + " " + this.filename);
        } else {
            try {
                object = new FileInputStream(file);
                this.file = ((FileInputStream)object).getChannel();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.warning("Can not record replay: " + fileNotFoundException);
                this.couldNotRecordException = fileNotFoundException;
            }
        }
        if (this.file == null) {
            this.disabledDueToIOError = true;
        } else {
            if (this.frames != null) {
                this.frames.clear();
            } else {
                this.frames = new ArrayList();
            }
            do {
                object = null;
                try {
                    object = this.loadFrameFromFileChannel(this.file);
                }
                catch (IOException iOException) {
                    logger.warning("Error when loading replay from file: " + iOException);
                    this.couldNotRecordException = iOException;
                    this.disabledDueToIOError = true;
                }
                if (object == null) continue;
                this.frames.add(object);
            } while (object != null && !this.disabledDueToIOError);
        }
    }

    public boolean isDisabledDueToIOError(Exception exception) {
        exception = this.couldNotRecordException;
        return this.disabledDueToIOError;
    }
}

