/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.Particle;
import com.turborilla.replay.IReplayFrame;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayFrame
implements IReplayFrame {
    double time;
    double[] positions;

    public ReplayFrame(double d, Particle[] particleArray) {
        this.time = d;
        this.positions = new double[particleArray.length * 3];
    }

    public IReplayFrame save(Particle[] particleArray) {
        for (int i = 0; i < particleArray.length; ++i) {
            int n = i * 3;
            this.positions[n + 0] = particleArray[i].position.x;
            this.positions[n + 1] = particleArray[i].position.y;
            this.positions[n + 2] = particleArray[i].position.z;
        }
        return this;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return null;
    }

    public void applyFrame(ArrayList<Particle> arrayList) {
        this.applyFrame(arrayList.toArray(new Particle[0]), null);
    }

    public void applyFrame(ArrayList<Particle> arrayList, Vector3d vector3d) {
        this.applyFrame(arrayList.toArray(new Particle[0]), vector3d);
    }

    public void applyFrame(Particle[] particleArray, Vector3d vector3d) {
        double d;
        double d2;
        double d3;
        assert (particleArray.length <= this.positions.length * 3);
        if (vector3d == null) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        } else {
            d3 = vector3d.x;
            d2 = vector3d.y;
            d = vector3d.z;
        }
        for (int i = 0; i < particleArray.length; ++i) {
            int n = i * 3;
            particleArray[i].oldPosition.x = particleArray[i].position.x = this.positions[n + 0] + d3;
            particleArray[i].oldPosition.y = particleArray[i].position.y = this.positions[n + 1] + d2;
            particleArray[i].oldPosition.z = particleArray[i].position.z = this.positions[n + 2] + d;
        }
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public void setTime(double d) {
        this.time = d;
    }

    @Override
    public boolean fromFileChannel(FileChannel fileChannel) throws IOException {
        return false;
    }
}

