/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.physics.particle.ParticleSystem;
import com.turborilla.physics.particle.ReplayFrame;
import com.turborilla.replay.BaseReplay;
import com.turborilla.replay.IReplayFrame;
import com.turborilla.utils.math.Vector3d;
import java.util.logging.Logger;

public class Replay
extends BaseReplay {
    private static final Logger logger = Logger.getLogger(Replay.class.getName());
    private Particle[] particles;

    public void addParticleObject(ParticleObject particleObject) {
        if (this.isStarted()) {
            logger.warning("Cannot add ParticleObject while saving or replaying, create a new Replay");
            return;
        }
        if (this.particles == null) {
            this.particles = new Particle[particleObject.getParticles().size()];
            particleObject.getParticles().toArray(this.particles);
        } else {
            int n;
            Particle[] particleArray = new Particle[particleObject.getParticles().size()];
            particleObject.getParticles().toArray(particleArray);
            Particle[] particleArray2 = new Particle[this.particles.length + particleArray.length];
            for (n = 0; n < this.particles.length; ++n) {
                particleArray2[n] = this.particles[n];
            }
            for (n = 0; n < particleArray.length; ++n) {
                particleArray2[n + this.particles.length] = particleArray[n];
            }
            this.particles = particleArray2;
        }
    }

    public void addParticleSystem(ParticleSystem particleSystem) {
        for (ParticleObject particleObject : particleSystem.getParticleObjects()) {
            this.addParticleObject(particleObject);
        }
    }

    public IReplayFrame getSnapshot() {
        return new ReplayFrame(this.getCurrentTime(), this.particles).save(this.particles);
    }

    public void applyFrames(double d, IReplayFrame iReplayFrame, IReplayFrame iReplayFrame2) {
        ReplayFrame replayFrame = (ReplayFrame)iReplayFrame;
        ReplayFrame replayFrame2 = (ReplayFrame)iReplayFrame2;
        for (int i = 0; i < this.particles.length; ++i) {
            Vector3d vector3d = this.particles[i].position;
            int n = i * 3;
            vector3d.x = replayFrame.positions[n + 0] + (replayFrame2.positions[n + 0] - replayFrame.positions[n + 0]) * d;
            vector3d.y = replayFrame.positions[n + 1] + (replayFrame2.positions[n + 1] - replayFrame.positions[n + 1]) * d;
            vector3d.z = replayFrame.positions[n + 2] + (replayFrame2.positions[n + 2] - replayFrame.positions[n + 2]) * d;
        }
    }

    public void applyFrame(double d, Vector3d vector3d) {
        ReplayFrame replayFrame = null;
        for (IReplayFrame iReplayFrame : this.frames) {
            if (!(iReplayFrame.getTime() > d)) continue;
            replayFrame = (ReplayFrame)iReplayFrame;
            break;
        }
        this.applyFrame(replayFrame, vector3d);
    }

    public void applyFrame(ReplayFrame replayFrame, Vector3d vector3d) {
        replayFrame.applyFrame(this.particles, vector3d);
    }
}

