/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.jme.scene.Node;
import com.turborilla.TransformationProvider;
import com.turborilla.Updatable;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.physics.particle.Replay;
import com.turborilla.physics.particle.ReplayFrame;
import com.turborilla.replay.IReplay;
import com.turborilla.replay.IReplayFrame;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleSystem
implements Updatable {
    private static final Logger logger = Logger.getLogger(ParticleSystem.class.getName());
    private double maximumTimeStep;
    private Replay replay;
    private ReplayFrame initialState = null;
    double tempTpf = 0.0;
    private boolean noContraintSatisfactionThisFrame = false;
    private Vector3d massTempVec3d = new Vector3d();
    private Vector3d gravity;
    private double lockedZvalue;
    private ArrayList<ParticleObject> particleObjects = new ArrayList();
    protected boolean paused;
    private Node debugNode;
    private boolean shouldUpdateDebugNode;

    public ParticleSystem() {
        this.gravity = new Vector3d();
        this.gravity.set(0.0, -9.82, 0.0);
        this.maximumTimeStep = 0.001;
    }

    public void addParticleObject(ParticleObject particleObject) {
        this.particleObjects.add(particleObject);
        particleObject.setGravity(this.gravity);
    }

    public boolean removeParticleObject(ParticleObject particleObject) {
        return this.particleObjects.remove(particleObject);
    }

    public void removeAll() {
        Iterator<ParticleObject> iterator = this.particleObjects.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
    }

    @Override
    public void update(float f) {
        this.tempTpf += (double)f;
        if (this.paused) {
            return;
        }
        if (this.replay == null || !this.replay.isReplaying()) {
            ParticleObject particleObject;
            int n;
            for (n = 0; n < this.particleObjects.size(); ++n) {
                particleObject = this.particleObjects.get(n);
                if (particleObject.isPaused()) continue;
                particleObject.setAccelerationOnAllParticles(particleObject.gravity);
                particleObject.applyForces();
                particleObject.applyImpulses(this.tempTpf);
            }
            if (!this.noContraintSatisfactionThisFrame) {
                while (this.tempTpf > this.maximumTimeStep) {
                    for (n = 0; n < this.particleObjects.size(); ++n) {
                        particleObject = this.particleObjects.get(n);
                        if (particleObject.isPaused()) continue;
                        particleObject.integrate(this.maximumTimeStep);
                        particleObject.satisfyConstraints(this.maximumTimeStep);
                    }
                    this.tempTpf -= this.maximumTimeStep;
                }
            } else {
                this.noContraintSatisfactionThisFrame = false;
                while (this.tempTpf > this.maximumTimeStep) {
                    for (n = 0; n < this.particleObjects.size(); ++n) {
                        particleObject = this.particleObjects.get(n);
                        if (particleObject.isPaused()) continue;
                        particleObject.integrate(this.maximumTimeStep);
                    }
                    this.tempTpf -= this.maximumTimeStep;
                }
            }
            for (n = 0; n < this.particleObjects.size(); ++n) {
                particleObject = this.particleObjects.get(n);
                if (particleObject.isPaused()) continue;
                particleObject.updateCoordinateFrame();
            }
            if (this.replay != null) {
                this.replay.update(f);
            }
        } else {
            this.replay.update(f);
            for (int i = 0; i < this.particleObjects.size(); ++i) {
                this.particleObjects.get(i).updateCoordinateFrame();
            }
        }
        this.updateDebugNode();
    }

    public void startSavingReplay() {
        this.replay = new Replay();
        this.replay.addParticleSystem(this);
        this.replay.startRecording();
    }

    public void replay() {
        this.replay.startReplaying();
    }

    public IReplayFrame getSnapshot() {
        Replay replay;
        if (this.replay != null) {
            replay = this.replay;
        } else {
            replay = new Replay();
            replay.addParticleSystem(this);
        }
        return replay.getSnapshot();
    }

    public void applyReplayFrame(ReplayFrame replayFrame, Vector3d vector3d) {
        Replay replay;
        if (this.replay != null) {
            replay = this.replay;
        } else {
            replay = new Replay();
            replay.addParticleSystem(this);
        }
        replay.applyFrame(replayFrame, vector3d);
        this.noContraintSatisfactionThisFrame = true;
    }

    public void saveInitialState() {
        this.initialState = (ReplayFrame)this.getSnapshot();
    }

    public void resetToInitialState() {
        this.resetToInitialState(new Vector3d());
    }

    public void resetToInitialState(Vector3d vector3d) {
        if (this.initialState == null) {
            logger.severe("There is no initial state to revert to");
            return;
        }
        this.applyReplayFrame(this.initialState, vector3d);
    }

    public Vector3d getCenterOfMass(Vector3d vector3d) {
        Vector3d vector3d2 = vector3d != null ? vector3d.set(0.0, 0.0, 0.0) : new Vector3d();
        for (ParticleObject particleObject : this.particleObjects) {
            particleObject.getCenterOfMass(this.massTempVec3d).multLocal(particleObject.getMass());
            vector3d2.addLocal(this.massTempVec3d);
        }
        return vector3d2.multLocal(1.0 / this.getMass());
    }

    public double getMass() {
        double d = 0.0;
        for (ParticleObject particleObject : this.particleObjects) {
            d += particleObject.getMass();
        }
        return d;
    }

    public Vector3d getGravity() {
        return this.gravity;
    }

    public void setGravity(Vector3d vector3d) {
        this.gravity = vector3d;
        for (ParticleObject particleObject : this.particleObjects) {
            particleObject.setGravity(vector3d);
        }
    }

    public void setLockedZ(boolean bl) {
        for (ParticleObject particleObject : this.particleObjects) {
            particleObject.setLockedZ(bl);
        }
    }

    public void setLockedZvalue(double d) {
        for (ParticleObject particleObject : this.particleObjects) {
            particleObject.setLockedZvalue(d);
        }
        this.lockedZvalue = d;
    }

    public double getLockedZvalue() {
        return this.lockedZvalue;
    }

    public double getMaximumTimeStep() {
        return this.maximumTimeStep;
    }

    public void setMaximumTimeStep(double d) {
        this.maximumTimeStep = d;
    }

    public ArrayList<ParticleObject> getParticleObjects() {
        return this.particleObjects;
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public Node getDebugNode() {
        this.shouldUpdateDebugNode = true;
        this.updateDebugNode();
        return this.debugNode;
    }

    public void releaseDebugNode() {
        this.shouldUpdateDebugNode = false;
        this.debugNode = null;
    }

    public void updateDebugNode() {
        if (!this.shouldUpdateDebugNode) {
            return;
        }
        if (this.debugNode == null) {
            this.debugNode = new Node("debugNode");
            this.debugNode.setLightCombineMode(0);
            for (ParticleObject particleObject : this.particleObjects) {
                this.debugNode.attachChild(particleObject.getDebugNode());
            }
        } else {
            for (ParticleObject particleObject : this.particleObjects) {
                particleObject.updateDebugNode();
            }
        }
    }

    public IReplay getReplay() {
        return this.replay;
    }

    public void setReplay(Replay replay) {
        this.replay = replay;
    }

    public TransformationProvider getTransformationProvider(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.particleObjects.size(); ++i) {
            ParticleObject particleObject = this.particleObjects.get(i);
            if (string.equals(particleObject.getName())) {
                return particleObject;
            }
            for (int j = 0; j < particleObject.constraints.size(); ++j) {
                ConstraintStick constraintStick;
                IConstraint iConstraint = particleObject.constraints.get(j);
                if (!(iConstraint instanceof ConstraintStick) || !string.equals((constraintStick = (ConstraintStick)iConstraint).getName())) continue;
                return constraintStick;
            }
        }
        return null;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }
}

