/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.utils.math.Vector3d;

public class Particle {
    double invWeight;
    public Vector3d position = new Vector3d();
    public Vector3d oldPosition = new Vector3d();
    public Vector3d acceleration = new Vector3d();
    public boolean alive = true;
    protected static Vector3d tempVec = new Vector3d();

    public Particle() {
    }

    public Particle(Vector3d vector3d, Vector3d vector3d2, double d) {
        this.init(vector3d, vector3d2, d);
    }

    public Particle(Vector3d vector3d, double d) {
        this.init(vector3d, vector3d, d);
    }

    public void init(Vector3d vector3d, Vector3d vector3d2, double d) {
        this.position.set(vector3d);
        this.oldPosition.set(vector3d2);
        this.setWeight(d);
    }

    public void init(Vector3d vector3d, double d) {
        this.position.set(vector3d);
        this.oldPosition.set(vector3d);
        this.acceleration.set(0.0, 0.0, 0.0);
        this.setWeight(d);
    }

    public void applyForce(Vector3d vector3d) {
        tempVec.set(vector3d).multLocal(this.invWeight);
        this.acceleration.addLocal(tempVec);
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public double getWeight() {
        return 1.0 / this.invWeight;
    }

    public void setWeight(double d) {
        if (d < (double)0.001f) {
            System.out.println("Warning: setting particle weight to " + d);
        }
        this.invWeight = 1.0 / d;
    }

    public double getInvWeight() {
        return this.invWeight;
    }

    public void setInvWeight(double d) {
        this.invWeight = d;
    }

    public final Vector3d getOldPosition() {
        return this.oldPosition;
    }

    public final void setOldPosition(Vector3d vector3d) {
        this.oldPosition = vector3d;
    }

    public final void setPosition(Vector3d vector3d) {
        this.position = vector3d;
    }
}

