/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.IForce;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class ForceTorque
implements IForce {
    public Particle target;
    public ConstraintStick axis;
    public Particle center;
    protected double magnitude;
    protected Vector3d forceVector = new Vector3d();
    private static Vector3d radiusVector = new Vector3d();
    private static Vector3d tempVector = new Vector3d();
    boolean once = false;

    public void init(Particle particle, Particle particle2, ConstraintSpring constraintSpring, double d) {
        this.target = particle;
        this.center = particle2;
        this.axis = constraintSpring;
        this.magnitude = d;
    }

    public void apply() {
        radiusVector.set(this.center.position).subtractLocal(this.target.position);
        tempVector.set(this.axis.particles[0].position).subtractLocal(this.axis.particles[1].position);
        this.forceVector.set(radiusVector).crossLocal(tempVector);
        this.forceVector.normalizeLocal();
        this.forceVector.multLocal(this.magnitude);
        this.target.applyForce(this.forceVector);
    }

    public IConstraint getAxis() {
        return this.axis;
    }

    public void setAxis(ConstraintSpring constraintSpring) {
        this.axis = constraintSpring;
    }

    public Particle getCenter() {
        return this.center;
    }

    public void setCenter(Particle particle) {
        this.center = particle;
    }

    public Particle getTarget() {
        return this.target;
    }

    public void setTarget(Particle particle) {
        this.target = particle;
    }

    public Vector3d getForceVector() {
        return this.forceVector;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(double d) {
        this.magnitude = d;
    }

    public boolean once() {
        return this.once;
    }

    public void setOnce(boolean bl) {
        this.once = bl;
    }

    public Vector3d getDirection() {
        return this.forceVector;
    }
}

