/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class ConstraintSpringDamped
extends ConstraintSpring {
    protected double damping;
    protected static Vector3d v0 = new Vector3d();
    protected static Vector3d v1 = new Vector3d();
    protected static Vector3d relVel = new Vector3d();
    protected static Vector3d dampAxis = new Vector3d();

    public ConstraintSpringDamped() {
    }

    public ConstraintSpringDamped(Particle particle, Particle particle2) {
        super(particle, particle2);
    }

    public ConstraintSpringDamped(Particle particle, Particle particle2, double d) {
        super(particle, particle2);
        this.setDamping(d);
    }

    public void satisfy(double d) {
        if (this.active) {
            super.satisfy(d);
            v0.set(this.particles[0].position).subtractLocal(this.particles[0].oldPosition);
            v1.set(this.particles[1].position).subtractLocal(this.particles[1].oldPosition);
            dampAxis.set(this.particles[1].position).subtractLocal(this.particles[0].position);
            dampAxis.normalizeLocal();
            relVel.set(v1).subtractLocal(v0);
            relVel.set(dampAxis.multLocal(relVel.dot(dampAxis) * this.damping * d));
            if (relVel.lengthSquared() < 1.0000000000000001E-16) {
                return;
            }
            v0.set(relVel).multLocal(this.particles[0].invWeight);
            this.particles[0].position.addLocal(v0);
            this.particles[1].position.subtractLocal(relVel.multLocal(this.particles[1].invWeight));
        }
    }

    public double getDamping() {
        return this.damping;
    }

    public void setDamping(double d) {
        this.damping = d;
    }
}

