/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.Particle;

public class ConstraintSpring
extends ConstraintStick {
    protected double stiffness = 36.0;

    public ConstraintSpring() {
    }

    public ConstraintSpring(Particle particle, Particle particle2) {
        super(particle, particle2);
    }

    public ConstraintSpring(Particle particle, Particle particle2, double d) {
        super(particle, particle2);
        this.setStiffness(d);
    }

    public void satisfy(double d) {
        if (this.active) {
            scratch.set(this.particles[1].position).subtractLocal(this.particles[0].position);
            this.currentLength = scratch.length();
            if (this.currentLength < 1.0E-8) {
                return;
            }
            double d2 = (this.currentLength - this.restLength) / (this.currentLength * (this.particles[0].invWeight + this.particles[1].invWeight));
            d2 = d2 * this.stiffness * d;
            scratch2.set(scratch).multLocal(this.particles[0].invWeight * d2);
            this.particles[0].position.addLocal(scratch2);
            scratch.multLocal(-this.particles[1].invWeight * d2);
            this.particles[1].position.addLocal(scratch);
            this.checkStress();
        }
    }

    public void setStiffness(double d) {
        this.stiffness = d;
    }

    public double getStiffness() {
        return this.stiffness;
    }
}

