/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class ConstraintPlane
implements IConstraint {
    Vector3d point;
    Vector3d normal;
    Particle target;
    private static Vector3d tempVector = new Vector3d();
    private static Vector3d tempVector2 = new Vector3d();
    protected double stiffness = 10.0;
    boolean active = true;

    public ConstraintPlane(Particle particle, Vector3d vector3d, Vector3d vector3d2) {
        this.target = particle;
        this.point = vector3d;
        this.normal = vector3d2;
    }

    public void satisfy(double d) {
        if (this.active) {
            tempVector.set(this.point).subtractLocal(this.target.position);
            double d2 = this.normal.dot(tempVector) < 0.0 ? -1.0 : 1.0;
            tempVector2.set(this.normal).normalizeLocal();
            tempVector2.multLocal(d2);
            this.target.position.addLocal(tempVector2.mult(this.stiffness * d));
        }
    }

    public void setStiffness(double d) {
        this.stiffness = d;
    }

    public double getStiffness() {
        return this.stiffness;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }
}

