/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class ConstraintLine
implements IConstraint {
    private double stiffness = 100.0;
    private boolean active = true;
    private Particle[] part = new Particle[3];

    public ConstraintLine(Particle particle, Particle particle2, Particle particle3) {
        this.part[0] = particle;
        this.part[1] = particle2;
        this.part[2] = particle3;
    }

    public ConstraintLine(Particle particle, Particle particle2, Particle particle3, double d) {
        this(particle, particle2, particle3);
        this.setStiffness(d);
    }

    public String RTT() {
        return "ConstraintLine";
    }

    public boolean getActive() {
        return this.active;
    }

    public double getStiffness() {
        return this.stiffness;
    }

    public void satisfy(double d) {
        Object object;
        int n;
        if (!this.active) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d2 = this.part[0].position.distanceSquared(this.part[1].position);
        d3 = this.part[1].position.distanceSquared(this.part[2].position);
        d4 = this.part[2].position.distanceSquared(this.part[0].position);
        if (d4 > d3) {
            n = 1;
            if (d2 > d4) {
                n = 2;
            }
        } else {
            n = 0;
            if (d2 > d3) {
                n = 2;
            }
        }
        if (n != 1) {
            object = this.part[1];
            this.part[1] = this.part[n];
            this.part[n] = object;
        }
        object = this.part[1].position.add(this.part[0].position).multLocal(0.5);
        Vector3d vector3d = this.part[1].position.add(this.part[2].position).multLocal(0.5);
        double d5 = this.part[0].invWeight + this.part[1].invWeight + this.part[2].invWeight;
        for (int i = 0; i < 3; ++i) {
            Vector3d vector3d2 = this.part[i].position;
            Vector3d vector3d3 = this.closestPointOnLine((Vector3d)object, vector3d, vector3d2).subtractLocal(vector3d2);
            vector3d3.multLocal(this.stiffness * d);
            this.part[i].position.addLocal(vector3d3);
        }
    }

    private Vector3d closestPointOnLine(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Vector3d vector3d4 = vector3d2.subtract(vector3d);
        double d = vector3d3.subtract(vector3d).dot(vector3d4) / vector3d4.dot(vector3d4);
        return vector3d.add(vector3d4.mult(d), vector3d4);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setStiffness(double d) {
        this.stiffness = d;
    }
}

