/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class ConstraintDamper
implements IConstraint {
    Particle[] particles = new Particle[2];
    private static Vector3d v0 = new Vector3d();
    private static Vector3d v1 = new Vector3d();
    private static Vector3d relVel = new Vector3d();
    private static Vector3d dampAxis = new Vector3d();
    protected static final double ZERO = 1.0E-8;
    protected static final double ZERO2 = 1.0000000000000001E-16;
    protected double stiffness = 36.0;
    boolean active = true;

    public ConstraintDamper() {
    }

    public ConstraintDamper(Particle particle, Particle particle2) {
        this.init(particle, particle2);
    }

    public void satisfy(double d) {
        if (this.active) {
            v0.set(this.particles[0].position).subtractLocal(this.particles[0].oldPosition);
            v1.set(this.particles[1].position).subtractLocal(this.particles[1].oldPosition);
            dampAxis.set(this.particles[1].position).subtractLocal(this.particles[0].position);
            if (dampAxis.lengthSquared() > 1.0E-8) {
                dampAxis.normalizeLocal();
                relVel.set(v1).subtractLocal(v0);
                relVel.set(dampAxis.multLocal(relVel.dot(dampAxis) * this.stiffness * d));
                if (relVel.lengthSquared() < 1.0000000000000001E-16) {
                    return;
                }
                v0.set(relVel).multLocal(this.particles[0].invWeight);
                this.particles[0].position.addLocal(v0);
                this.particles[1].position.subtractLocal(relVel.multLocal(this.particles[1].invWeight));
            }
        }
    }

    public void init(Particle particle, Particle particle2) {
        this.particles[0] = particle;
        this.particles[1] = particle2;
    }

    public void setStiffness(double d) {
        this.stiffness = d;
    }

    public double getStiffness() {
        return this.stiffness;
    }

    public Particle[] getParticles() {
        return this.particles;
    }

    public void setParticles(Particle[] particleArray) {
        this.particles = particleArray;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }
}

