/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.track.challenges;

import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.rewards.listeners.IStatFinalizedListener;
import com.turborilla.msm.rewards.stats.StatWatcher;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.track.Track1D;
import com.turborilla.msm.track.challenges.IAchievedListener;
import com.turborilla.msm.track.challenges.IChallenge;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChallenge<E extends Comparable<E>>
implements IChallenge,
IStatFinalizedListener<E> {
    private static Logger logger = Logger.getLogger(AbstractChallenge.class.getCanonicalName());
    private ArrayList<IAchievedListener> listeners = new ArrayList();
    private boolean achieved = false;
    protected GameState gameState;
    protected Track1D track;
    protected BikeGameObject bike;
    protected String name;
    protected String description;
    private StatWatcher<E, Bike> challengeWatcher;
    private boolean deltWithCrash = false;

    protected abstract void initChallenge();

    @Override
    public void onFinalize(Comparable<E> comparable, Comparable<E> comparable2) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void addAchievedListener(IAchievedListener iAchievedListener) {
        this.listeners.add(iAchievedListener);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public final void init(GameState gameState, Track1D track1D, BikeGameObject bikeGameObject) {
        this.gameState = gameState;
        this.track = track1D;
        this.bike = bikeGameObject;
        this.initChallenge();
        if (this.getChallengeWatcher() != null) {
            this.getChallengeWatcher().reset();
            this.getChallengeWatcher().setFinalizedListener(this);
        }
    }

    @Override
    public void done() {
        if (this.getChallengeWatcher() != null) {
            this.getChallengeWatcher().forceApplyPendingChange();
            this.getChallengeWatcher().forceFinalize();
        }
    }

    @Override
    public void reset() {
        if (this.getChallengeWatcher() != null) {
            this.getChallengeWatcher().reset();
        }
    }

    @Override
    public void update(float f) {
        if (this.getChallengeWatcher() != null) {
            this.getChallengeWatcher().update(f);
        }
        if (this.bike.getBikeParticleSystem().isCrashing()) {
            if (!this.deltWithCrash) {
                this.onCrash();
                this.deltWithCrash = true;
            }
        } else {
            this.deltWithCrash = false;
        }
    }

    protected void onCrash() {
        if (this.getChallengeWatcher() != null) {
            this.getChallengeWatcher().undo();
        }
    }

    @Override
    public boolean isAchieved() {
        return this.achieved;
    }

    protected final void setAchieved() {
        if (!this.achieved) {
            this.achieved = true;
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        for (IAchievedListener iAchievedListener : this.listeners) {
            iAchievedListener.achievedChallenge(this);
        }
    }

    public final StatWatcher<E, Bike> getChallengeWatcher() {
        return this.challengeWatcher;
    }

    public final void setChallengeWatcher(StatWatcher<E, Bike> statWatcher) {
        this.challengeWatcher = statWatcher;
    }

    @Override
    public final int getFinalizedInterval() {
        return 0;
    }

    @Override
    public final String getRewardIdentifier() {
        return null;
    }

    @Override
    public final void setFinalizedInterval(int n) {
    }
}

