/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.track;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.Savable;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.track.Fence;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class RandomBannerFence
extends Fence {
    private static final Logger logger = Logger.getLogger(RandomBannerFence.class.getName());

    public RandomBannerFence(Vector3f vector3f, float f, float f2) throws IOException {
        super(vector3f, f, f2);
        this.randomizeBanners();
    }

    public void randomizeBanners() throws IOException {
        Savable savable;
        Properties properties = new Properties();
        properties.load(ResourceManager.findUrl("banners/banners.txt").openStream());
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        float f = 0.0f;
        for (Map.Entry<Object, Object> object : set) {
            URL uRL = ResourceManager.findUrl("banners/" + (String)object.getKey());
            if (uRL != null) {
                savable = (Texture)ResourceManager.getInstance().load("texture", uRL, null);
                if (savable != null) {
                    TextureEntry textureEntry = new TextureEntry();
                    Object object2 = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                    ((TextureState)object2).setTexture((Texture)savable);
                    textureEntry.ts = object2;
                    textureEntry.probability = Float.parseFloat((String)object.getValue());
                    f += textureEntry.probability;
                    arrayList.add(textureEntry);
                    continue;
                }
                logger.warning("Could not load banner: banners/" + (String)object.getKey());
                continue;
            }
            logger.warning("Could not load banner: banners/" + (String)object.getKey() + " url==null");
        }
        if (arrayList.size() > 0) {
            for (Spatial spatial : this.children) {
                float f2 = f * (float)Math.random();
                savable = ((TextureEntry)arrayList.get((int)0)).ts;
                for (Object object2 : arrayList) {
                    if (!((f2 -= ((TextureEntry)object2).probability) <= 0.0f)) continue;
                    savable = ((TextureEntry)object2).ts;
                    break;
                }
                spatial.setRenderState((RenderState)savable);
            }
        }
        this.updateRenderState();
    }

    private class TextureEntry {
        TextureState ts;
        float probability;

        private TextureEntry() {
        }
    }
}

