/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus.special;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.util.export.Savable;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.VerticalAlignment;
import com.turborilla.gui.VerticalLabelList;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;
import com.turborilla.msm.gui.turbogui.label.AlternatingLabel;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.rewards.CollectedReward;
import com.turborilla.msm.rewards.LabelAndStarsEntry;
import com.turborilla.msm.rewards.RewardDisplayer;
import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.msm.states.game.RaceResults;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.msm.utils.TimeFunctions;
import com.turborilla.sound.SFX;
import com.turborilla.utils.Font;
import com.turborilla.utils.Scheduling;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class RaceResultsPanel
extends BaseMenuPanel {
    private Label[] statLabels;
    private int numberOfNames = 2;
    private RaceResults raceResults;
    private Label titleLabel;
    private Label[] nameLabels;
    private AlternatingLabel[] timeLabels;
    private Texture starOnTexture;
    private Texture starOffTexture;
    private VerticalLabelList rewardLabelList;
    private Font rewardLabelFont;
    private String wonMessage = "WELL DONE!";
    private String lostMessage = "ALMOST! Try again...";
    private Scheduling schedule;
    private RowLayout buttonLayout;
    private ParticleFXGameObject fxGameObject;
    private SFX showSFX;
    private SFX showNewSFX;
    private Label[] posLabels;
    private ArrayList<BaseWidget> buttons = new ArrayList();
    private Runnable runOnActivate = null;

    public RaceResultsPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("RaceResults", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(0.8f, 2.5f);
        this.setLayout(variableRowLayout);
        this.schedule = new Scheduling();
        this.initGUI();
    }

    private void initGUI() {
        Label label = new Label("Results", "", 1.0f, 1.0f, "textfont", null);
        this.addWidget(label);
        this.getLayout().add(label);
        this.titleLabel = label;
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.0f, 0.73f, 0.22f, 0.15f);
        this.getLayout().add(variableRowLayout);
        ColumnLayout columnLayout = new ColumnLayout();
        variableRowLayout.add(columnLayout);
        this.nameLabels = new Label[this.numberOfNames];
        this.posLabels = new Label[this.nameLabels.length];
        this.timeLabels = new AlternatingLabel[this.nameLabels.length];
        for (int i = 0; i < this.nameLabels.length; ++i) {
            VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
            variableColumnLayout.setColumns(2.0f, 5.5f, 2.5f);
            columnLayout.add(variableColumnLayout);
            String string = null;
            if (i == 0) {
                string = "1st";
            }
            if (i == 1) {
                string = "2nD";
            }
            this.posLabels[i] = new Label("PosLabel" + i, string, 1.0f, 1.0f, "menufont", null);
            this.nameLabels[i] = new Label("Name" + i + "Label", "", 1.0f, 1.0f, "menufontover", null);
            this.timeLabels[i] = new AlternatingLabel("Time" + i + "Label", "", 1.0f, 1.0f, "menufontover", null);
            this.posLabels[i].setHorisontalAlignment(HorisontalAlignment.RIGHT);
            this.nameLabels[i].setHorisontalAlignment(HorisontalAlignment.LEFT);
            this.timeLabels[i].setHorisontalAlignment(HorisontalAlignment.LEFT);
            BaseLayout baseLayout = new BaseLayout();
            BaseLayout baseLayout2 = new BaseLayout();
            baseLayout.setPadding(0.1f, 0.5f);
            baseLayout2.setPadding(0.0f, 0.5f);
            this.addWidget(this.posLabels[i]);
            this.addWidget(this.nameLabels[i]);
            this.addWidget(this.timeLabels[i]);
            variableColumnLayout.add(this.posLabels[i]);
            baseLayout.add(this.nameLabels[i]);
            baseLayout2.add(this.timeLabels[i]);
            variableColumnLayout.add(baseLayout);
            variableColumnLayout.add(baseLayout2);
        }
        variableRowLayout.add(null);
        ColumnLayout columnLayout2 = new ColumnLayout();
        variableRowLayout.add(columnLayout2);
        columnLayout2.setPadding(0.0f, -0.15f);
        this.statLabels = new Label[2];
        for (int i = 0; i < this.statLabels.length; ++i) {
            this.statLabels[i] = new Label("Stat" + i + "Label", "", 1.0f, 1.0f, "textfont", null);
            this.addWidget(this.statLabels[i]);
            columnLayout2.add(this.statLabels[i]);
        }
        this.buttonLayout = new RowLayout();
        this.buttonLayout.setPadding(0.04f, 0.0f);
        variableRowLayout.add(this.buttonLayout);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.rewardLabelList = new VerticalLabelList(new Vector3f((float)displaySystem.getWidth() * -0.033f, (float)displaySystem.getHeight() * -0.31f, 0.0f), new Vector3f((float)displaySystem.getWidth() * -0.033f, (float)displaySystem.getHeight() * -0.01f, 0.0f));
        this.rewardLabelList.setNewLinesEnterPosition(new Vector3f((float)displaySystem.getWidth() * 0.4f, (float)displaySystem.getHeight() * 0.65f, 0.0f));
        this.rewardLabelList.setVerticalAlignment(VerticalAlignment.TOP);
        this.rewardLabelList.setMoveDamping(0.29f);
        this.getNode().attachChild(this.rewardLabelList.getNode());
        try {
            this.starOnTexture = (Texture)ResourceManager.getInstance().load("texture", "star_on", this.getLoaderProperties());
            this.starOffTexture = (Texture)ResourceManager.getInstance().load("texture", "star_off", this.getLoaderProperties());
        }
        catch (IOException iOException) {
            Logger.getLogger(RewardDisplayer.class.getCanonicalName()).severe("Could not load \"star\" texture.");
        }
        try {
            this.rewardLabelFont = (Font)ResourceManager.getInstance().load("font", "kimberley_italic_gradient", null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.fxGameObject = new ParticleFXGameObject("starFX", 10);
        try {
            this.fxGameObject.load("light_star");
            this.fxGameObject.setRepeat(false);
            this.fxGameObject.setOrtho();
        }
        catch (Exception exception) {
            this.fxGameObject = null;
        }
        if (this.fxGameObject != null && this.getGameObjectHandler() != null) {
            this.getGameObjectHandler().addGameObject(this.fxGameObject);
        }
        try {
            this.showSFX = (SFX)ResourceManager.getInstance().load("sfx", "show_reward", null);
            this.showNewSFX = (SFX)ResourceManager.getInstance().load("sfx", "show_new_reward", null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void makeButtons(String ... stringArray) {
        this.removeButtons();
        for (int i = 0; i < stringArray.length / 2; ++i) {
            MenuButton menuButton = new MenuButton(stringArray[i * 2], stringArray[i * 2 + 1], 200.0f, 50.0f, this.textSize);
            this.addWidget(menuButton);
            menuButton.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    RaceResultsPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
                }
            });
            this.buttonLayout.add(menuButton);
            this.buttons.add(menuButton);
        }
        this.buttonLayout.doLayout();
    }

    private void removeButtons() {
        Iterator<BaseWidget> iterator = this.buttons.iterator();
        while (iterator != null && iterator.hasNext()) {
            BaseWidget baseWidget = iterator.next();
            if (baseWidget == null) continue;
            this.removeWidget(baseWidget);
        }
        this.buttons.clear();
        this.buttonLayout.clear();
    }

    public void updateResults(RaceResults raceResults, boolean bl) {
        this.raceResults = raceResults;
        if (bl) {
            this.schedule.clearSchedule();
        }
        this.updateText(bl);
        if (bl) {
            this.updateRewards();
        }
    }

    private void updateRewards() {
        Savable savable;
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        if (this.raceResults == null) {
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            savable = new CollectedReward();
            ((CollectedReward)savable).rewardIdentifier = "Big Air";
            ((CollectedReward)savable).oldNumberOfStars = 2;
            ((CollectedReward)savable).newNumberOfStars = 3;
            arrayList2.add(savable);
            savable = new CollectedReward();
            ((CollectedReward)savable).rewardIdentifier = "Wheelie";
            ((CollectedReward)savable).oldNumberOfStars = 0;
            ((CollectedReward)savable).newNumberOfStars = 5;
            arrayList2.add(savable);
            savable = new CollectedReward();
            ((CollectedReward)savable).rewardIdentifier = "Stoppie";
            ((CollectedReward)savable).oldNumberOfStars = 2;
            ((CollectedReward)savable).newNumberOfStars = 4;
            arrayList2.add(savable);
            savable = new CollectedReward();
            ((CollectedReward)savable).rewardIdentifier = "backflip";
            ((CollectedReward)savable).oldNumberOfStars = 5;
            ((CollectedReward)savable).newNumberOfStars = 3;
            arrayList.add(savable);
            savable = new CollectedReward();
            ((CollectedReward)savable).rewardIdentifier = "frontflip";
            ((CollectedReward)savable).oldNumberOfStars = 3;
            ((CollectedReward)savable).newNumberOfStars = 3;
            arrayList.add(savable);
            savable = new CollectedReward();
            ((CollectedReward)savable).rewardIdentifier = "double backflip";
            ((CollectedReward)savable).oldNumberOfStars = 1;
            ((CollectedReward)savable).newNumberOfStars = 1;
            arrayList.add(savable);
            savable = new CollectedReward();
            ((CollectedReward)savable).rewardIdentifier = "double frontflip";
            ((CollectedReward)savable).oldNumberOfStars = 4;
            ((CollectedReward)savable).newNumberOfStars = 2;
            arrayList.add(savable);
            this.statLabels[0].setText("This is label 1 This is label 1 This is label 1 This is label 1 ");
            this.statLabels[1].setText("You passed the starting line 2 seconds after green light");
        } else {
            savable = this.findPlayer(this.raceResults);
            if (savable == null) {
                return;
            }
            arrayList2 = savable.getImprovedRewards();
            arrayList = savable.getNotImprovedRewards();
            if (arrayList2 == null && arrayList == null) {
                return;
            }
        }
        this.rewardLabelList.clear();
        float f = 0.5f;
        for (int i = 0; i < 2; ++i) {
            ArrayList<Object> arrayList3 = null;
            arrayList3 = i == 0 ? arrayList : arrayList2;
            if (arrayList3 == null) continue;
            for (int j = 0; j < arrayList3.size(); ++j) {
                int n;
                final CollectedReward collectedReward = (CollectedReward)arrayList3.get(j);
                boolean bl = collectedReward.newNumberOfStars > collectedReward.oldNumberOfStars;
                int n2 = n = bl ? collectedReward.oldNumberOfStars : collectedReward.newNumberOfStars;
                if (!bl) {
                    this.schedule.add(new Runnable(){

                        public void run() {
                            LabelAndStarsEntry labelAndStarsEntry = LabelAndStarsEntry.getOrCreateLabel(collectedReward.rewardIdentifier, collectedReward.rewardIdentifier, RaceResultsPanel.this.rewardLabelList, RaceResultsPanel.this.rewardLabelFont, RaceResultsPanel.this.starOnTexture, RaceResultsPanel.this.starOffTexture);
                            labelAndStarsEntry.getStars().setNumberOfLit(n);
                            RaceResultsPanel.this.showSFX.play();
                        }
                    }, f);
                    f += 1.0f;
                    continue;
                }
                this.schedule.add(new Runnable(){

                    public void run() {
                        final LabelAndStarsEntry labelAndStarsEntry = LabelAndStarsEntry.getOrCreateLabel(collectedReward.rewardIdentifier, collectedReward.rewardIdentifier, RaceResultsPanel.this.rewardLabelList, RaceResultsPanel.this.rewardLabelFont, RaceResultsPanel.this.starOnTexture, RaceResultsPanel.this.starOffTexture);
                        labelAndStarsEntry.getStars().setNumberOfLit(n);
                        RaceResultsPanel.this.showSFX.play();
                        for (int i = 0; i < collectedReward.newNumberOfStars - collectedReward.oldNumberOfStars; ++i) {
                            final int n2 = n + (i + 1);
                            RaceResultsPanel.this.schedule.add(new Runnable(){

                                public void run() {
                                    int[] nArray = labelAndStarsEntry.getStars().setNumberOfLit(n2, RaceResultsPanel.this.fxGameObject);
                                    for (int i = 0; i < nArray.length; ++i) {
                                        int n = nArray[i];
                                        if (n < 0) continue;
                                        Node node = RaceResultsPanel.this.fxGameObject.getNode(n);
                                        node.setLocalScale(new Vector3f(45.0f, 45.0f, 0.1f));
                                    }
                                    RaceResultsPanel.this.showNewSFX.play();
                                }
                            }, 0.2f * (float)(i + 3));
                        }
                    }
                }, f);
                f += 1.0f;
            }
        }
    }

    private void updateText(boolean bl) {
        ProgressData.Division[] divisionArray;
        int n;
        int n2;
        if (this.raceResults == null) {
            return;
        }
        BikeResult[] bikeResultArray = this.raceResults.getInOrderOfFinish();
        boolean bl2 = false;
        Profile profile = null;
        for (n2 = 0; n2 < this.numberOfNames; ++n2) {
            if (n2 >= bikeResultArray.length) {
                this.nameLabels[n2].setText("");
                this.posLabels[n2].setText("");
                this.timeLabels[n2].setText("");
                continue;
            }
            BikeResult bikeResult = bikeResultArray[n2];
            if (bikeResult == null) continue;
            n = 0;
            divisionArray = "Computer";
            if (bikeResult.getProfile() != null) {
                divisionArray = bikeResult.getProfile().getName();
                n = 1;
                profile = bikeResult.getProfile();
                if (n2 == 0) {
                    bl2 = this.raceResults.isChallengesAchieved();
                }
            }
            String string = null;
            if (n2 == 0) {
                string = "1st";
            }
            if (n2 == 1) {
                string = "2nD";
            }
            this.posLabels[n2].setText(string);
            this.nameLabels[n2].setText((String)divisionArray);
            if (bikeResult.hasFinishedRace()) {
                if (bikeResult.isPersonalBest()) {
                    this.timeLabels[n2].setText(TimeFunctions.getMinSecHundredths(bikeResult.getPassedFinishlineAtTime()), "New record", "-" + TimeFunctions.getMinSecHundredths(bikeResult.getShavedTime()));
                } else {
                    this.timeLabels[n2].setText(TimeFunctions.getMinSecHundredths(bikeResult.getPassedFinishlineAtTime()));
                }
            } else {
                this.timeLabels[n2].setText("Still racing");
            }
            if (n == 0) continue;
            String string2 = null;
            string2 = bikeResult.getNumberOfCrashes() <= 0 ? "You did not crash even once!" : (bikeResult.getNumberOfCrashes() == 1 ? "You crashed only once" : (bikeResult.getNumberOfCrashes() == 2 ? "You crashed twice" : "You crashed " + bikeResult.getNumberOfCrashes() + " times"));
            this.statLabels[0].setText(string2);
            this.statLabels[1].setText("You passed the starting line " + TimeFunctions.getSecHundreths(bikeResult.getPassedStartlineAtTime()) + " seconds after green light");
        }
        if (bl2) {
            this.titleLabel.setText(this.wonMessage);
        } else {
            this.titleLabel.setText(this.lostMessage);
        }
        n2 = 0;
        if (profile != null) {
            int n3 = this.raceResults.getDivisionIndex();
            n = this.raceResults.getTrackIndex() + 1;
            if (n >= (divisionArray = profile.getData().getProgressData().getDivisions())[n3].getTracks().length) {
                n = 0;
                ++n3;
            }
            if (n3 < divisionArray.length) {
                n2 = divisionArray[n3].getTracks()[n].isUnlocked() ? 1 : 0;
            }
        }
        if (bl) {
            if (bl2) {
                this.makeButtons("replayButton", "Watch replay", "retryButton", "Race again", "continueButton", "Continue");
                this.runOnActivate = new Runnable(){

                    public void run() {
                        RaceResultsPanel.this.getGuiHandler().focusWidget(RaceResultsPanel.this.getGuiHandler().getWidget("continueButton"));
                    }
                };
            } else {
                this.makeButtons("replayButton", "Watch replay", "retryButton", "Try again", "continueButton", "Continue");
                this.runOnActivate = new Runnable(){

                    public void run() {
                        RaceResultsPanel.this.getGuiHandler().focusWidget(RaceResultsPanel.this.getGuiHandler().getWidget("retryButton"));
                    }
                };
            }
        }
    }

    private BikeResult findPlayer(RaceResults raceResults) {
        BikeResult[] bikeResultArray;
        BikeResult bikeResult = null;
        for (BikeResult bikeResult2 : bikeResultArray = raceResults.getInOrderOfFinish()) {
            if (!bikeResult2.getBike().isPlayer()) continue;
            bikeResult = bikeResult2;
            break;
        }
        return bikeResult;
    }

    public void onActivate() {
        super.onActivate();
        if (this.runOnActivate != null) {
            this.runOnActivate.run();
        }
    }

    public void onDeactivate() {
        super.onDeactivate();
        this.schedule.clearSchedule();
    }

    public void updateGeometricState(float f, boolean bl) {
        this.schedule.update(f);
        super.updateGeometricState(f, bl);
    }
}

