/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus.special;

import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.IResizableWidget;

public class QuarterCircleLayout
extends BaseLayout {
    private Quarter quarter = Quarter.Northwest;
    private boolean reverse = false;
    private static Vector2f circleCenter = new Vector2f();

    public QuarterCircleLayout() {
    }

    public QuarterCircleLayout(Quarter quarter) {
        this.quarter = quarter;
    }

    public QuarterCircleLayout(Quarter quarter, boolean bl) {
        this.quarter = quarter;
        this.reverse = bl;
    }

    public QuarterCircleLayout(float f, float f2) {
        super(f, f2);
    }

    public QuarterCircleLayout(Vector2f vector2f, float f, float f2, float f3) {
        super(vector2f, f, f2, f3);
    }

    public void doLayout() {
        float f = FastMath.sqrt(FastMath.sqr(this.width - FastMath.cos(1.5707964f / (float)(this.widgets.size() - 1)) * this.width) + FastMath.sqr(FastMath.sin(1.5707964f / (float)(this.widgets.size() - 1)) * this.height));
        float f2 = this.width - f * 0.5f + f * this.xPadding;
        float f3 = this.height - f * 0.5f + f * this.yPadding;
        this.quarter.setCircleCenter(circleCenter, this.position, f2, f3);
        for (int i = 0; i < this.widgets.size(); ++i) {
            IResizableWidget iResizableWidget = (IResizableWidget)this.widgets.get(i);
            float f4 = this.isReverse() ? (float)i / (float)(this.widgets.size() - 1) : (float)(this.widgets.size() - 1 - i) / (float)(this.widgets.size() - 1);
            f4 *= 1.5707964f;
            if (iResizableWidget == null) continue;
            this.quarter.getPosition(circleCenter, f4, f2, f3, tempVec);
            iResizableWidget.setPosition(tempVec);
            iResizableWidget.setSize(f - f * this.xPadding, f - f * this.yPadding);
        }
    }

    public Quarter getQuarter() {
        return this.quarter;
    }

    public void setQuarter(Quarter quarter) {
        this.quarter = quarter;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quarter {
        Northwest{

            public void setCircleCenter(Vector2f vector2f, Vector2f vector2f2, float f, float f2) {
                vector2f.set(vector2f2.x + 0.5f * f, vector2f2.y - 0.5f * f2);
            }

            public void getPosition(Vector2f vector2f, float f, float f2, float f3, Vector2f vector2f2) {
                vector2f2.x = -FastMath.sin(f) * f2 + vector2f.x;
                vector2f2.y = FastMath.cos(f) * f3 + vector2f.y;
            }
        }
        ,
        Northeast{

            public void setCircleCenter(Vector2f vector2f, Vector2f vector2f2, float f, float f2) {
                vector2f.set(vector2f2.x - 0.5f * f, vector2f2.y - 0.5f * f2);
            }

            public void getPosition(Vector2f vector2f, float f, float f2, float f3, Vector2f vector2f2) {
                vector2f2.x = FastMath.cos(f) * f2 + vector2f.x;
                vector2f2.y = FastMath.sin(f) * f3 + vector2f.y;
            }
        }
        ,
        Southeast{

            public void setCircleCenter(Vector2f vector2f, Vector2f vector2f2, float f, float f2) {
                vector2f.set(vector2f2.x - 0.5f * f, vector2f2.y + 0.5f * f2);
            }

            public void getPosition(Vector2f vector2f, float f, float f2, float f3, Vector2f vector2f2) {
                vector2f2.x = FastMath.cos(f) * f2 + vector2f.x;
                vector2f2.y = -FastMath.sin(f) * f3 + vector2f.y;
            }
        }
        ,
        Southwest{

            public void setCircleCenter(Vector2f vector2f, Vector2f vector2f2, float f, float f2) {
                vector2f.set(vector2f2.x + 0.5f * f, vector2f2.y + 0.5f * f2);
            }

            public void getPosition(Vector2f vector2f, float f, float f2, float f3, Vector2f vector2f2) {
                vector2f2.x = -FastMath.sin(f) * f2 + vector2f.x;
                vector2f2.y = -FastMath.cos(f) * f3 + vector2f.y;
            }
        };


        public abstract void setCircleCenter(Vector2f var1, Vector2f var2, float var3, float var4);

        public abstract void getPosition(Vector2f var1, float var2, float var3, float var4, Vector2f var5);
    }
}

