/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus.special;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.gui.turbogui.Rectangle;
import com.turborilla.msm.gui.turbogui.ScrollableColumnLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollBar;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProfileData;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.profile.RaceData;
import com.turborilla.msm.profile.RewardData;
import com.turborilla.msm.statemachine.MsmStateMachineException;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.msm.utils.TimeFunctions;
import com.turborilla.utils.Font;
import java.io.IOException;
import java.util.ArrayList;

public class ProfileStatsPanel
extends BaseMenuPanel {
    private Label nameLabel;
    private ScrollableColumnLayout scrollLayout;
    private ArrayList<BaseWidget> widgetsToClear = new ArrayList();
    private Font font;

    public ProfileStatsPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("ProfileStats", f, f2, guiHandler, gameSettings);
        try {
            this.font = (Font)ResourceManager.getInstance().load("font", "kimberley_italic_gradient", null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VariableRowLayout variableRowLayout = new VariableRowLayout(f, f2);
        variableRowLayout.setRows(0.5f, 2.5f, 0.5f);
        this.setLayout(variableRowLayout);
        this.initGUI(guiHandler);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI(GuiHandler guiHandler) {
        this.nameLabel = new Label("nameLabel", "", 1.0f, 1.0f, "textfont", null);
        this.addWidget(this.nameLabel);
        this.getLayout().add(this.nameLabel);
        BaseLayout baseLayout = new BaseLayout();
        this.getLayout().add(baseLayout);
        Rectangle rectangle = new Rectangle("", 1.0f, 1.0f);
        rectangle.getFader().initRenderStates();
        rectangle.getFader().setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.35f));
        baseLayout.add(rectangle);
        this.addWidget(rectangle);
        ScrollBar scrollBar = new ScrollBar("scrollBar", "scrollbar_yellow");
        this.scrollLayout = new ScrollableColumnLayout(10);
        this.scrollLayout.setScrollBar(scrollBar);
        baseLayout.add(this.scrollLayout);
        this.addWidget(this.scrollLayout.getScrollBar());
        BaseLayout baseLayout2 = new BaseLayout();
        this.getLayout().add(baseLayout2);
        baseLayout2.setPadding(0.7f, 0.2f);
        MenuButton menuButton = new MenuButton("backToMainMenuButton", "Back", 1.0f, 1.0f);
        this.addWidget(menuButton);
        baseLayout2.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ProfileStatsPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
            }
        });
    }

    private void fillStats() {
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        this.nameLabel.setText(profile.getName());
        for (BaseWidget baseWidget : this.widgetsToClear) {
            this.removeWidget(baseWidget);
        }
        this.scrollLayout.clear();
        int n = Boolean.parseBoolean(this.getSettings().get("simulationModeAvailable", "true")) ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            Difficulty difficulty = i == 0 ? Difficulty.Arcade : Difficulty.Simulation;
            Label label = new Label("", difficulty.getName(), 1.0f, 1.0f, "menufont", null);
            this.addWidget(label);
            this.scrollLayout.add(label);
            this.widgetsToClear.add(label);
            label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
            ProfileData profileData = profile.getData(difficulty);
            this.makeRewardLabels(profileData);
            this.makeTrackLabels(difficulty, profileData);
        }
        this.getLayout().doLayout();
    }

    private void makeTrackLabels(Difficulty difficulty, ProfileData profileData) {
        ProgressData progressData = profileData.getProgressData();
        ProgressData.Division[] divisionArray = progressData.getDivisions();
        DivisionDescriptor divisionDescriptor = this.getDivisionDescriptor(difficulty);
        for (ProgressData.Division division : divisionArray) {
            ProgressData.Division.Track[] trackArray = division.getTracks();
            int n = division.getIndex();
            BaseLayout baseLayout = new BaseLayout();
            this.scrollLayout.add(baseLayout);
            baseLayout.setPadding(0.0f, -1.0f);
            Image image = new Image("", divisionDescriptor.getImage(n), 1.0f, true);
            this.addWidget(image);
            baseLayout.add(image);
            this.widgetsToClear.add(image);
            for (ProgressData.Division.Track track : trackArray) {
                Object object;
                BaseLayout baseLayout2 = new BaseLayout();
                BaseLayout baseLayout3 = new BaseLayout();
                BaseLayout baseLayout4 = new BaseLayout();
                BaseLayout baseLayout5 = new BaseLayout();
                VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
                variableColumnLayout.setColumns(5.0f, 1.0f, 2.0f, 3.0f);
                variableColumnLayout.add(baseLayout2);
                variableColumnLayout.add(baseLayout5);
                variableColumnLayout.add(baseLayout3);
                variableColumnLayout.add(baseLayout4);
                this.scrollLayout.add(variableColumnLayout);
                int n2 = track.getIndex();
                Label label = new Label("", divisionDescriptor.getTrack(n, n2), this.font, 1.0f, 1.0f);
                this.addWidget(label);
                baseLayout2.add(label);
                this.widgetsToClear.add(label);
                label.setHorisontalAlignment(HorisontalAlignment.RIGHT);
                if (track.isAccomplished()) {
                    object = new Image("", "checkbuttonchecked", 1.0f, true);
                    this.addWidget((BaseWidget)object);
                    baseLayout5.add((IResizableWidget)object);
                    this.widgetsToClear.add((BaseWidget)object);
                }
                object = profileData.getRaces(n, n2);
                String string = null;
                string = object != null && ((RaceData[])object).length > 0 ? TimeFunctions.getMinSecHundredths(object[0].getPassedFinishlineAtTime()) : "N/A";
                label = new Label("", string, this.font, 1.0f, 1.0f);
                this.addWidget(label);
                baseLayout3.add(label);
                this.widgetsToClear.add(label);
                label.setHorisontalAlignment(HorisontalAlignment.LEFT);
            }
        }
    }

    private void makeRewardLabels(ProfileData profileData) {
        Image image;
        int n;
        Label label;
        BaseLayout baseLayout;
        BaseLayout baseLayout2;
        BaseLayout baseLayout3;
        BaseLayout baseLayout4;
        BaseLayout baseLayout5;
        String[] stringArray;
        RewardData rewardData = profileData.getRewardData();
        for (String object2 : stringArray = rewardData.getAvailableRewardsIdentifiers()) {
            Image n2;
            int variableRowLayout;
            baseLayout5 = new VariableColumnLayout();
            ((VariableColumnLayout)baseLayout5).setColumns(5.0f, 1.0f, 5.0f);
            baseLayout4 = new BaseLayout();
            baseLayout3 = new RowLayout();
            baseLayout2 = new VariableColumnLayout();
            ((VariableColumnLayout)baseLayout2).setColumns(2.0f, 1.0f);
            baseLayout2.add(baseLayout3);
            baseLayout = new VariableRowLayout();
            ((VariableRowLayout)baseLayout).setRows(3.4f, 1.0f);
            baseLayout.add(baseLayout2);
            baseLayout5.add(baseLayout4);
            baseLayout5.add(null);
            baseLayout5.add(baseLayout);
            this.scrollLayout.add(baseLayout5);
            label = new Label("", object2, this.font, 1.0f, 1.0f);
            this.addWidget(label);
            baseLayout4.add(label);
            this.widgetsToClear.add(label);
            label.setHorisontalAlignment(HorisontalAlignment.RIGHT);
            int variableColumnLayout2 = rewardData.getNumberOfStars(object2);
            for (variableRowLayout = 0; variableRowLayout < variableColumnLayout2; ++variableRowLayout) {
                n2 = new Image("", "star_on", 1.0f, true);
                this.addWidget(n2);
                baseLayout3.add(n2);
                this.widgetsToClear.add(n2);
            }
            for (variableRowLayout = variableColumnLayout2; variableRowLayout < 5; ++variableRowLayout) {
                n2 = new Image("", "star_off", 1.0f, true);
                this.addWidget(n2);
                baseLayout3.add(n2);
                this.widgetsToClear.add(n2);
            }
        }
        int n4 = rewardData.getMostStarsInOneRace();
        int n5 = 15;
        VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
        variableColumnLayout.setColumns(5.0f, 1.0f, 5.0f);
        BaseLayout baseLayout6 = new BaseLayout();
        this.scrollLayout.add(variableColumnLayout);
        baseLayout5 = new ColumnLayout();
        baseLayout4 = new RowLayout();
        baseLayout4.setPadding(-0.2f, -0.2f);
        baseLayout3 = new VariableColumnLayout();
        ((VariableColumnLayout)baseLayout3).setColumns(3.0f, 1.0f);
        baseLayout3.add(baseLayout4);
        baseLayout2 = new VariableRowLayout();
        ((VariableRowLayout)baseLayout2).setRows(3.4f, 1.0f);
        baseLayout2.add(baseLayout3);
        baseLayout = new RowLayout();
        baseLayout.setPadding(-0.2f, -0.2f);
        VariableColumnLayout variableColumnLayout2 = new VariableColumnLayout();
        variableColumnLayout2.setColumns(3.0f, 1.0f);
        variableColumnLayout2.add(baseLayout);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(3.4f, 1.0f);
        variableRowLayout.add(variableColumnLayout2);
        baseLayout5.add(baseLayout2);
        baseLayout5.add(variableRowLayout);
        variableColumnLayout.add(baseLayout6);
        variableColumnLayout.add(null);
        variableColumnLayout.add(baseLayout5);
        label = new Label("", "Most in one race", this.font, 1.0f, 1.0f);
        this.addWidget(label);
        baseLayout6.add(label);
        this.widgetsToClear.add(label);
        label.setHorisontalAlignment(HorisontalAlignment.RIGHT);
        for (n = 0; n < n5 && n < n4; ++n) {
            image = new Image("", "star_on", 1.0f, true);
            this.addWidget(image);
            baseLayout4.add(image);
            this.widgetsToClear.add(image);
        }
        for (n = n4; n < n5; ++n) {
            image = new Image("", "star_off", 1.0f, true);
            this.addWidget(image);
            baseLayout4.add(image);
            this.widgetsToClear.add(image);
        }
        for (n = n5; n < n4; ++n) {
            image = new Image("", "star_on", 1.0f, true);
            this.addWidget(image);
            baseLayout.add(image);
            this.widgetsToClear.add(image);
        }
        for (n = Math.max(n4, n5); n < n5 * 2; ++n) {
            image = new Image("", "star_off", 1.0f, true);
            this.addWidget(image);
            baseLayout.add(image);
            this.widgetsToClear.add(image);
        }
    }

    public void onActivate() {
        super.onActivate();
        this.fillStats();
    }

    private DivisionDescriptor getDivisionDescriptor(Difficulty difficulty) {
        DivisionDescriptor divisionDescriptor = null;
        String string = null;
        string = difficulty == Difficulty.Arcade ? "arcade_divisions" : "simulation_divisions";
        try {
            divisionDescriptor = (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", string, null);
        }
        catch (IOException iOException) {
            throw new MsmStateMachineException(iOException);
        }
        return divisionDescriptor;
    }
}

