/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus.special;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.msm.states.menus.special.QuarterCircleLayout;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseDivisionPanel
extends BaseMenuPanel {
    private ILayout divisionsLayout;
    private ArrayList<BaseWidget> widgetsToRemove = new ArrayList();
    private DivisionButton[] divisionButtons;
    private ArrayList<Integer> divisionsToAccomplish;
    private ArrayList<Integer> divisionsToUnlock;
    private boolean alwaysUnlocked = false;
    private int chosenDivisionIndex;
    private DivisionDescriptor divisionDescriptor;
    private Profile profile;
    private float effectTime = 0.5f;
    private IChosenDivisionListener chosenDivisionListener;

    public ChooseDivisionPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("ChooseDivision", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.0f);
        this.setLayout(variableRowLayout);
        this.initGUI();
    }

    private void initGUI() {
        this.divisionsLayout = new QuarterCircleLayout(QuarterCircleLayout.Quarter.Southwest, false);
        this.divisionsLayout.setPadding(0.08f, 0.08f);
        this.getLayout().add(this.divisionsLayout);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    public void buildDivisionButtons(int n, DivisionDescriptor divisionDescriptor, Profile profile, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        this.divisionsToAccomplish = (ArrayList)arrayList.clone();
        this.divisionsToUnlock = (ArrayList)arrayList2.clone();
        if (this.divisionDescriptor == null) {
            for (int i = 0; i < this.widgetsToRemove.size(); ++i) {
                this.removeWidget(this.widgetsToRemove.get(i));
            }
            this.widgetsToRemove.clear();
            if (this.divisionsLayout != null) {
                this.divisionsLayout.clear();
            }
            if (n >= 0) {
                this.chosenDivisionIndex = n;
            }
            this.divisionDescriptor = divisionDescriptor;
            this.profile = profile;
            this.buildDivisionButtonsNow(n, divisionDescriptor, profile, arrayList, arrayList2);
        }
    }

    private void buildDivisionButtonsNow(int n, DivisionDescriptor divisionDescriptor, Profile profile, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        ProgressData.Division[] divisionArray = profile.getData().getProgressData().getDivisions();
        this.divisionButtons = new DivisionButton[divisionArray.length];
        for (int i = 0; i < divisionArray.length; ++i) {
            VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
            variableColumnLayout.setColumns(5.0f);
            this.divisionsLayout.add(variableColumnLayout);
            DivisionButton divisionButton = new DivisionButton(divisionDescriptor.getImage(i), i);
            this.addWidget(divisionButton);
            this.widgetsToRemove.add(divisionButton);
            variableColumnLayout.add(divisionButton);
            this.divisionButtons[i] = divisionButton;
        }
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    @Override
    public void onActivate() {
        super.onActivate();
        if (this.divisionButtons == null) {
            return;
        }
        DivisionButton divisionButton = null;
        this.profile = Profile.getCurrentProfile(this.getSettings());
        ProgressData.Division[] divisionArray = this.profile.getData().getProgressData().getDivisions();
        for (int i = 0; i < divisionArray.length; ++i) {
            DivisionButton divisionButton2 = this.divisionButtons[i];
            if (i == this.chosenDivisionIndex) {
                divisionButton = divisionButton2;
            }
            if (!this.alwaysUnlocked && (!divisionArray[i].isUnlocked() || this.divisionsToUnlock != null && this.divisionsToUnlock.contains(i))) {
                divisionButton2.setEnabled(false);
                continue;
            }
            divisionButton2.setEnabled(true);
            if (this.chosenDivisionIndex >= 0) continue;
            divisionButton = divisionButton2;
        }
        this.getGuiHandler().focusWidget(divisionButton);
    }

    public void startEffects(IControllerListener iControllerListener) {
        final IControllerListener iControllerListener2 = iControllerListener;
        if (this.divisionsToUnlock != null && this.divisionButtons != null && this.divisionsToUnlock.size() > 0) {
            for (int i = 0; i < this.divisionsToUnlock.size(); ++i) {
                int n = this.divisionsToUnlock.get(i);
                if (n >= this.divisionButtons.length) continue;
                final DivisionButton divisionButton = this.divisionButtons[n];
                divisionButton.getScaler().scaleTo(new Vector3f(0.5f, 0.5f, 1.0f), this.effectTime, this.effectTime * 0.7f);
                divisionButton.getScaler().add(new IControllerListener(){

                    public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                        divisionButton.setEnabled(true);
                        ChooseDivisionPanel.this.getGuiHandler().focusWidget(divisionButton);
                        divisionButton.getScaler().scaleTo(new Vector3f(1.0f, 1.0f, 1.0f), ChooseDivisionPanel.this.effectTime, ChooseDivisionPanel.this.effectTime * 0.6f);
                        if (iControllerListener2 != null) {
                            divisionButton.getScaler().add(iControllerListener2);
                        }
                    }
                });
            }
        } else if (iControllerListener2 != null) {
            iControllerListener2.controllerTaskFinished(null);
        }
        this.divisionsToUnlock = null;
        this.divisionsToAccomplish = null;
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
    }

    private void chosenDivision(int n) {
        this.setChosenDivisionIndex(n);
        if (this.chosenDivisionListener != null) {
            this.chosenDivisionListener.chosenDivision(n);
        }
        this.getEventManager().fireEvent("PreviousMenu");
    }

    public void setChosenDivisionListener(IChosenDivisionListener iChosenDivisionListener) {
        this.chosenDivisionListener = iChosenDivisionListener;
    }

    private void setChosenDivisionIndex(int n) {
        this.chosenDivisionIndex = n;
    }

    public MenuButton getDivisionButton(int n) {
        if (this.divisionButtons == null || n >= this.divisionButtons.length) {
            return null;
        }
        return this.divisionButtons[n];
    }

    public static interface IChosenDivisionListener {
        public void chosenDivision(int var1);
    }

    private class DivisionButton
    extends MenuButton {
        private int index;
        private Image defaultLayerImage;
        private ColorRGBA grey;

        public DivisionButton(String string, int n) {
            super("divisionButton" + n);
            this.grey = new ColorRGBA(0.85f, 0.85f, 0.85f, 1.0f);
            this.defaultLayerImage = new Image("divisionDefaultImage" + n, string, 1.0f);
            this.defaultLayer = this.defaultLayerImage;
            this.addLayer(this.defaultLayer);
            this.getScaler().setDamping(scaleDamping);
            this.defaultLayer.getScaler().setDamping(scaleDamping);
            this.defaultLayer.getFader().setColor(this.grey);
            this.index = n;
            this.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    ChooseDivisionPanel.this.chosenDivision(DivisionButton.this.index);
                }
            });
        }

        public void setSize(float f, float f2) {
            super.setSize(f, f2);
            this.defaultLayerImage.setSize(f, f2);
        }

        protected void updateLook() {
            if (this.isEnabled()) {
                if (this.isActive()) {
                    this.defaultLayer.getFader().fadeTo(darker, clickFadeTime);
                    this.getScaler().clearListeners();
                    this.getScaler().setRepeatType(0);
                    this.getScaler().setDamping(scaleDamping);
                    this.getScaler().scaleTo(mouseDownScale, clickScaleTime, clickScaleTime);
                } else if (this.isFocused()) {
                    this.defaultLayer.getFader().fadeTo(fullAlpha, fadeTime);
                    this.getScaler().clearListeners();
                    this.getScaler().setRepeatType(0);
                    this.getScaler().setDamping(scaleDamping);
                    this.getScaler().scaleTo(mouseOverScale1, scaleTime, scaleTime);
                    this.getScaler().add(new MenuButton.AddCycleListener());
                } else {
                    this.getScaler().clearListeners();
                    this.defaultLayer.getFader().fadeTo(this.grey, fadeTime);
                    this.getScaler().setRepeatType(0);
                    this.getScaler().setDamping(scaleCycleDamping);
                    this.getScaler().scaleTo(defaultScale, scaleCycleTime, scaleCycleMinTime);
                }
            } else {
                this.defaultLayer.getFader().fadeTo(this.disabled, fadeTime);
            }
        }
    }
}

