/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector3f;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gui.turbogui.label.AlternatingLabel;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.ScrollableLabelList;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.RaceData;
import com.turborilla.msm.replay.ReplayAI;
import com.turborilla.msm.replay.ReplayParticipant;
import com.turborilla.msm.statemachine.MsmStateMachineException;
import com.turborilla.msm.states.MsmGameStateException;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.msm.track.Track1D;
import com.turborilla.msm.utils.TimeFunctions;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.io.IOException;

public class TimeAttackInfoPanel
extends BaseMenuPanel {
    private GameSettings settings;
    private int divisionIndex;
    private int trackIndex;
    private Label trackNameLabel;
    private AlternatingLabel bestTimeLabel;
    private DivisionDescriptor divisionDescriptor;
    private boolean adminReplayAI = false;
    private boolean newRecord = false;
    private float shavedTime = 0.0f;
    private MenuButton attackButton;
    private ScrollableLabelList<RaceData> raceList;

    public TimeAttackInfoPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("TimeAttackInfo", f, f2, guiHandler, gameSettings);
        this.settings = gameSettings;
        this.adminReplayAI = this.adminReplayAI && "InternalTest".equals(gameSettings.get("version", "Demo"));
        VariableRowLayout variableRowLayout = new VariableRowLayout(f, f2);
        variableRowLayout.setRows(1.3f, 1.0f, 4.0f, 0.8f);
        this.setLayout(variableRowLayout);
        this.initGUI(guiHandler);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI(GuiHandler guiHandler) {
        BaseLayout baseLayout = new BaseLayout();
        this.getLayout().add(baseLayout);
        this.trackNameLabel = new Label("trackNameLabel", "", 1.0f, 1.0f, "menufont", null);
        baseLayout.add(this.trackNameLabel);
        this.addWidget(this.trackNameLabel);
        RowLayout rowLayout = new RowLayout();
        this.getLayout().add(rowLayout);
        rowLayout.setPadding(0.07f, 0.0f);
        BaseLayout baseLayout2 = new BaseLayout();
        rowLayout.add(baseLayout2);
        BaseLayout baseLayout3 = new BaseLayout();
        rowLayout.add(baseLayout3);
        Label label = new Label("bestTextLabel", "Personal best:", 1.0f, 1.0f, "menufont", null);
        baseLayout2.add(label);
        this.addWidget(label);
        label.setHorisontalAlignment(HorisontalAlignment.RIGHT);
        this.bestTimeLabel = new AlternatingLabel("bestTimeLabel", "", 1.0f, 1.0f, "menufontover", null);
        baseLayout3.add(this.bestTimeLabel);
        this.addWidget(this.bestTimeLabel);
        BaseLayout baseLayout4 = new BaseLayout();
        this.getLayout().add(baseLayout4);
        baseLayout4.setPadding(0.2f, 0.2f);
        this.raceList = new ScrollableLabelList("RacesList", this.getWidth() * 0.6f, this.getHeight() * 0.42f, this.getGuiHandler(), "normal_small_black", "corner", "edge", "combobox", 0.3f, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.0225f);
        this.addWidget(this.raceList);
        baseLayout4.add(this.raceList);
        RowLayout rowLayout2 = new RowLayout();
        this.getLayout().add(rowLayout2);
        rowLayout2.setPadding(0.05f, 0.0f);
        MenuButton menuButton = new MenuButton("backToChooseTrackButton", "Back", 1.0f, 1.0f);
        rowLayout2.add(menuButton);
        this.addWidget(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                TimeAttackInfoPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
            }
        });
        this.attackButton = new MenuButton("attackButton", "Attack", 1.0f, 1.0f);
        rowLayout2.add(this.attackButton);
        this.addWidget(this.attackButton);
        this.attackButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                TimeAttackInfoPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
            }
        });
        if (this.adminReplayAI) {
            MenuButton menuButton2 = new MenuButton("makeAI", "make AI", 1.0f, 1.0f);
            rowLayout2.add(menuButton2);
            this.addWidget(menuButton2);
            menuButton2.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    try {
                        RaceData raceData = (RaceData)TimeAttackInfoPanel.this.raceList.getSelected();
                        if (raceData == null) {
                            return;
                        }
                        ReplayParticipant replayParticipant = raceData.loadReplay().getParticipants()[0];
                        Track1D track1D = null;
                        String string = TimeAttackInfoPanel.this.getDivisionDescriptor().getTrack(TimeAttackInfoPanel.this.divisionIndex, TimeAttackInfoPanel.this.trackIndex);
                        track1D = (Track1D)ResourceManager.getInstance().load("track1D", string, null);
                        ReplayAI replayAI = new ReplayAI(track1D, replayParticipant);
                        File file = new File(SystemFolder.getReplayFolder("AI"));
                        File file2 = new File(file, string + ".msmai");
                        if (file2.exists()) {
                            file2.delete();
                        }
                        BinaryExporter binaryExporter = BinaryExporter.getInstance();
                        binaryExporter.save((Savable)replayAI, file2);
                    }
                    catch (IOException iOException) {
                        throw new MsmGameStateException(iOException);
                    }
                }
            });
        }
        this.raceList.setSimulateClickWidgetOnDoubleClick(this.attackButton);
    }

    private void showInfoOnTrack(int n, int n2) {
        String string = this.getDivisionDescriptor().getTrack(n, n2);
        this.trackNameLabel.setText(string);
        Profile profile = Profile.getCurrentProfile(this.settings);
        RaceData raceData = null;
        RaceData[] raceDataArray = profile.getData().getRaces(n, n2);
        if (raceDataArray == null) {
            return;
        }
        raceData = raceDataArray[0];
        if (!this.newRecord) {
            String string2 = TimeFunctions.getMinSecHundredths(raceData.getPassedFinishlineAtTime());
            this.bestTimeLabel.setText(string2);
        } else {
            this.bestTimeLabel.setText(TimeFunctions.getMinSecHundredths(raceData.getPassedFinishlineAtTime()), "New record", "-" + TimeFunctions.getMinSecHundredths(this.shavedTime));
            this.newRecord = false;
            this.shavedTime = 0.0f;
        }
    }

    public void setNewRecord(float f) {
        this.newRecord = true;
        this.shavedTime = f;
    }

    public void onActivate() {
        super.onActivate();
        this.showInfoOnTrack(this.divisionIndex, this.trackIndex);
        this.fillRaceList();
        this.getGuiHandler().focusWidget(this.attackButton);
    }

    private void fillRaceList() {
        RaceData[] raceDataArray = Profile.getCurrentProfile(this.getSettings()).getData().getRaces(this.divisionIndex, this.trackIndex);
        RaceData raceData = this.raceList.getSelected();
        this.raceList.clear();
        if (raceDataArray != null) {
            this.raceList.addItems((RaceData[])raceDataArray);
            if (raceDataArray.length > 0) {
                this.raceList.setSelectedItem(raceDataArray[0]);
            }
        }
    }

    public void setTrack(int n, int n2) {
        this.divisionIndex = n;
        this.trackIndex = n2;
    }

    public RaceData getChosenReplayRaceData() {
        return this.raceList.getSelected();
    }

    private DivisionDescriptor getDivisionDescriptor() {
        if (this.divisionDescriptor == null) {
            try {
                this.divisionDescriptor = Profile.getCurrentProfile(this.getSettings()).getDifficulty() == Difficulty.Arcade ? (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "arcade_divisions", null) : (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "simulation_divisions", null);
            }
            catch (IOException iOException) {
                throw new MsmStateMachineException(iOException);
            }
        }
        return this.divisionDescriptor;
    }
}

