/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.textfield.TextField;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class RenameProfileMenuPanel
extends BaseMenuPanel {
    protected ILayout layout;
    protected TextField nameField;

    public RenameProfileMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("EnterName", f, f2, guiHandler, gameSettings);
        this.layout = new ColumnLayout(new Vector2f(), f, f2, 0.024f, 0.25f);
        this.initGUI();
    }

    private void initGUI() {
        Label label = new Label("EnterNameLabel", "Enter name", 1.0f, 1.0f, "menufont", null);
        this.addWidget(label);
        this.layout.add(label);
        RowLayout rowLayout = new RowLayout();
        this.layout.add(rowLayout);
        this.nameField = new TextField("NameTextField", "", 370.0f, 70.0f, 16, "menufont", "menufontover");
        this.nameField.setValidChars("abcdefghijklmnopqrstuvwxyz\u00c3\u00a5\u00c3\u00a4\u00c3\u00b6ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c3\u2026\u00c3\u201e\u00c3\u20130123456789 _-.!()[]{}$");
        this.addWidget(this.nameField);
        rowLayout.add(this.nameField);
        this.layout.add(null);
        ColumnLayout columnLayout = new ColumnLayout(new Vector2f(), 1.0f, 1.0f, 0.024f, 0.7f);
        RowLayout rowLayout2 = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
        columnLayout.add(rowLayout2);
        this.layout.add(columnLayout);
        MenuButton menuButton = new MenuButton("CancelButton", "Cancel", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        rowLayout2.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                RenameProfileMenuPanel.this.cancel();
            }
        });
        menuButton = new MenuButton("OkButton", "Ok", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        rowLayout2.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                RenameProfileMenuPanel.this.apply();
            }
        });
        this.nameField.setEnterPassedOnToWidget(menuButton);
        this.layout.doLayout();
    }

    public void onActivate() {
        this.nameField.setText(Profile.getCurrentProfileName(this.getSettings()));
        this.getGuiHandler().focusWidget(this.nameField);
        this.nameField.setCaretPosition(this.nameField.getText().length());
    }

    private void cancel() {
        this.getEventManager().fireEvent("PreviousMenu");
    }

    protected void apply() {
        String string = this.nameField.getText();
        if (string == null || string.length() <= 0) {
            return;
        }
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        if (profile != null) {
            profile.setName(string);
            Profile.setCurrentProfile(this.getSettings(), string);
            this.getEventManager().fireEvent("PreviousMenu");
        } else {
            this.nameField.setText("");
        }
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.layout.setSize(f, f2);
        this.layout.doLayout();
    }
}

