/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.Panel;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Profile;

public class ProfilePanel
extends Panel {
    GameSettings settings;
    String currentProfile;
    ILayout layout;
    private Label nameLabel;
    private float textSize;
    private EventManager eventManager;

    public ProfilePanel(String string, float f, float f2, GuiHandler guiHandler, GameSettings gameSettings, float f3) {
        super(string, f, f2, guiHandler);
        this.settings = gameSettings;
        this.textSize = f3;
        this.layout = new ColumnLayout(new Vector2f(), f, f2, 0.024f);
        this.initGUI();
        this.update();
    }

    private void initGUI() {
        Label label = new Label("WelcomeLabel", "Welcome,", 1.0f, 1.0f, "menufont", null);
        label.setTextSizeFactor(this.textSize);
        label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.addWidget(label, new Vector2f(), true, true);
        this.layout.add(label);
        this.nameLabel = new Label("NameLabel", "", 1.0f, 1.0f, "menufontover", null);
        this.nameLabel.setTextSizeFactor(this.textSize);
        this.nameLabel.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.addWidget(this.nameLabel, new Vector2f(), true, true);
        this.layout.add(this.nameLabel);
        MenuButton menuButton = new MenuButton("changeButton", "Change", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        this.layout.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (ProfilePanel.this.getEventManager() != null) {
                    if (!Boolean.parseBoolean(ProfilePanel.this.settings.get("FirstProfile", "true"))) {
                        ProfilePanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ChooseProfile"}});
                    } else {
                        ProfilePanel.this.settings.set("FirstProfile", "false");
                        ProfilePanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"EnterName"}});
                    }
                }
            }
        });
        MenuButton menuButton2 = new MenuButton("profileStatsButton", "View", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton2, new Vector2f(), true, true);
        this.layout.add(menuButton2);
        menuButton2.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (ProfilePanel.this.getEventManager() != null) {
                    ProfilePanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
                }
            }
        });
        this.layout.doLayout();
    }

    public void update() {
        this.currentProfile = Profile.getCurrentProfileName(this.settings);
        this.nameLabel.setText(this.currentProfile);
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.layout.setSize(f, f2);
        this.layout.doLayout();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

