/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.Game;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.BuyMenuButton;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.utils.Font;
import com.turborilla.utils.controllers.SpatialTranslationController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;

public class MainMenuPanel
extends BaseMenuPanel {
    private boolean cheatEnabled = false;
    private ILayout layout;
    private MenuButton creditsButton;
    private MenuButton editorButton;
    private int[] cheatKeys = new int[]{46, 35, 18, 30, 20};
    private int cheatKeyIndex = 0;
    private Image developedBy;

    public SpatialTranslationController getMover() {
        return super.getMover();
    }

    public MainMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("Main", f, f2, guiHandler, gameSettings);
        String string = gameSettings.get("version", "Demo");
        if ("Review".equals(string) || "InternalTest".equals(string) || "ExternalTest".equals(string)) {
            this.cheatEnabled = true;
        }
        this.layout = new ColumnLayout(new Vector2f(), f, f2, 0.024f, 0.25f);
        this.initGUI();
    }

    private void initGUI() {
        Object object;
        Properties properties = new Properties();
        properties.setProperty("charSpacingFactor", "0.65");
        try {
            object = (Font)ResourceManager.getInstance().load("font", "menufont", properties);
            object = (Font)ResourceManager.getInstance().load("font", "menufontover", properties);
            object = (Font)ResourceManager.getInstance().load("font", "textfont", properties);
            object = (Font)ResourceManager.getInstance().load("font", "textfontblack", properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new MenuButton("playButton", "Play", 200.0f, 50.0f, this.textSize);
        this.addWidget((BaseWidget)object, new Vector2f(0.5f, 0.5f), true, true);
        ((MenuButton)object).addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                MainMenuPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Play"}});
            }
        });
        this.layout.add((IResizableWidget)object);
        Object object2 = object;
        object = new MenuButton("optionsButton", "Options", 200.0f, 50.0f, this.textSize);
        this.addWidget((BaseWidget)object, new Vector2f(0.5f, 0.5f), true, true);
        ((MenuButton)object).addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                MainMenuPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Options"}});
            }
        });
        this.layout.add((IResizableWidget)object);
        object = new MenuButton("editorButton", "Editor", 200.0f, 50.0f, this.textSize);
        this.addWidget((BaseWidget)object, new Vector2f(0.5f, 0.3f), true, true);
        ((MenuButton)object).addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                MainMenuPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {"editorButton"}});
            }
        });
        this.layout.add((IResizableWidget)object);
        this.editorButton = object;
        object = new MenuButton("exitButton", "Quit", 200.0f, 50.0f, this.textSize);
        this.addWidget((BaseWidget)object, new Vector2f(0.5f, 0.5f), true, true);
        ((MenuButton)object).addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                MainMenuPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
            }
        });
        this.layout.add((IResizableWidget)object);
        IButtonClickedListener iButtonClickedListener = null;
        if ("Demo".equals(this.getSettings().get("version", "Demo"))) {
            if (Boolean.parseBoolean(this.getSettings().get("showBuyButtons", "false"))) {
                int n = Integer.parseInt(this.getSettings().get("demoVariant", "0"));
                object = n == 4 ? new BuyMenuButton("webButton", "get Full Version", 200.0f, 50.0f, this.textSize * 0.8f) : new BuyMenuButton("webButton", "get Full Version", 200.0f, 50.0f, this.textSize * 0.8f);
                iButtonClickedListener = new IButtonClickedListener(){

                    public void onClick(MenuButton menuButton, Vector3f vector3f) {
                        MainMenuPanel.this.getGuiHandler().focusWidget(null);
                        Game.buy("mainmenu");
                    }
                };
            }
        } else if (Boolean.parseBoolean(this.getSettings().get("showTurborillaLinks", "false"))) {
            object = new MenuButton("webButton", "Visit website", 200.0f, 50.0f, this.textSize);
            iButtonClickedListener = new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    MainMenuPanel.this.getGuiHandler().focusWidget(null);
                    Sys.openURL("http://www.madskillsmotocross.com/");
                }
            };
        }
        if (iButtonClickedListener != null) {
            this.addWidget((BaseWidget)object, new Vector2f(0.5f, 0.5f), true, true);
            ((MenuButton)object).addListener(iButtonClickedListener);
            this.layout.add((IResizableWidget)object);
        } else {
            this.layout.add(null);
        }
        ((BaseWidget)object).setNextWidget((IWidget)object2);
        ((BaseWidget)object2).setPreviousWidget((IWidget)object);
        this.creditsButton = new MenuButton("creditsButton", "Credits", 1.0f, 1.0f, this.textSize);
        this.addWidget(this.creditsButton, new Vector2f(0.5f, 0.5f), true, true);
        this.creditsButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                MainMenuPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
            }
        });
        this.developedBy = new Image("developedBy");
        this.developedBy.editLoaderProperties().setProperty("textureMinFilter", "6");
        this.developedBy.setImage("developed_by_turborilla");
        this.addWidget(this.developedBy);
        this.setSize(this.getWidth(), this.getHeight());
    }

    public void onActivate() {
        super.onActivate();
        this.getGuiHandler().focusWidget(this.getLayer("playButton"));
    }

    protected boolean handleEscape() {
        this.getEventManager().fireEvent("Quit");
        return true;
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.layout.setSize(f, f2);
        this.layout.doLayout();
        this.creditsButton.setSize(f2 * 0.4f, f2 * 0.1f);
        this.creditsButton.setPosition(new Vector2f(f2 * 1.2f, -f2 * 0.55f));
        this.developedBy.setSize(f2 * 0.5f, f2 * 0.1f);
        this.developedBy.setPosition(new Vector2f(-f2 * 1.1f, -f2 * 0.45f));
    }

    public void updateGeometricState(float f, boolean bl) {
        super.updateGeometricState(f, bl);
        if (this.cheatEnabled) {
            for (int i = 0; i < Keyboard.getKeyCount(); ++i) {
                if (!Keyboard.isKeyDown(i)) continue;
                if (i == this.cheatKeys[this.cheatKeyIndex]) {
                    ++this.cheatKeyIndex;
                    if (this.cheatKeyIndex != this.cheatKeys.length) break;
                    ProgressData.cheatAllUnlocked = true;
                    this.cheatKeyIndex = 0;
                    System.out.println("cheat");
                    ArrayList<IWidget> arrayList = this.getLayers();
                    for (IWidget iWidget : arrayList) {
                        if (!(iWidget instanceof BaseWidget)) continue;
                        BaseWidget baseWidget = (BaseWidget)iWidget;
                        baseWidget.getScaler().clearScalingQueue();
                        baseWidget.getScaler().scaleTo(baseWidget.getLocalScale().mult(1.3f), 1.0f, 1.0f);
                        baseWidget.getScaler().addScalingToQueue(baseWidget.getLocalScale().clone(), 0.2f, 0.2f);
                    }
                    break;
                }
                if (this.cheatKeyIndex <= 0 || i == this.cheatKeys[this.cheatKeyIndex - 1]) break;
                this.cheatKeyIndex = 0;
                break;
            }
        }
    }
}

