/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class ConfirmMenuPanel
extends BaseMenuPanel {
    private ILayout layout;
    private ILayout rowLayout;
    private Label countdownLabel;
    private int seconds = 25;
    private float elapsedTime = 0.0f;
    private String countDownText = " seconds until 'No'";
    private boolean counting = false;
    private int previousSecond = -1;

    public ConfirmMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("Confirm", f, f2, guiHandler, gameSettings);
        this.layout = new ColumnLayout(new Vector2f(), f, f2, 0.024f, 0.25f);
        this.rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
        this.initGUI();
    }

    private void initGUI() {
        Label label = new Label("confirmLabel", "Would you like to keep these settings?", 1.0f, 1.0f, "menufont", null);
        this.addWidget(label, new Vector2f(), true, true);
        this.layout.add(label);
        this.countdownLabel = new Label("countdownLabel", this.seconds + this.countDownText, 1.0f, 1.0f, "textfont", null);
        this.addWidget(this.countdownLabel, new Vector2f(), true, true);
        this.layout.add(this.countdownLabel);
        this.layout.add(null);
        MenuButton menuButton = new MenuButton("NoButton", "No", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ConfirmMenuPanel.this.no();
            }
        });
        this.rowLayout.add(menuButton);
        menuButton = new MenuButton("NoButton", "Yes", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ConfirmMenuPanel.this.yes();
            }
        });
        this.rowLayout.add(menuButton);
        this.layout.add(this.rowLayout);
        this.layout.doLayout();
    }

    public void start(int n) {
        this.counting = true;
        this.seconds = n;
        this.elapsedTime = 0.0f;
        this.previousSecond = -1;
    }

    public void updateGeometricState(float f, boolean bl) {
        if (this.counting) {
            if (f > 0.04f) {
                f = 0.04f;
            }
            this.elapsedTime += f;
            if (this.elapsedTime > (float)this.seconds) {
                this.countdownLabel.setText(this.seconds + this.countDownText);
                this.no();
            } else {
                int n = (int)this.elapsedTime;
                if (n > this.previousSecond) {
                    this.previousSecond = n;
                    this.countdownLabel.setText(this.seconds - n + this.countDownText);
                }
            }
        }
        super.updateGeometricState(f, bl);
    }

    private void no() {
        this.elapsedTime = 0.0f;
        this.previousSecond = -1;
        this.counting = false;
        this.getEventManager().fireEvent("RevertDisplayChange");
    }

    private void yes() {
        this.elapsedTime = 0.0f;
        this.previousSecond = -1;
        this.counting = false;
        this.getEventManager().fireEvent("PreviousMenu");
        this.getEventManager().fireEvent("PreviousMenu", new String[][]{{"noTransition"}, {"true"}});
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.layout.setSize(f, f2);
        this.layout.doLayout();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.start(this.seconds);
        }
    }
}

