/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.input.MouseInput;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.slider.Slider;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.MouseData;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class ConfigureMouseMenuPanel
extends BaseMenuPanel {
    private ConfigureKeyboardAndMouseInputLabel configureInputLabel;
    private Difficulty difficulty = Difficulty.Arcade;
    private Slider sensitivitySlider;
    private MenuButton configureInputButton;
    private MenuButton saveButton;

    public ConfigureMouseMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("ConfigureMouse", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.33f, 1.33f, 1.33f, 1.0f);
        this.setLayout(variableRowLayout);
        this.initGUI();
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI() {
        BaseLayout baseLayout = new BaseLayout();
        this.getLayout().add(baseLayout);
        baseLayout.setPadding(0.3f, 0.2f);
        this.sensitivitySlider = new Slider("sensitivitySlider", 1.0f, 1.0f, "sliderknobnormal", "sliderknobover", "sliderline", "sliderline", null);
        baseLayout.add(this.sensitivitySlider);
        this.addWidget(this.sensitivitySlider);
        BaseLayout baseLayout2 = new BaseLayout();
        this.getLayout().add(baseLayout2);
        baseLayout2.setPadding(0.0f, 0.05f);
        this.configureInputButton = new MenuButton("configureInputButton", "Set buttons", 1.0f, 1.0f);
        baseLayout2.add(this.configureInputButton);
        this.addWidget(this.configureInputButton);
        this.configureInputButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ConfigureMouseMenuPanel.this.configureInput(true);
            }
        });
        this.configureInputLabel = new ConfigureKeyboardAndMouseInputLabel("ConfigureInputLabel");
        baseLayout2.add(this.configureInputLabel);
        this.configureInputLabel.setDoneListener(new Runnable(){

            public void run() {
                ConfigureMouseMenuPanel.this.configureInput(false);
            }
        });
        this.getLayout().add(null);
        RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.0f);
        this.getLayout().add(rowLayout);
        rowLayout.setPadding(0.2f, 0.2f);
        MenuButton menuButton = new MenuButton("CancelButton", "Cancel", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        rowLayout.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ConfigureMouseMenuPanel.this.cancel();
            }
        });
        this.saveButton = new MenuButton("saveButton", "Save", 1.0f, 1.0f, this.textSize);
        this.addWidget(this.saveButton, new Vector2f(), true, true);
        rowLayout.add(this.saveButton);
        this.saveButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ConfigureMouseMenuPanel.this.apply();
            }
        });
        this.reset();
    }

    public void configureInput(boolean bl) {
        this.removeWidget(this.configureInputLabel);
        this.removeWidget(this.configureInputButton);
        if (bl) {
            this.addWidget(this.configureInputLabel);
            this.sensitivitySlider.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.getGuiHandler().focusWidget(this.configureInputLabel);
        } else {
            this.addWidget(this.configureInputButton);
            this.sensitivitySlider.setEnabled(true);
            this.saveButton.setEnabled(true);
            if (this.isEnabled()) {
                this.getGuiHandler().focusWidget(this.saveButton);
            }
        }
        this.getLayout().doLayout();
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    private void reset() {
        this.configureInputLabel.reset();
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        MouseData mouseData = profile.getData(this.difficulty).getInputData().getMouseData();
        this.sensitivitySlider.setValue(mouseData.getSensitivity());
        this.configureInput(false);
    }

    private void apply() {
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        MouseData mouseData = profile.getData(this.difficulty).getInputData().getMouseData();
        if (this.configureInputLabel.throttleKey >= 0) {
            mouseData.setThrottleKey(this.configureInputLabel.throttleKey);
            if (mouseData.getBrakeKey() == mouseData.getThrottleKey()) {
                mouseData.setBrakeKey(-1);
            }
            if (mouseData.getSpecialKey() == mouseData.getThrottleKey()) {
                mouseData.setSpecialKey(-1);
            }
        }
        if (this.configureInputLabel.brakeKey >= 0) {
            mouseData.setBrakeKey(this.configureInputLabel.brakeKey);
            if (mouseData.getThrottleKey() == mouseData.getBrakeKey()) {
                mouseData.setThrottleKey(-1);
            }
            if (mouseData.getSpecialKey() == mouseData.getBrakeKey()) {
                mouseData.setSpecialKey(-1);
            }
        }
        if (this.configureInputLabel.specialKey >= 0) {
            mouseData.setSpecialKey(this.configureInputLabel.specialKey);
            if (mouseData.getThrottleKey() == mouseData.getSpecialKey()) {
                mouseData.setThrottleKey(-1);
            }
            if (mouseData.getBrakeKey() == mouseData.getSpecialKey()) {
                mouseData.setBrakeKey(-1);
            }
        }
        if (this.configureInputLabel.throttleMouse >= 0) {
            mouseData.setThrottleMouse(this.configureInputLabel.throttleMouse);
            if (mouseData.getBrakeMouse() == mouseData.getThrottleMouse()) {
                mouseData.setBrakeMouse(-1);
            }
            if (mouseData.getSpecialMouse() == mouseData.getThrottleMouse()) {
                mouseData.setSpecialMouse(-1);
            }
        }
        if (this.configureInputLabel.brakeMouse >= 0) {
            mouseData.setBrakeMouse(this.configureInputLabel.brakeMouse);
            if (mouseData.getThrottleMouse() == mouseData.getBrakeMouse()) {
                mouseData.setThrottleMouse(-1);
            }
            if (mouseData.getSpecialMouse() == mouseData.getBrakeMouse()) {
                mouseData.setSpecialMouse(-1);
            }
        }
        if (this.configureInputLabel.specialMouse >= 0) {
            mouseData.setSpecialMouse(this.configureInputLabel.specialMouse);
            if (mouseData.getThrottleMouse() == mouseData.getSpecialMouse()) {
                mouseData.setThrottleMouse(-1);
            }
            if (mouseData.getBrakeMouse() == mouseData.getSpecialMouse()) {
                mouseData.setBrakeMouse(-1);
            }
        }
        mouseData.setConfigured(true);
        mouseData.setSensitivity(this.sensitivitySlider.getValue());
        profile.save();
        profile.getData(this.difficulty).getInputData().notifyChangeListeners();
        this.getEventManager().fireEvent("PreviousMenu");
    }

    private void cancel() {
        this.getEventManager().fireEvent("PreviousMenu");
    }

    public void onActivate() {
        this.reset();
        super.onActivate();
        this.getGuiHandler().focusWidget(this.sensitivitySlider);
    }

    public void onDeactivate() {
        super.onDeactivate();
    }

    private class ConfigureKeyboardAndMouseInputLabel
    extends Label {
        private int step;
        private static final int numKeys = 300;
        private static final int numMouseButtons = 10;
        private String[] stepTextArcade;
        private String[] stepTextSimulation;
        int throttleKey;
        int brakeKey;
        int specialKey;
        int throttleMouse;
        int brakeMouse;
        int specialMouse;
        int[] alreadyChosenKeys;
        int[] alreadyChosenButtons;
        boolean[] keyStateChanged;
        boolean[] buttonStateChanged;
        boolean[] buttonState;
        private Runnable doneListener;

        public ConfigureKeyboardAndMouseInputLabel(String string) {
            super(string, "", 1.0f, 1.0f, "textfont", null);
            this.step = 0;
            this.stepTextArcade = new String[]{"press THROTTLE", "press BRAKE", "press SPECIAL"};
            this.stepTextSimulation = new String[]{"press THROTTLE", "press BRAKE", "press SLOW-MO"};
            this.throttleKey = -1;
            this.brakeKey = -1;
            this.specialKey = -1;
            this.throttleMouse = -1;
            this.brakeMouse = -1;
            this.specialMouse = -1;
            this.alreadyChosenKeys = new int[3];
            this.alreadyChosenButtons = new int[3];
            this.doneListener = null;
            this.setFocusable(true);
            this.reset();
        }

        public void reset() {
            int n;
            this.throttleKey = -1;
            this.brakeKey = -1;
            this.specialKey = -1;
            this.throttleMouse = -1;
            this.brakeMouse = -1;
            this.specialMouse = -1;
            for (n = 0; n < this.alreadyChosenKeys.length; ++n) {
                this.alreadyChosenKeys[n] = -1;
            }
            if (this.keyStateChanged == null) {
                this.keyStateChanged = new boolean[300];
            }
            for (n = 0; n < this.keyStateChanged.length; ++n) {
                this.keyStateChanged[n] = false;
            }
            for (n = 0; n < this.alreadyChosenButtons.length; ++n) {
                this.alreadyChosenButtons[n] = -1;
            }
            if (this.buttonStateChanged == null) {
                this.buttonStateChanged = new boolean[10];
            }
            for (n = 0; n < this.buttonStateChanged.length; ++n) {
                this.buttonStateChanged[n] = false;
            }
            if (this.buttonState == null) {
                this.buttonState = new boolean[10];
            }
            for (n = 0; n < this.buttonState.length; ++n) {
                this.buttonState[n] = false;
            }
            this.gotoStep(0);
        }

        public void update() {
            if (!this.isEnabled()) {
                return;
            }
            switch (this.step) {
                case 0: {
                    int n = this.getButton();
                    if (n < 0) break;
                    if (n >= 1000) {
                        this.throttleMouse = n - 1000;
                    } else {
                        this.throttleKey = n;
                    }
                    this.nextStep();
                    break;
                }
                case 1: {
                    int n = this.getButton();
                    if (n < 0) break;
                    if (n >= 1000) {
                        this.brakeMouse = n - 1000;
                    } else {
                        this.brakeKey = n;
                    }
                    this.nextStep();
                    break;
                }
                case 2: {
                    int n = this.getButton();
                    if (n < 0) break;
                    if (n >= 1000) {
                        this.specialMouse = n - 1000;
                    } else {
                        this.specialKey = n;
                    }
                    this.nextStep();
                }
            }
        }

        private int getButton() {
            int n;
            int n2 = -1;
            for (n = 0; n < this.keyStateChanged.length; ++n) {
                if (this.isAlreadyChosen(n, this.alreadyChosenKeys) || !this.keyStateChanged[n]) continue;
                this.setAlreadyChosen(n, this.alreadyChosenKeys);
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                return n2;
            }
            for (n = 0; n < this.buttonStateChanged.length; ++n) {
                if (this.isAlreadyChosen(n, this.alreadyChosenButtons) || !this.buttonStateChanged[n]) continue;
                this.setAlreadyChosen(n, this.alreadyChosenButtons);
                n2 = n + 1000;
                break;
            }
            return n2;
        }

        private boolean isAlreadyChosen(int n, int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
            return false;
        }

        private void setAlreadyChosen(int n, int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= 0) continue;
                nArray[i] = n;
                return;
            }
        }

        private void nextStep() {
            if (this.step + 1 >= (ConfigureMouseMenuPanel.this.difficulty == Difficulty.Simulation ? this.stepTextSimulation.length : this.stepTextArcade.length)) {
                this.done();
            } else {
                this.gotoStep(this.step + 1);
            }
        }

        private void done() {
            this.setText("");
            if (this.doneListener != null) {
                this.doneListener.run();
            }
        }

        private void gotoStep(int n) {
            this.step = n;
            this.setText(ConfigureMouseMenuPanel.this.difficulty == Difficulty.Simulation ? this.stepTextSimulation[n] : this.stepTextArcade[n]);
        }

        public boolean onKeyDown(int n, char c) {
            return true;
        }

        public boolean onKeyTyped(int n, char c) {
            this.keyStateChanged[n] = true;
            return true;
        }

        public boolean onKeyUp(int n, char c) {
            return true;
        }

        public void updateGeometricState(float f, boolean bl) {
            super.updateGeometricState(f, bl);
            MouseInput mouseInput = MouseInput.get();
            if (mouseInput != null) {
                for (int i = 0; i < mouseInput.getButtonCount() && i < this.buttonStateChanged.length; ++i) {
                    if (mouseInput.isButtonDown(i)) {
                        if (!this.buttonState[i]) {
                            this.buttonState[i] = true;
                            this.buttonStateChanged[i] = true;
                            continue;
                        }
                        this.buttonStateChanged[i] = false;
                        continue;
                    }
                    if (this.buttonState[i]) {
                        this.buttonState[i] = false;
                        this.buttonStateChanged[i] = true;
                        continue;
                    }
                    this.buttonStateChanged[i] = false;
                }
            }
            this.update();
        }

        public void setDoneListener(Runnable runnable) {
            this.doneListener = runnable;
        }
    }
}

