/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.input.InputHandler;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.msm.gui.turbogui.Rectangle;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.InputData;
import com.turborilla.msm.profile.JoystickData;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.StandardState;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Logger;

public abstract class BaseMenuState
extends StandardState {
    private static Logger logger = Logger.getLogger(BaseMenuState.class.getName());
    private Node guiNode;
    private InputHandler input;
    private static ColorRGBA backgroundColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.15f);
    private static Vector2f backgroundPos = new Vector2f(0.5f, 0.5f);
    private static Vector2f backgroundSize = new Vector2f(1.0f, 1.0f);
    private GuiHandler gui;
    protected ArrayList<BaseMenuPanel> menus;
    protected BaseMenuPanel currentMenu = null;
    private Stack<BaseMenuPanel> menuActivationStack;
    private int numberToKeepInStack = 10;
    private HashMap<BaseMenuPanel, IWidget> focusedWidgetPerMenu;
    protected Vector3f childPanelPosition = new Vector3f();
    protected Vector3f panelMoveBackVector = new Vector3f();
    protected Vector3f panelMoveForwardVector = new Vector3f();
    protected float panelMoveTime = 2.8f;
    protected float panelRemoveTime = 0.5f;
    protected float panelMoveDamping = 0.2f;
    protected float panelPositionX = 0.5f;
    protected float panelPositionY = 0.5f;
    private String menuToSwitchToWhenReady = null;
    private Vector2f size = new Vector2f();
    private Vector3f tempVec = new Vector3f();
    private DetachWhenDone detachWhenDone = new DetachWhenDone();
    private Rectangle darkRectangle;

    public BaseMenuState(String string, GameSettings gameSettings, URL uRL) {
        this(string, gameSettings, uRL, new InputHandler());
    }

    public BaseMenuState(String string, GameSettings gameSettings, URL uRL, InputHandler inputHandler) {
        super(string, gameSettings, uRL);
        this.initRootNode();
        this.input = inputHandler;
        this.focusedWidgetPerMenu = new HashMap();
        URL uRL2 = ResourceManager.findUrl("cursor", new String[]{"images", "images/gui"}, new String[]{"png", "tga", "jpg"});
        this.gui = new GuiHandler(new Vector2f(DisplaySystem.getDisplaySystem().getWidth(), DisplaySystem.getDisplaySystem().getHeight()), inputHandler, uRL2, new Vector3f(4.0f, 31.0f, 0.0f));
        InputData.IInputDataChangedListener iInputDataChangedListener = new InputData.IInputDataChangedListener(){

            public void inputDataChanged(InputData inputData) {
                JoystickData joystickData = inputData.getJoystickData();
                BaseMenuState.this.gui.getKeyboard().setXAxisIndex(joystickData.getXAxisIndex());
                BaseMenuState.this.gui.getKeyboard().setYAxisIndex(joystickData.getYAxisIndex());
                BaseMenuState.this.gui.getKeyboard().setInvertJoystickX(joystickData.isXAxisInverted());
                BaseMenuState.this.gui.getKeyboard().setInvertJoystickY(joystickData.isYAxisInverted());
                BaseMenuState.this.gui.getKeyboard().setSelectButtonIndex(joystickData.getThrottleButtonIndex());
                BaseMenuState.this.gui.getKeyboard().setTabButtonIndex(joystickData.getBrakeButtonIndex());
            }
        };
        InputData inputData = Profile.getCurrentProfile(gameSettings).getData().getInputData();
        inputData.addChangeListener(iInputDataChangedListener);
        iInputDataChangedListener.inputDataChanged(inputData);
        this.addUpdatable(this.gui);
        this.guiNode = this.gui.getNode();
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setCullMode(0);
        cullState.setEnabled(true);
        this.guiNode.setRenderState(cullState);
        this.guiNode.setRenderQueueMode(4);
        this.guiNode.setCullMode(3);
        this.guiNode.setLightCombineMode(5);
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        lightState.detachAll();
        lightState.setEnabled(true);
        this.guiNode.setRenderState(lightState);
        this.menus = new ArrayList();
        this.menuActivationStack = new Stack();
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.size.set(displaySystem.getWidth(), displaySystem.getHeight());
        this.setPanelPosition(this.panelPositionX, this.panelPositionY);
        this.panelMoveBackVector.set(-displaySystem.getWidth(), 0.0f, 0.0f);
        this.panelMoveForwardVector.set(displaySystem.getWidth(), 0.0f, 0.0f);
        this.darkRectangle = new Rectangle("background", BaseMenuState.backgroundSize.x * (float)displaySystem.getWidth(), BaseMenuState.backgroundSize.y * (float)displaySystem.getHeight(), new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.darkRectangle.getFader().initRenderStates();
        this.darkRectangle.getFader().setColor(backgroundColor);
        this.gui.addWidget(this.darkRectangle, backgroundPos, true, true);
        this.initGUI();
        this.guiNode.updateRenderState();
        this.getRootNode().attachChild(this.gui.getNode());
        this.getRootNode().updateRenderState();
    }

    protected void addMenu(BaseMenuPanel baseMenuPanel) {
        this.gui.addWidget(baseMenuPanel, new Vector2f(), true, true);
        baseMenuPanel.getMover().setDamping(this.panelMoveDamping);
        if (baseMenuPanel.getName().equals(this.menuToSwitchToWhenReady)) {
            this.activateMenu(baseMenuPanel, false, true);
            this.setCurrentMenu(baseMenuPanel);
        } else {
            this.deactivateMenu(baseMenuPanel, false, true);
        }
        this.menus.add(baseMenuPanel);
        baseMenuPanel.setEventManager(this.getGlobalEventManager());
    }

    protected void clearMenus() {
        this.gui.clearWidgets();
        this.setCurrentMenu(null);
        this.menus.clear();
    }

    protected abstract void initGUI();

    private void initRootNode() {
        this.getRootNode().setCullMode(3);
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setCullMode(0);
        cullState.setEnabled(true);
        this.getRootNode().setRenderState(cullState);
    }

    protected boolean initGL() {
        return false;
    }

    protected void onActivate() throws IOException {
        this.darkRectangle.getFader().setColor(MenuButton.noAlpha);
        this.darkRectangle.getFader().fadeTo(backgroundColor, this.panelRemoveTime * 2.0f);
        this.gui.setPaused(false);
        this.refocusWidget();
        if (this.getCurrentMenu() != null) {
            this.getCurrentMenu().onActivate();
        }
    }

    protected void onDeactivate() {
        this.recordFocusedWidget();
        if (this.getCurrentMenu() != null) {
            this.getCurrentMenu().onDeactivate();
        }
        this.gui.setPaused(true);
    }

    protected void recordFocusedWidget() {
        IWidget iWidget = this.getGui().getFocusedWidget();
        if (this.getCurrentMenu() != null && iWidget != null) {
            this.focusedWidgetPerMenu.put(this.getCurrentMenu(), iWidget);
        }
    }

    protected void refocusWidget() {
        IWidget iWidget;
        if (this.getCurrentMenu() != null && (iWidget = this.focusedWidgetPerMenu.get(this.getCurrentMenu())) != null) {
            this.getGui().focusWidget(iWidget);
        }
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if ("DisplayModeChanged".equals(receivedEvent.getName())) {
            Vector2f vector2f = new Vector2f(DisplaySystem.getDisplaySystem().getWidth(), DisplaySystem.getDisplaySystem().getHeight());
            this.resizeGui(vector2f);
            this.switchMenu("Confirm", true);
        } else if ("DisplayChangeReverted".equals(receivedEvent.getName())) {
            Vector2f vector2f = new Vector2f(DisplaySystem.getDisplaySystem().getWidth(), DisplaySystem.getDisplaySystem().getHeight());
            this.resizeGui(vector2f);
            if ("Confirm".equals(this.getCurrentMenu().getName())) {
                this.goBack(true);
            }
        } else if ("SwitchMenu".equals(receivedEvent.getName())) {
            if (this.menus.size() == 0) {
                this.menuToSwitchToWhenReady = receivedEvent.getArgumentValue("menu");
            } else {
                this.menuToSwitchToWhenReady = null;
                this.switchMenu(receivedEvent.getArgumentValue("menu"), !Boolean.parseBoolean(receivedEvent.getArgumentValue("noTransition", "false")));
            }
        } else if ("PreviousMenu".equals(receivedEvent.getName())) {
            this.goBack(!Boolean.parseBoolean(receivedEvent.getArgumentValue("noTransition", "false")));
        } else if ("EscapePressedInMenu".equals(receivedEvent.getName()) && !this.handleEscape()) {
            this.goBack(true);
        }
    }

    protected boolean handleEscape() {
        if (this.currentMenu == null) {
            return false;
        }
        return this.currentMenu.handleEscape();
    }

    protected void resizeGui(Vector2f vector2f) {
        this.size.set(vector2f);
        this.gui.setMouseLimit(vector2f);
        this.setPanelPosition(this.panelPositionX, this.panelPositionY);
        this.panelMoveBackVector.set(-vector2f.x, 0.0f, 0.0f);
        this.panelMoveForwardVector.set(vector2f.x, 0.0f, 0.0f);
        this.currentMenu.getMover().setPosition(this.childPanelPosition);
        this.darkRectangle.setSize(vector2f.x, vector2f.y);
        this.darkRectangle.setPosition(new Vector2f(vector2f.x * 0.5f, vector2f.y * 0.5f));
    }

    public Node getGuiNode() {
        return this.guiNode;
    }

    public void setGlobalEventManager(EventManager eventManager) {
        super.setGlobalEventManager(eventManager);
        if (this.getGlobalEventManager() != null) {
            this.getGlobalEventManager().registerListener("DisplayModeChanged", this);
            this.getGlobalEventManager().registerListener("DisplayChangeReverted", this);
            this.getGlobalEventManager().registerListener("SwitchMenu", this);
            this.getGlobalEventManager().registerListener("PreviousMenu", this);
            this.getGlobalEventManager().registerListener("EscapePressedInMenu", this);
            for (int i = 0; i < this.menus.size(); ++i) {
                this.menus.get(i).setEventManager(this.getGlobalEventManager());
            }
        }
    }

    protected void stateUpdate(float f) {
        this.input.update(f);
        super.stateUpdate(f);
    }

    protected void switchMenu(String string, boolean bl) {
        BaseMenuPanel baseMenuPanel = this.getCurrentMenu();
        if (baseMenuPanel != null && baseMenuPanel.getName().equals(string)) {
            return;
        }
        BaseMenuPanel baseMenuPanel2 = this.activateMenu(string, bl, false);
        if (baseMenuPanel2 != null) {
            if (baseMenuPanel != null) {
                this.pushToStack(baseMenuPanel);
                this.recordFocusedWidget();
                this.deactivateMenu(baseMenuPanel, bl, false);
            }
            this.setCurrentMenu(baseMenuPanel2);
            this.refocusWidget();
            baseMenuPanel2.onActivate();
        }
    }

    protected void goBack(boolean bl) {
        BaseMenuPanel baseMenuPanel = this.popFromStack();
        if (baseMenuPanel != null) {
            this.activateMenu(baseMenuPanel, true, true);
            this.recordFocusedWidget();
            this.deactivateCurrentMenu(bl, true);
            this.setCurrentMenu(baseMenuPanel);
            this.refocusWidget();
            baseMenuPanel.onActivate();
        }
    }

    private void pushToStack(BaseMenuPanel baseMenuPanel) {
        this.menuActivationStack.push(baseMenuPanel);
        if (this.menuActivationStack.size() > this.numberToKeepInStack) {
            this.menuActivationStack.remove(0);
        }
    }

    private BaseMenuPanel popFromStack() {
        if (this.menuActivationStack.isEmpty()) {
            return null;
        }
        return this.menuActivationStack.pop();
    }

    protected void deactivateCurrentMenu(boolean bl, boolean bl2) {
        BaseMenuPanel baseMenuPanel = this.getCurrentMenu();
        this.deactivateMenu(baseMenuPanel, bl, bl2);
    }

    protected void deactivateMenu(BaseMenuPanel baseMenuPanel, boolean bl, boolean bl2) {
        if (baseMenuPanel != null) {
            baseMenuPanel.onDeactivate();
            baseMenuPanel.setEnabled(false);
            baseMenuPanel.getMover().clearListeners();
            baseMenuPanel.getMover().clearTranslationQueue();
            if (bl2) {
                this.tempVec.set(this.childPanelPosition).addLocal(this.panelMoveForwardVector);
            } else {
                this.tempVec.set(this.childPanelPosition).addLocal(this.panelMoveBackVector);
            }
            if (bl) {
                baseMenuPanel.getMover().setPosition(this.childPanelPosition);
                baseMenuPanel.getMover().translateTo(this.tempVec, this.panelMoveTime, this.panelRemoveTime);
                baseMenuPanel.getMover().add(this.detachWhenDone);
            } else {
                baseMenuPanel.getMover().setPosition(this.tempVec);
                this.getGuiNode().detachChild(baseMenuPanel.getSpatial());
            }
        }
    }

    protected BaseMenuPanel activateMenu(String string, boolean bl, boolean bl2) {
        BaseMenuPanel baseMenuPanel = this.findMenu(string);
        if (baseMenuPanel != null) {
            this.activateMenu(baseMenuPanel, bl, bl2);
        } else {
            logger.info(this.getName() + ": Could not find menu named \"" + string + "\" to activate.");
        }
        return baseMenuPanel;
    }

    protected void activateMenu(BaseMenuPanel baseMenuPanel, boolean bl, boolean bl2) {
        this.getGuiNode().attachChild(baseMenuPanel.getSpatial());
        baseMenuPanel.setEnabled(true);
        baseMenuPanel.getMover().clearListeners();
        baseMenuPanel.getMover().clearTranslationQueue();
        if (bl2) {
            this.tempVec.set(this.childPanelPosition).addLocal(this.panelMoveBackVector);
        } else {
            this.tempVec.set(this.childPanelPosition).addLocal(this.panelMoveForwardVector);
        }
        if (bl) {
            baseMenuPanel.getMover().setPosition(this.tempVec);
            baseMenuPanel.getMover().translateTo(this.childPanelPosition, this.panelMoveTime, this.panelRemoveTime);
        } else {
            baseMenuPanel.getMover().setPosition(this.childPanelPosition);
        }
    }

    protected BaseMenuPanel getCurrentMenu() {
        return this.currentMenu;
    }

    protected void setCurrentMenu(BaseMenuPanel baseMenuPanel) {
        this.currentMenu = baseMenuPanel;
    }

    public BaseMenuPanel findMenu(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.menus.size(); ++i) {
            if (!string.equals(this.menus.get(i).getName())) continue;
            return this.menus.get(i);
        }
        return null;
    }

    public GuiHandler getGui() {
        return this.gui;
    }

    public void setMenuToSwitchToWhenReady(String string) {
        this.menuToSwitchToWhenReady = string;
    }

    public Vector3f getChildPanelPosition() {
        return this.childPanelPosition;
    }

    public void setChildPanelPosition(Vector3f vector3f) {
        this.childPanelPosition.set(vector3f);
    }

    protected void setPanelPosition(float f, float f2) {
        this.panelPositionX = f;
        this.panelPositionY = f2;
        this.childPanelPosition.set(this.size.x * f, this.size.y * f2, 0.0f);
    }

    private class DetachWhenDone
    implements IControllerListener {
        private DetachWhenDone() {
        }

        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            if (abstractSpatialController.getSpatial().getParent() != null) {
                abstractSpatialController.getSpatial().getParent().detachChild(abstractSpatialController.getSpatial());
            }
        }
    }
}

