/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.input.joystick.JoystickInput;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.checkbox.CheckBox;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.listeners.ICheckBoxChanged;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.InputData;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.msm.states.menus.ConfigureGamepadMenuPanel;
import com.turborilla.msm.states.menus.ConfigureKeyboardMenuPanel;
import com.turborilla.msm.states.menus.ConfigureMouseMenuPanel;

public class ArcadeControlsMenuPanel
extends BaseMenuPanel {
    private CheckBox gamepadCheckBox;
    private CheckBox keyboardCheckBox;
    private CheckBox mouseCheckBox;
    private ConfigureGamepadMenuPanel gamepadMenu;
    private ConfigureKeyboardMenuPanel keyboardMenu;
    private ConfigureMouseMenuPanel mouseMenu;
    private MenuButton configureGamepadButton;

    public ArcadeControlsMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings, ConfigureGamepadMenuPanel configureGamepadMenuPanel, ConfigureKeyboardMenuPanel configureKeyboardMenuPanel, ConfigureMouseMenuPanel configureMouseMenuPanel) {
        super("ArcadeControls", f, f2, guiHandler, gameSettings);
        this.gamepadMenu = configureGamepadMenuPanel;
        this.keyboardMenu = configureKeyboardMenuPanel;
        this.mouseMenu = configureMouseMenuPanel;
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(4.0f, 1.0f);
        this.setLayout(variableRowLayout);
        this.initGUI();
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI() {
        ColumnLayout columnLayout = new ColumnLayout();
        this.getLayout().add(columnLayout);
        VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
        variableColumnLayout.setColumns(4.0f, 3.0f);
        columnLayout.add(variableColumnLayout);
        VariableColumnLayout variableColumnLayout2 = new VariableColumnLayout();
        variableColumnLayout2.setColumns(4.0f, 3.0f);
        columnLayout.add(variableColumnLayout2);
        VariableColumnLayout variableColumnLayout3 = new VariableColumnLayout();
        variableColumnLayout3.setColumns(4.0f, 3.0f);
        columnLayout.add(variableColumnLayout3);
        this.gamepadCheckBox = new CheckBox("GamepadControlsCheckbox", 1.0f, 1.0f, "Gamepad", true, 0.1f);
        variableColumnLayout.add(this.gamepadCheckBox);
        this.keyboardCheckBox = new CheckBox("KeyboardControlsCheckbox", 1.0f, 1.0f, "Keyboard", true, 0.1f);
        variableColumnLayout2.add(this.keyboardCheckBox);
        this.mouseCheckBox = new CheckBox("MouseControlsCheckbox", 1.0f, 1.0f, "Mouse", true, 0.1f);
        variableColumnLayout3.add(this.mouseCheckBox);
        this.gamepadCheckBox.setUncheckable(false);
        this.keyboardCheckBox.setUncheckable(false);
        this.mouseCheckBox.setUncheckable(false);
        this.gamepadCheckBox.setCheckedListener(new ICheckBoxChanged(){

            public void onCheckBoxChanged(CheckBox checkBox, boolean bl) {
                if (bl) {
                    if (ArcadeControlsMenuPanel.this.keyboardCheckBox.isChecked()) {
                        ArcadeControlsMenuPanel.this.keyboardCheckBox.setChecked(false);
                    }
                    if (ArcadeControlsMenuPanel.this.mouseCheckBox.isChecked()) {
                        ArcadeControlsMenuPanel.this.mouseCheckBox.setChecked(false);
                    }
                }
            }
        });
        this.keyboardCheckBox.setCheckedListener(new ICheckBoxChanged(){

            public void onCheckBoxChanged(CheckBox checkBox, boolean bl) {
                if (bl) {
                    if (ArcadeControlsMenuPanel.this.gamepadCheckBox.isChecked()) {
                        ArcadeControlsMenuPanel.this.gamepadCheckBox.setChecked(false);
                    }
                    if (ArcadeControlsMenuPanel.this.mouseCheckBox.isChecked()) {
                        ArcadeControlsMenuPanel.this.mouseCheckBox.setChecked(false);
                    }
                }
            }
        });
        this.mouseCheckBox.setCheckedListener(new ICheckBoxChanged(){

            public void onCheckBoxChanged(CheckBox checkBox, boolean bl) {
                if (bl) {
                    if (ArcadeControlsMenuPanel.this.keyboardCheckBox.isChecked()) {
                        ArcadeControlsMenuPanel.this.keyboardCheckBox.setChecked(false);
                    }
                    if (ArcadeControlsMenuPanel.this.gamepadCheckBox.isChecked()) {
                        ArcadeControlsMenuPanel.this.gamepadCheckBox.setChecked(false);
                    }
                }
            }
        });
        this.configureGamepadButton = new MenuButton("ConfigureGamepadButton", "Configure", 1.0f, 1.0f);
        this.addWidget(this.gamepadCheckBox);
        this.addWidget(this.configureGamepadButton);
        variableColumnLayout.add(this.configureGamepadButton);
        this.configureGamepadButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ArcadeControlsMenuPanel.this.apply();
                ArcadeControlsMenuPanel.this.gamepadMenu.setDifficulty(Difficulty.Arcade);
                ArcadeControlsMenuPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ConfigureGamepad"}});
            }
        });
        MenuButton menuButton = new MenuButton("ConfigureKeyboardButton", "Configure", 1.0f, 1.0f);
        this.addWidget(this.keyboardCheckBox);
        this.addWidget(menuButton);
        variableColumnLayout2.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ArcadeControlsMenuPanel.this.apply();
                ArcadeControlsMenuPanel.this.keyboardMenu.setDifficulty(Difficulty.Arcade);
                ArcadeControlsMenuPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ConfigureKeyboard"}});
            }
        });
        menuButton = new MenuButton("ConfigureMouseButton", "Configure", 1.0f, 1.0f);
        this.addWidget(this.mouseCheckBox);
        this.addWidget(menuButton);
        variableColumnLayout3.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ArcadeControlsMenuPanel.this.apply();
                ArcadeControlsMenuPanel.this.mouseMenu.setDifficulty(Difficulty.Arcade);
                ArcadeControlsMenuPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ConfigureMouse"}});
            }
        });
        columnLayout.add(null);
        RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
        this.getLayout().add(rowLayout);
        rowLayout.setPadding(0.45f, 0.05f);
        menuButton = new MenuButton("OkButton", "Back", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        rowLayout.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ArcadeControlsMenuPanel.this.apply();
                ArcadeControlsMenuPanel.this.getEventManager().fireEvent("PreviousMenu");
            }
        });
        this.reset();
    }

    private void reset() {
        if (this.gamepadCheckBox != null) {
            if (Profile.getCurrentProfile(this.getSettings()).getData(Difficulty.Arcade).getInputData().getDevice() == InputData.Device.Gamepad) {
                this.gamepadCheckBox.setChecked(true);
            } else {
                this.gamepadCheckBox.setChecked(false);
            }
        }
        if (this.mouseCheckBox != null) {
            if (Profile.getCurrentProfile(this.getSettings()).getData(Difficulty.Arcade).getInputData().getDevice() == InputData.Device.Mouse) {
                this.mouseCheckBox.setChecked(true);
            } else {
                this.mouseCheckBox.setChecked(false);
            }
        }
        if (this.keyboardCheckBox != null) {
            if (Profile.getCurrentProfile(this.getSettings()).getData(Difficulty.Arcade).getInputData().getDevice() == InputData.Device.Keyboard) {
                this.keyboardCheckBox.setChecked(true);
            } else {
                this.keyboardCheckBox.setChecked(false);
            }
        }
        if (JoystickInput.get().getJoystickCount() <= 0) {
            this.configureGamepadButton.setEnabled(false);
        }
    }

    private void apply() {
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        InputData inputData = profile.getData(Difficulty.Arcade).getInputData();
        if (this.gamepadCheckBox != null && this.gamepadCheckBox.isChecked()) {
            inputData.setDevice(InputData.Device.Gamepad);
        } else if (this.keyboardCheckBox != null && this.keyboardCheckBox.isChecked()) {
            inputData.setDevice(InputData.Device.Keyboard);
        } else if (this.mouseCheckBox != null && this.mouseCheckBox.isChecked()) {
            inputData.setDevice(InputData.Device.Mouse);
        }
        profile.save();
        inputData.notifyChangeListeners();
    }

    private void cancel() {
        this.reset();
        this.getEventManager().fireEvent("PreviousMenu");
    }

    public void onActivate() {
        this.reset();
        super.onActivate();
    }
}

