/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.game;

import com.jme.system.GameSettings;
import com.turborilla.Updatable;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.states.BaseGameState;
import com.turborilla.sound.CompositeMusicTrack;
import com.turborilla.sound.TurboSoundSystem;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

public class MusicPlayer
extends BaseGameState
implements IEventListener,
Updatable {
    private static final Logger logger = Logger.getLogger(MusicPlayer.class.getName());
    private static final String sourcename = "bgmusic_93485983045";
    private CompositeMusicTrack musicTrack;
    private EventManager eventManager;
    private String[] loadEvents = new String[]{"LoadMusic"};
    private String[] playEvents = new String[]{"PlayMusic"};
    private String[] stopEvents = new String[]{"StopMusic"};
    private String[] pauseEvents = new String[]{"PauseMusic"};
    private String[] volumeEvents = new String[]{"VolumeChanged"};
    private String[] tempVolumeEvents = new String[]{"TemporaryVolumeChanged"};
    private String[] pitchEvents = new String[]{"ChangePitch"};
    private String[] volumeCategories = new String[]{"GameMusicVolume", "GameSFXVolume", "GamePlayerEngineVolume", "GameOpponentEngineVolume"};
    private HashMap<String, Float> permCategoryVolumeMap = new HashMap();
    private TurboSoundSystem soundSystem;
    private String lastPlayedTrackName = null;
    private boolean paused = false;

    public MusicPlayer(EventManager eventManager, GameSettings gameSettings, TurboSoundSystem turboSoundSystem) {
        super("MusicPlayer");
        this.eventManager = eventManager;
        this.soundSystem = turboSoundSystem;
        for (int i = 0; i < this.volumeCategories.length; ++i) {
            String string = this.volumeCategories[i];
            Float f = Float.valueOf(gameSettings.get(string, "1"));
            this.permCategoryVolumeMap.put(string, f);
            turboSoundSystem.setCategoryVolume(string, f.floatValue());
        }
        this.passManager = null;
        if (eventManager != null) {
            this.registerEvents(this.loadEvents);
            this.registerEvents(this.playEvents);
            this.registerEvents(this.stopEvents);
            this.registerEvents(this.pauseEvents);
            this.registerEvents(this.volumeEvents);
            this.registerEvents(this.tempVolumeEvents);
            this.registerEvents(this.pitchEvents);
        }
    }

    private void registerEvents(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.eventManager.registerListener(string, this);
            }
        }
    }

    private boolean checkForEvent(String[] stringArray, ReceivedEvent receivedEvent) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!receivedEvent.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected void play(String string, float f, float f2) throws IOException {
        this.musicTrack = (CompositeMusicTrack)ResourceManager.getInstance().load("music", string, null);
        if (this.musicTrack != null) {
            this.play(this.musicTrack, f, f2);
            this.lastPlayedTrackName = string;
        }
    }

    protected void play(CompositeMusicTrack compositeMusicTrack, float f, float f2) {
        int n = 0;
        for (String string : compositeMusicTrack) {
            if (n == 0) {
                if (!this.soundSystem.playing(sourcename)) {
                    this.soundSystem.backgroundMusic(sourcename, string, true);
                } else {
                    this.soundSystem.fadeOutIn(sourcename, string, (long)(f * 1000.0f), (long)(f2 * 1000.0f));
                }
                this.soundSystem.setVolumeCategory(sourcename, "GameMusicVolume");
            } else {
                this.soundSystem.queueSound(sourcename, string);
            }
            ++n;
        }
    }

    protected void stop(float f) {
        if (this.soundSystem.playing(sourcename)) {
            this.soundSystem.fadeOut(sourcename, null, (long)(f * 1000.0f));
        }
    }

    protected void pause() {
        if (this.soundSystem.playing(sourcename)) {
            this.soundSystem.pause(sourcename);
        }
    }

    protected void setPitch(float f, float f2) {
        this.soundSystem.setPitch(sourcename, f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(ReceivedEvent receivedEvent) {
        if (this.checkForEvent(this.playEvents, receivedEvent)) {
            String string = receivedEvent.getArgumentValue("track");
            String string2 = receivedEvent.getArgumentValue("fadeTime");
            float f = Float.parseFloat(string2 != null ? string2 : "0.2") * 0.5f;
            if (string == null || string.equals(this.lastPlayedTrackName)) {
                if (this.musicTrack != null) {
                    if (this.soundSystem.playing(sourcename)) return;
                    this.play(this.musicTrack, 0.0f, f);
                    return;
                } else {
                    logger.warning(receivedEvent.getName() + " was fired without any argument, even though no previous track was set. Cannot play because of unspecified music track.");
                }
                return;
            } else {
                try {
                    this.play(string, f, f);
                    return;
                }
                catch (IOException iOException) {
                    logger.warning(receivedEvent.getName() + " was fired with track argument \"" + string + "\". Cannot load that track. Exception: " + iOException);
                    this.lastPlayedTrackName = null;
                }
            }
            return;
        } else {
            if (this.checkForEvent(this.loadEvents, receivedEvent)) return;
            if (this.checkForEvent(this.stopEvents, receivedEvent) && this.musicTrack != null) {
                String string = receivedEvent.getArgumentValue("fadeTime");
                float f = Float.parseFloat(string != null ? string : "0");
                this.stop(f);
                return;
            } else if (this.checkForEvent(this.pauseEvents, receivedEvent) && this.musicTrack != null) {
                this.pause();
                return;
            } else if (this.checkForEvent(this.volumeEvents, receivedEvent) && this.musicTrack != null) {
                String string = receivedEvent.getArgumentValue("category");
                float f = Float.parseFloat(receivedEvent.getArgumentValue("volume"));
                this.permCategoryVolumeMap.put(string, Float.valueOf(f));
                this.soundSystem.setCategoryVolume(string, f);
                return;
            } else if (this.checkForEvent(this.tempVolumeEvents, receivedEvent) && this.musicTrack != null) {
                String string = receivedEvent.getArgumentValue("category");
                float f = Float.parseFloat(receivedEvent.getArgumentValue("volume"));
                float f2 = this.permCategoryVolumeMap.get(string).floatValue();
                String string3 = receivedEvent.getArgumentValue("time");
                float f3 = Float.parseFloat(string3 != null ? string3 : "0");
                if (f < 0.0f) {
                    if (string3 == null) {
                        this.soundSystem.setCategoryVolume(string, f2);
                        return;
                    } else {
                        this.soundSystem.setCategoryVolume(string, f2, f3);
                    }
                    return;
                } else if (string3 == null) {
                    this.soundSystem.setCategoryVolume(string, f2 * f);
                    return;
                } else {
                    this.soundSystem.setCategoryVolume(string, f2 * f, f3);
                }
                return;
            } else {
                if (!this.checkForEvent(this.pitchEvents, receivedEvent) || this.musicTrack == null) return;
                float f = Float.parseFloat(receivedEvent.getArgumentValue("factor"));
                String string = receivedEvent.getArgumentValue("time");
                float f4 = Float.parseFloat(string != null ? string : "0");
                this.setPitch(f, f4);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setPaused(boolean bl) {
        if (this.paused != bl) {
            if (bl) {
                if (this.soundSystem.playing(sourcename)) {
                    this.soundSystem.pause(sourcename);
                }
            } else if (!this.soundSystem.playing(sourcename)) {
                this.soundSystem.play(sourcename);
            }
        }
        this.paused = bl;
    }

    public boolean isPaused() {
        return this.musicTrack == null || this.paused;
    }

    public void cleanup() {
        this.eventManager.unregisterListener(this);
    }

    public CompositeMusicTrack getMusicTrack() {
        return this.musicTrack;
    }

    public void setMusicTrack(CompositeMusicTrack compositeMusicTrack) {
        this.musicTrack = compositeMusicTrack;
    }

    protected void stateUpdate(float f) {
    }

    protected void stateRender(float f) {
    }

    protected void onActivate() throws IOException {
    }

    public boolean isRemoveMeFromEventmanager() {
        return false;
    }
}

