/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor.interpolation;

import com.turborilla.msm.states.editor.interpolation.AbstractInterpolator;

public class SineInterpolator
extends AbstractInterpolator {
    private double amplitudeRange = 500.0;
    private double frequencyRange = 2.0;
    private double heightRange = 250.0;
    private double offsetRange = Math.PI * 2;

    public SineInterpolator() {
        this.name = "Wavy";
        this.setTooltip(this.getName(), "Create a wavy curve over the selection");
        this.setParameter("amplitude", 0.2f);
        this.setParameter("height", 0.5f);
        this.setParameter("frequency", 0.5f);
        this.setParameter("offset", 0.5f);
        this.setTooltip("amplitude", "The maximum and minimum height of the waves");
        this.setTooltip("height", "Raise and lower the whole curve");
        this.setTooltip("frequency", "The length of the waves");
        this.setTooltip("offset", "Start of the first wave");
    }

    public int[] interpolate(int[] nArray) {
        if (this.isTakeHeightFromHeightMap()) {
            this.setLeftHeight(nArray[0]);
            this.setRightHeight(nArray[nArray.length - 1]);
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        double d = (double)this.getParameterValue("amplitude") * this.amplitudeRange;
        double d2 = (double)this.getParameterValue("frequency") * this.frequencyRange * (double)n;
        double d3 = (double)this.getParameterValue("height") * this.heightRange - this.heightRange * 0.5;
        double d4 = (double)this.getParameterValue("offset") * this.offsetRange - this.offsetRange * 0.5;
        double d5 = (double)(this.getRightHeight() - this.getLeftHeight()) / (double)(nArray.length - 1);
        for (int i = 0; i < n; ++i) {
            double d6 = (double)i / (double)(n - 1);
            double d7 = (double)this.getLeftHeight() + d5 * (double)i + d * Math.sin(d6 * d2 + d4) + d3;
            nArray2[i] = (int)d7;
        }
        return nArray2;
    }
}

