/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor.interpolation;

import com.turborilla.msm.states.editor.interpolation.AbstractInterpolator;

public class CubicInterpolator
extends AbstractInterpolator {
    private float angle1Range = -10000.0f;
    private float angle2Range = -10000.0f;
    private float tensionRange = 10.0f;
    private float biasRange = 2.0f;

    public CubicInterpolator() {
        this.name = "Curve";
        this.setTooltip(this.getName(), "Create a smoothly curved ramp over the selection");
        this.setParameter("angle1", 0.5f);
        this.setParameter("tension", 0.5f);
        this.setParameter("angle2", 0.5f);
        this.setParameter("bias", 0.5f);
        this.setTooltip("angle1", "The angle of the left part of the curve");
        this.setTooltip("tension", "Controls how much the curve is affected by the angles");
        this.setTooltip("angle2", "The angle of the right part of the curve");
        this.setTooltip("bias", "Controls which of the two angles influences the curve the most");
    }

    public int[] interpolate(int[] nArray) {
        if (this.isTakeHeightFromHeightMap()) {
            this.setLeftHeight(nArray[0]);
            this.setRightHeight(nArray[nArray.length - 1]);
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        double d = this.getParameterValue("angle1") * this.angle1Range - this.angle1Range * 0.5f;
        double d2 = this.getParameterValue("tension") * this.tensionRange - this.tensionRange * 0.5f;
        double d3 = this.getParameterValue("angle2") * this.angle2Range - this.angle2Range * 0.5f;
        double d4 = this.getParameterValue("bias") * this.biasRange - this.biasRange * 0.5f;
        double d5 = this.getLeftHeight();
        double d6 = this.getRightHeight();
        double d7 = d5 + d;
        double d8 = d6 + d3;
        for (int i = 0; i < n; ++i) {
            double d9 = (double)i / (double)(n - 1);
            double d10 = this.hermiteInterpolate(d7, d5, d6, d8, d9, d2, d4);
            nArray2[i] = (int)d10;
        }
        return nArray2;
    }

    private int cubicInterpolate(double d, double d2, double d3, double d4, double d5) {
        double d6 = d5 * d5;
        double d7 = d4 - d3 - d + d2;
        double d8 = d - d2 - d7;
        double d9 = d3 - d;
        double d10 = d2;
        return (int)(d7 * d5 * d6 + d8 * d6 + d9 * d5 + d10);
    }

    private double hermiteInterpolate(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d5 * d5;
        double d9 = d8 * d5;
        double d10 = (d2 - d) * (1.0 + d7) * (1.0 - d6) / 2.0;
        d10 += (d3 - d2) * (1.0 - d7) * (1.0 - d6) / 2.0;
        double d11 = (d3 - d2) * (1.0 + d7) * (1.0 - d6) / 2.0;
        double d12 = 2.0 * d9 - 3.0 * d8 + 1.0;
        double d13 = d9 - 2.0 * d8 + d5;
        double d14 = d9 - d8;
        double d15 = -2.0 * d9 + 3.0 * d8;
        return d12 * d2 + d13 * d10 + d14 * (d11 += (d4 - d3) * (1.0 - d7) * (1.0 - d6) / 2.0) + d15 * d3;
    }
}

