/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor.challenge;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.BorderPanel;
import com.turborilla.msm.gui.turbogui.textfield.TextField;
import com.turborilla.msm.states.editor.ToolTipOnMouseOver;
import com.turborilla.msm.states.editor.challenge.IChallenge;
import java.util.HashMap;
import java.util.Map;

public class ChallengePanel
extends BorderPanel {
    private IChallenge challenge;
    private Map<String, TextField> parameterFields;
    private MenuButton applyButton;
    private MenuButton cancelButton;

    public ChallengePanel(DisplaySystem displaySystem, GuiHandler guiHandler, IChallenge iChallenge) {
        super("ChallengePanel", (float)displaySystem.getWidth() * 0.9f, (float)displaySystem.getHeight() * 0.4f, guiHandler, "corner", "edge", "combobox", 0.4f);
        this.challenge = iChallenge;
        this.parameterFields = new HashMap<String, TextField>();
        this.init(displaySystem, guiHandler);
    }

    private void init(DisplaySystem displaySystem, GuiHandler guiHandler) {
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.0f, 14.6f, 1.9f);
        variableRowLayout.add(null);
        variableRowLayout.setPadding(0.02f, 0.03f);
        this.setLayout(variableRowLayout);
        VariableRowLayout variableRowLayout2 = new VariableRowLayout();
        variableRowLayout2.setRows(5.0f, 1.5f);
        variableRowLayout.add(variableRowLayout2);
        VariableRowLayout variableRowLayout3 = new VariableRowLayout();
        variableRowLayout3.setRows(1.0f, 1.0f, 1.0f, 1.0f);
        variableRowLayout2.add(variableRowLayout3);
        VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
        variableColumnLayout.setColumns(3.0f, 2.0f, 2.0f, 3.0f);
        variableColumnLayout.add(null);
        variableColumnLayout.setPadding(0.1f, 0.2f);
        variableRowLayout2.add(variableColumnLayout);
        BaseLayout baseLayout = new BaseLayout();
        variableColumnLayout.add(baseLayout);
        BaseLayout baseLayout2 = new BaseLayout();
        variableColumnLayout.add(baseLayout2);
        Label label = new Label(this.getName() + "ToolTipLabel", this.challenge.getTooltip(this.challenge.getName()), this.getWidth() * 0.9f, this.getHeight() * 0.05f, "normal_small_black", null);
        label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.addWidget(label, new Vector2f(0.5f, 0.07f), true, true);
        variableRowLayout.add(label);
        String[] stringArray = this.challenge.getParameters();
        for (int i = 0; i < stringArray.length; ++i) {
            VariableColumnLayout variableColumnLayout2 = new VariableColumnLayout();
            variableColumnLayout2.setColumns(4.0f, 1.0f, 3.0f);
            variableColumnLayout2.setPadding(0.05f, 0.15f);
            variableRowLayout3.add(variableColumnLayout2);
            Label label2 = new Label("ParameterLabel:" + stringArray[i], stringArray[i], 1.0f, 1.0f, "textfontblack", null);
            label2.setHorisontalAlignment(HorisontalAlignment.RIGHT);
            this.addWidget(label2);
            variableColumnLayout2.add(label2);
            TextField textField = new TextField("TextField:" + stringArray[i], "" + this.challenge.getParameterValue(stringArray[i]), (float)displaySystem.getWidth() * 0.2f, (float)displaySystem.getHeight() * 0.07f, 5, "menufont", "menufontover", (float)displaySystem.getHeight() / 512.0f);
            textField.setValidChars("0123456789");
            variableColumnLayout2.add(textField);
            this.parameterFields.put(stringArray[i], textField);
            textField.setMouseOverListener(new ToolTipOnMouseOver(this.challenge.getTooltip(stringArray[i]), label));
            this.addWidget(textField);
        }
        this.applyButton = new MenuButton(this.getName() + "ApplyButton", "Apply", 1.0f, 1.0f);
        this.addWidget(this.applyButton);
        baseLayout.add(this.applyButton);
        this.applyButton.setMouseOverListener(new ToolTipOnMouseOver("Save changes", label));
        this.applyButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ChallengePanel.this.apply();
            }
        });
        this.cancelButton = new MenuButton(this.getName() + "CancelButton", "Cancel", 1.0f, 1.0f);
        this.addWidget(this.cancelButton);
        baseLayout2.add(this.cancelButton);
        this.cancelButton.setMouseOverListener(new ToolTipOnMouseOver("Close without saving changes", label));
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    protected void apply() {
        String[] stringArray = this.challenge.getParameters();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.challenge.setParameterValue(stringArray[i], Integer.parseInt(this.parameterFields.get(stringArray[i]).getText()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IChallenge getChallenge() {
        return this.challenge;
    }

    public MenuButton getApplyButton() {
        return this.applyButton;
    }

    public MenuButton getCancelButton() {
        return this.cancelButton;
    }
}

