/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.listeners.IListSelectionChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.BorderPanel;
import com.turborilla.msm.gui.turbogui.panel.ScrollableLabelList;
import com.turborilla.msm.states.editor.ToolTipOnMouseOver;
import com.turborilla.msm.states.editor.challenge.IChallenge;
import com.turborilla.msm.track.Track1D;

public class ChallengesPanel
extends BorderPanel {
    private MenuButton closeButton;
    private String fontFile = "normal_small_black";
    private float charSpacing = 1.0f;
    private ScrollableLabelList<IChallenge> availableChallengesList;
    private ScrollableLabelList<IChallenge> chosenChallengesList;
    private MenuButton editButton;
    private MenuButton removeButton;
    private MenuButton addButton;

    public ChallengesPanel(DisplaySystem displaySystem, GuiHandler guiHandler) {
        super("ChallengesPanel", (float)displaySystem.getWidth() * 0.9f, (float)displaySystem.getHeight() * 0.4f, guiHandler, "corner", "edge", "combobox", 0.4f);
        this.init(displaySystem, guiHandler);
    }

    private void init(DisplaySystem displaySystem, GuiHandler guiHandler) {
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.0f, 14.6f, 1.9f);
        variableRowLayout.add(null);
        variableRowLayout.setPadding(0.02f, 0.03f);
        this.setLayout(variableRowLayout);
        VariableRowLayout variableRowLayout2 = new VariableRowLayout();
        variableRowLayout2.setRows(5.0f, 1.5f);
        variableRowLayout.add(variableRowLayout2);
        VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
        variableColumnLayout.setColumns(3.0f, 1.5f, 3.0f);
        variableColumnLayout.setPadding(0.15f, 0.2f);
        variableRowLayout2.add(variableColumnLayout);
        BaseLayout baseLayout = new BaseLayout();
        variableColumnLayout.add(baseLayout);
        VariableRowLayout variableRowLayout3 = new VariableRowLayout();
        variableRowLayout3.setRows(1.0f, 1.0f, 1.0f, 1.0f);
        variableRowLayout3.add(null);
        variableColumnLayout.add(variableRowLayout3);
        BaseLayout baseLayout2 = new BaseLayout();
        variableColumnLayout.add(baseLayout2);
        VariableColumnLayout variableColumnLayout2 = new VariableColumnLayout();
        variableColumnLayout2.setColumns(3.0f, 1.5f, 3.0f);
        variableColumnLayout2.setPadding(0.1f, 0.2f);
        variableRowLayout2.add(variableColumnLayout2);
        variableColumnLayout2.add(null);
        BaseLayout baseLayout3 = new BaseLayout();
        baseLayout3.setPadding(0.0f, 0.1f);
        variableColumnLayout2.add(baseLayout3);
        BaseLayout baseLayout4 = new BaseLayout();
        baseLayout4.setPadding(0.55f, 0.1f);
        variableColumnLayout2.add(baseLayout4);
        Label label = new Label(this.getName() + "ToolTipLabel", "Choose challenges to apply to this track by selecting them and clicking 'Add'", this.getWidth() * 0.9f, this.getHeight() * 0.05f, "normal_small_black", null);
        label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.addWidget(label, new Vector2f(0.5f, 0.07f), true, true);
        variableRowLayout.add(label);
        this.closeButton = new MenuButton(this.getName() + "CloseButton", "Close", 1.0f, 1.0f);
        this.addWidget(this.closeButton);
        baseLayout3.add(this.closeButton);
        this.closeButton.setMouseOverListener(new ToolTipOnMouseOver("Close and return to editing", label));
        this.availableChallengesList = new ScrollableLabelList("availableChallengesList", (float)displaySystem.getWidth() * 3.0f / 8.0f, (float)displaySystem.getHeight() * 3.0f / 12.0f, guiHandler, this.fontFile, "corner", "edge", "combobox", 0.3f * ((float)displaySystem.getHeight() / 1024.0f), (float)displaySystem.getHeight() * 0.0325f);
        this.addWidget(this.availableChallengesList);
        baseLayout.add(this.availableChallengesList);
        this.addButton = new MenuButton(this.getName() + "AddButton", ">>", 1.0f, 1.0f);
        this.addWidget(this.addButton);
        variableRowLayout3.add(this.addButton);
        this.addButton.setMouseOverListener(new ToolTipOnMouseOver("Add the selected challenge to the track", label));
        this.addButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ChallengesPanel.this.add();
            }
        });
        this.availableChallengesList.setSimulateClickWidgetOnDoubleClick(this.addButton);
        this.removeButton = new MenuButton(this.getName() + "RemoveButton", "<<", 1.0f, 1.0f);
        this.addWidget(this.removeButton);
        variableRowLayout3.add(this.removeButton);
        this.removeButton.setMouseOverListener(new ToolTipOnMouseOver("Remove the selected challenge from the track", label));
        this.removeButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ChallengesPanel.this.remove();
            }
        });
        this.chosenChallengesList = new ScrollableLabelList("chosenChallengesList", (float)displaySystem.getWidth() * 3.0f / 8.0f, (float)displaySystem.getHeight() * 3.0f / 12.0f, guiHandler, this.fontFile, "corner", "edge", "combobox", 0.3f * ((float)displaySystem.getHeight() / 1024.0f), (float)displaySystem.getHeight() * 0.0325f);
        this.addWidget(this.chosenChallengesList);
        baseLayout2.add(this.chosenChallengesList);
        this.editButton = new MenuButton(this.getName() + "EditButton", "Edit", 1.0f, 1.0f);
        this.addWidget(this.editButton);
        baseLayout4.add(this.editButton);
        this.editButton.setMouseOverListener(new ToolTipOnMouseOver("Edit the parameters of the selected challenge", label));
        this.chosenChallengesList.setSimulateClickWidgetOnDoubleClick(this.editButton);
        IListSelectionChangedListener<IChallenge> iListSelectionChangedListener = new IListSelectionChangedListener<IChallenge>(){

            @Override
            public void onSelectionChanged(ScrollableLabelList<IChallenge> scrollableLabelList, IChallenge iChallenge) {
                ChallengesPanel.this.update();
            }
        };
        this.availableChallengesList.setSelectionChangedListener(iListSelectionChangedListener);
        this.chosenChallengesList.setSelectionChangedListener(iListSelectionChangedListener);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    public void fillLists(Track1D track1D, IChallenge[] iChallengeArray) {
        this.availableChallengesList.clear();
        this.chosenChallengesList.clear();
        for (IChallenge iChallenge : iChallengeArray) {
            if (iChallenge == null) continue;
            IChallenge iChallenge2 = track1D.findChallenge(iChallenge.getClass());
            if (iChallenge2 == null) {
                this.availableChallengesList.addItem(iChallenge);
                continue;
            }
            this.chosenChallengesList.addItem(iChallenge2);
        }
        this.update();
    }

    private void add() {
        IChallenge iChallenge = this.availableChallengesList.getSelected();
        if (iChallenge != null) {
            this.availableChallengesList.removeItem(iChallenge);
            this.chosenChallengesList.addItem(iChallenge);
            this.chosenChallengesList.setSelectedItem(iChallenge);
        }
        this.update();
    }

    private void remove() {
        IChallenge iChallenge = this.chosenChallengesList.getSelected();
        if (iChallenge != null) {
            this.chosenChallengesList.removeItem(iChallenge);
            this.availableChallengesList.addItem(iChallenge);
            this.availableChallengesList.setSelectedItem(iChallenge);
        }
        this.update();
    }

    private void update() {
        if (this.availableChallengesList.getSelected() != null) {
            if (!this.addButton.isEnabled()) {
                this.addButton.setEnabled(true);
            }
        } else if (this.addButton.isEnabled()) {
            this.addButton.setEnabled(false);
        }
        if (this.chosenChallengesList.getSelected() != null) {
            if (!this.removeButton.isEnabled()) {
                this.removeButton.setEnabled(true);
            }
            if (!this.editButton.isEnabled()) {
                this.editButton.setEnabled(true);
            }
        } else {
            if (this.removeButton.isEnabled()) {
                this.removeButton.setEnabled(false);
            }
            if (this.editButton.isEnabled()) {
                this.editButton.setEnabled(false);
            }
        }
    }

    public MenuButton getCloseButton() {
        return this.closeButton;
    }

    public MenuButton getEditButton() {
        return this.editButton;
    }

    public IChallenge getSelectedChosenChallenge() {
        return this.chosenChallengesList.getSelected();
    }

    public IChallenge[] getChosenChallenges() {
        return this.chosenChallengesList.getItems((IChallenge[])new IChallenge[0]);
    }
}

