/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states;

import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateManager;
import com.turborilla.Updatable;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import java.util.Stack;
import java.util.logging.Logger;

public class StateEventListener
implements IEventListener {
    private static final Logger logger = Logger.getLogger(StateEventListener.class.getName());
    private static final Stack<Command> commandStack = new Stack();
    private GameStateManager gsm;

    private StateEventListener() {
    }

    public String getName() {
        return "StateEventListener";
    }

    public StateEventListener(GameStateManager gameStateManager) {
        this.gsm = gameStateManager;
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (this.gsm == null) {
            logger.severe("Received state event even though GameStateManager instance == null, aborting event...");
            return;
        }
        String string = receivedEvent.getName();
        logger.info("State action: \"" + receivedEvent.toString() + "\"");
        Command command = new Command(receivedEvent);
        if (command.action != null) {
            command.executeCommand(this.gsm);
            commandStack.push(command);
        } else {
            if (string == "UndoStateChange") {
                if (commandStack.isEmpty()) {
                    return;
                }
                commandStack.pop().getUndoCommand().executeCommand(this.gsm);
                return;
            }
            if (string == "DeactivateAllStates") {
                this.gsm.deactivateAllChildren();
                return;
            }
            if (string == "CleanupStateManager") {
                this.gsm.cleanup();
                return;
            }
        }
    }

    public boolean isRemoveMeFromEventmanager() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        SWITCH{

            public void executeAction(GameStateManager gameStateManager, String string, String string2) {
                String string3 = string;
                String string4 = string2;
                GameState gameState = null;
                GameState gameState2 = null;
                logger.info("switchTo = \"" + string4 + "\" switchFrom = \"" + string3 + "\"");
                if (string3 != null && (gameState = gameStateManager.getChild(string3)) == null) {
                    logger.severe("Could not find state: " + string3 + ". Action was: " + (Object)((Object)this) + " from \"" + string + "\" to \"" + string2 + "\"");
                }
                if (string4 != null && (gameState2 = gameStateManager.getChild(string4)) == null) {
                    logger.severe("Could not find state: " + string4 + ". Action was: " + (Object)((Object)this) + " from \"" + string + "\" to \"" + string2 + "\"");
                    return;
                }
                if (gameState != null) {
                    gameState.setActive(false);
                }
                if (gameState2 != null) {
                    gameState2.setActive(true);
                }
            }

            public String toString() {
                return "Switch active state";
            }

            public Action getUndoAction() {
                return SWITCH;
            }
        }
        ,
        ACTIVATE{

            public void executeAction(GameStateManager gameStateManager, String string, String string2) {
                String string3 = string;
                GameState gameState = gameStateManager.getChild(string3);
                if (gameState != null) {
                    gameState.setActive(true);
                } else {
                    logger.severe("Could not find state: " + string3 + ". Action was: " + (Object)((Object)this) + " \"" + string + "\"");
                }
            }

            public String toString() {
                return "Activate state named";
            }

            public Action getUndoAction() {
                return DEACTIVATE;
            }
        }
        ,
        DEACTIVATE{

            public void executeAction(GameStateManager gameStateManager, String string, String string2) {
                String string3 = string;
                GameState gameState = gameStateManager.getChild(string3);
                if (gameState != null) {
                    gameState.setActive(false);
                } else {
                    logger.severe("Could not find state: " + string3 + ". Action was: " + (Object)((Object)this) + " \"" + string + "\"");
                }
            }

            public String toString() {
                return "Deactivate state named";
            }

            public Action getUndoAction() {
                return ACTIVATE;
            }
        }
        ,
        PAUSE{

            public void executeAction(GameStateManager gameStateManager, String string, String string2) {
                String string3 = string;
                GameState gameState = gameStateManager.getChild(string3);
                if (gameState != null) {
                    if (gameState instanceof Updatable) {
                        ((Updatable)((Object)gameState)).setPaused(true);
                    } else {
                        logger.severe("Cannot pause state \"" + string3 + "\" since it is not an instance of Updatable. It is an instance of \"" + gameState.getClass().getCanonicalName() + "\"");
                    }
                } else {
                    logger.severe("Could not find state: " + string3 + ". Action was: " + (Object)((Object)this) + " \"" + string + "\"");
                }
            }

            public String toString() {
                return "Pause state named";
            }

            public Action getUndoAction() {
                return UNPAUSE;
            }
        }
        ,
        UNPAUSE{

            public void executeAction(GameStateManager gameStateManager, String string, String string2) {
                String string3 = string;
                GameState gameState = gameStateManager.getChild(string3);
                if (gameState != null) {
                    if (gameState instanceof Updatable) {
                        ((Updatable)((Object)gameState)).setPaused(false);
                    } else {
                        logger.severe("Cannot unpause state \"" + string3 + "\" since it is not an instance of Updatable. It is an instance of \"" + gameState.getClass().getCanonicalName() + "\"");
                    }
                } else {
                    logger.severe("Could not find state: " + string3 + ". Action was: " + (Object)((Object)this) + " \"" + string + "\"");
                }
            }

            public String toString() {
                return "Unpause state named";
            }

            public Action getUndoAction() {
                return PAUSE;
            }
        }
        ,
        PAUSE_ACTIVATE{

            public void executeAction(GameStateManager gameStateManager, String string, String string2) {
                PAUSE.executeAction(gameStateManager, string, null);
                ACTIVATE.executeAction(gameStateManager, string2, null);
            }

            public String toString() {
                return "Pause state and activate another";
            }

            public Action getUndoAction() {
                return DEACTIVATE_UNPAUSE;
            }
        }
        ,
        DEACTIVATE_UNPAUSE{

            public void executeAction(GameStateManager gameStateManager, String string, String string2) {
                DEACTIVATE.executeAction(gameStateManager, string, null);
                UNPAUSE.executeAction(gameStateManager, string2, null);
            }

            public String toString() {
                return "Deactivate state and unpause another";
            }

            public Action getUndoAction() {
                return PAUSE_ACTIVATE;
            }
        };

        protected static final Logger logger;

        public abstract Action getUndoAction();

        public abstract void executeAction(GameStateManager var1, String var2, String var3);

        static {
            logger = Logger.getLogger(Action.class.getCanonicalName());
        }
    }

    private class Command {
        private Action action = null;
        private String arg1;
        private String arg2;

        public Command(ReceivedEvent receivedEvent) {
            if ("SwitchState".equals(receivedEvent.getName())) {
                this.action = Action.SWITCH;
                this.arg1 = receivedEvent.getArgumentValue("switchFrom");
                this.arg2 = receivedEvent.getArgumentValue("switchTo");
            } else if ("ActivateState".equals(receivedEvent.getName())) {
                this.action = Action.ACTIVATE;
                this.arg1 = receivedEvent.getArgumentValue("stateName");
            } else if ("DeactivateState".equals(receivedEvent.getName())) {
                this.action = Action.DEACTIVATE;
                this.arg1 = receivedEvent.getArgumentValue("stateName");
            } else if ("PauseState".equals(receivedEvent.getName())) {
                this.action = Action.PAUSE;
                this.arg1 = receivedEvent.getArgumentValue("stateName");
            } else if ("UnpauseState".equals(receivedEvent.getName())) {
                this.action = Action.UNPAUSE;
                this.arg1 = receivedEvent.getArgumentValue("stateName");
            } else if ("PauseActivateState".equals(receivedEvent.getName())) {
                this.action = Action.PAUSE_ACTIVATE;
                this.arg1 = receivedEvent.getArgumentValue("switchFrom");
                this.arg2 = receivedEvent.getArgumentValue("switchTo");
            } else if ("DeactivateUnpauseState".equals(receivedEvent.getName())) {
                this.action = Action.DEACTIVATE_UNPAUSE;
                this.arg1 = receivedEvent.getArgumentValue("switchFrom");
                this.arg2 = receivedEvent.getArgumentValue("switchTo");
            }
        }

        private Command() {
            this.arg1 = null;
            this.arg2 = null;
        }

        public String toString() {
            if (this.action == null) {
                return null;
            }
            return "action: \"" + (Object)((Object)this.action) + "\" arguments: \"" + this.arg1 + "\" & \"" + this.arg2 + "\"";
        }

        public void executeCommand(GameStateManager gameStateManager) {
            this.action.executeAction(gameStateManager, this.arg1, this.arg2);
        }

        public Command getUndoCommand() {
            Command command = new Command();
            command.action = this.action.getUndoAction();
            if (command.action == Action.SWITCH || command.action == Action.PAUSE_ACTIVATE || command.action == Action.DEACTIVATE_UNPAUSE) {
                command.arg1 = this.arg2;
                command.arg2 = this.arg1;
            }
            return command;
        }
    }
}

