/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states;

import com.jme.image.Texture;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.Label;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.states.BaseGameStateRootNode;
import com.turborilla.msm.states.RenderPass;
import com.turborilla.utils.Font;
import com.turborilla.utils.controllers.SpatialFadeController;
import java.io.IOException;

public class StartupGameState
extends BaseGameStateRootNode {
    private boolean inited = false;
    private String text;
    private String fontName;
    private ColorRGBA fadeInColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private Label label;

    public StartupGameState(String string, String string2, String string3) {
        this.text = string2;
        this.fontName = string3;
        this.setName(string);
    }

    public void setText(String string) {
        this.text = string;
    }

    protected void onActivate() throws IOException {
    }

    protected void stateRender(float f) {
        if (!this.inited) {
            Object object;
            this.inited = true;
            this.rootNode = new Node(this.name + ":rootNode");
            this.initDefaultRenderStates(this.rootNode);
            this.rootRenderPass = new RenderPass(this.name + ":RootRenderPass");
            this.rootRenderPass.add(this.rootNode);
            this.passManager.add(this.rootRenderPass);
            this.rootNode.setRenderQueueMode(4);
            this.rootNode.setCullMode(3);
            DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
            Quad quad = new Quad("screenQuad", displaySystem.getWidth(), displaySystem.getHeight());
            this.rootNode.attachChild(quad);
            quad.setLocalTranslation(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
            try {
                object = (Font)ResourceManager.getInstance().load("font", this.fontName, null);
                this.label = new Label((Font)object, 50);
                this.rootNode.attachChild(this.label);
                this.label.setLocalTranslation(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = new SpatialFadeController(this.rootNode);
            ((SpatialFadeController)object).initRenderStates();
            ((SpatialFadeController)object).setColor(this.fadeInColor);
            try {
                Texture texture = (Texture)ResourceManager.getInstance().load("texture", "turborilla", null);
                Quad quad2 = new Quad("logo", texture.getImage().getWidth(), texture.getImage().getHeight());
                this.rootNode.attachChild(quad2);
                quad2.setLocalTranslation(displaySystem.getWidth() / 2, displaySystem.getHeight() - displaySystem.getHeight() / 4, 0.0f);
                TextureState textureState = displaySystem.getRenderer().createTextureState();
                textureState.setTexture(texture);
                quad2.setRenderState(textureState);
                quad2.updateRenderState();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.label != null) {
            this.label.setText(this.text);
            this.label.center();
            this.label.updateGeometricState(0.016f, true);
        }
    }

    protected void stateUpdate(float f) {
    }
}

