/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states;

import com.acarter.scenemonitor.SceneMonitor;
import com.jme.input.InputHandler;
import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.input.joystick.JoystickInput;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.msm.input.QuitAction;
import com.turborilla.msm.states.BaseGameState;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.io.IOException;

public class GlobalGameState
extends BaseGameState {
    EventManager eventManager;
    InputHandler input;
    boolean doSceneMonitor = false;
    private SceneMonitor sceneMonitor;
    private final JoystickInput joystickInput;
    private boolean doTimeDance;
    private float timeDanceTime;
    private GameSettings settings;
    private StateMachine stateMachine;

    public InputHandler getInput() {
        return this.input;
    }

    public void setInput(InputHandler inputHandler) {
        this.input = inputHandler;
    }

    public GlobalGameState(EventManager eventManager, int n, GameSettings gameSettings) {
        super("GlobalGameState");
        this.eventManager = eventManager;
        this.setName("globalGameState");
        this.input = new InputHandler();
        this.input.addAction(new QuitAction(eventManager), "keyboard", n, -1, false);
        this.input.addAction(new ScreenShotActionListener(), "keyboard", 87, -1, false);
        this.passManager.clearAll();
        this.joystickInput = JoystickInput.get();
        this.doTimeDance = false;
        this.timeDanceTime = 0.0f;
        this.settings = gameSettings;
    }

    public void update(float f) {
        this.input.update(f);
        this.joystickInput.update();
        this.eventManager.handleAllEvents();
        super.update(f);
        if (this.doSceneMonitor) {
            SceneMonitor.getMonitor().updateViewer(f);
        }
        float f2 = 1800.0f;
        if (this.doTimeDance) {
            this.timeDanceTime += f;
            if (this.timeDanceTime > 20.0f) {
                this.timeDanceTime = 0.0f;
                float f3 = Float.parseFloat(this.settings.get("time", "0"));
                if (f3 > f2 && this.getStateMachine() != null) {
                    this.settings.set("time", "" + (f2 - 60.0f));
                    if (!"GameOver".equals(this.getStateMachine().getCurrentState())) {
                        this.getStateMachine().transitionToState("GameOver");
                    }
                }
            }
        }
    }

    public void render(float f) {
        if (this.doSceneMonitor) {
            SceneMonitor.getMonitor().renderViewer(DisplaySystem.getDisplaySystem().getRenderer());
        }
    }

    public void cleanup() {
        this.eventManager.cleanUp();
        this.eventManager = null;
    }

    protected void stateUpdate(float f) {
    }

    protected void stateRender(float f) {
    }

    protected void onActivate() throws IOException {
    }

    public boolean isDoSceneMonitor() {
        return this.doSceneMonitor;
    }

    public void setDoSceneMonitor(boolean bl) {
        this.doSceneMonitor = bl;
        if (bl) {
            this.sceneMonitor = SceneMonitor.getMonitor();
            this.sceneMonitor.showViewer(true);
            this.sceneMonitor.setViewerUpdateInterval(0.5f);
        } else if (this.sceneMonitor != null) {
            this.sceneMonitor.showViewer(false);
            this.sceneMonitor = null;
        }
    }

    public void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public class ScreenShotActionListener
    extends InputAction {
        public void performAction(InputActionEvent inputActionEvent) {
            if (inputActionEvent.getTriggerPressed()) {
                File file = new File(SystemFolder.getScreenshotFolder(""));
                int n = 1;
                File file2 = new File(file, "screenshot" + n + ".png");
                while (file2.exists() && n < 100000) {
                    file2 = new File(file, "screenshot" + ++n + ".png");
                }
                if (!file2.exists()) {
                    DisplaySystem.getDisplaySystem().getRenderer().takeScreenShot(SystemFolder.getScreenshotFolder("") + File.separatorChar + "screenshot" + n);
                }
            }
        }
    }
}

